/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.util;

import com.legstar.coxb.CobolBindingException;
import com.legstar.coxb.CobolComplexType;
import com.legstar.coxb.ICobolArrayComplexBinding;
import com.legstar.coxb.ICobolBinding;
import com.legstar.coxb.ICobolChoiceBinding;
import com.legstar.coxb.ICobolComplexBinding;
import com.legstar.coxb.host.HostException;
import com.legstar.coxb.transform.IHostTransformers;
import com.legstar.coxb.util.ClassLoadingException;
import com.legstar.coxb.util.ClassMethodException;
import com.legstar.coxb.util.ClassUtil;
import com.legstar.coxb.util.JAXBAnnotationException;
import com.legstar.coxb.util.JAXBElementDescriptor;
import com.legstar.coxb.util.NameUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BindingUtil {
    public static final String BIND_SUFFIX = "Binding";
    public static final String WRAPPER_SUFFIX = "Wrapper";
    public static final String JAXB_OBJECTFACTORY_NAME = "ObjectFactory";
    public static final String COXB_PACKAGENAME_SUFFIX = "bind";

    private BindingUtil() {
    }

    public static ICobolBinding lookupBinding(ICobolBinding rootBinding, String bindingName) throws HostException {
        ICobolBinding result;
        if (rootBinding.getBindingName().equals(bindingName)) {
            return rootBinding;
        }
        if (rootBinding instanceof ICobolComplexBinding) {
            for (ICobolBinding childBinding : ((ICobolComplexBinding)rootBinding).getChildrenList()) {
                result = BindingUtil.lookupBinding(childBinding, bindingName);
                if (result == null) continue;
                return result;
            }
        }
        if (rootBinding instanceof ICobolArrayComplexBinding) {
            return BindingUtil.lookupBinding(((ICobolArrayComplexBinding)rootBinding).getComplexItemBinding(), bindingName);
        }
        if (rootBinding instanceof ICobolChoiceBinding) {
            for (ICobolBinding childBinding : ((ICobolChoiceBinding)rootBinding).getAlternativesList()) {
                result = BindingUtil.lookupBinding(childBinding, bindingName);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public static Object newJaxbObjectFactory(String packageName) throws CobolBindingException {
        try {
            return ClassUtil.newObject(packageName, JAXB_OBJECTFACTORY_NAME);
        }
        catch (ClassLoadingException e) {
            throw new CobolBindingException(e);
        }
    }

    public static Object newJaxbObject(Object jaxbObjectFactory, String jaxbClassName) throws CobolBindingException {
        try {
            Method creator = ClassUtil.getCreatorMethod(jaxbObjectFactory, jaxbClassName);
            return creator.invoke(jaxbObjectFactory, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new CobolBindingException(e);
        }
        catch (SecurityException e) {
            throw new CobolBindingException(e);
        }
        catch (IllegalArgumentException e) {
            throw new CobolBindingException(e);
        }
        catch (InvocationTargetException e) {
            throw new CobolBindingException(e);
        }
        catch (ClassMethodException e) {
            throw new CobolBindingException(e);
        }
    }

    public static IHostTransformers newTransformers(String jaxbPackageName, String jaxbClassName) throws CobolBindingException {
        try {
            String coxbPackageName = jaxbPackageName == null ? COXB_PACKAGENAME_SUFFIX : jaxbPackageName + "." + COXB_PACKAGENAME_SUFFIX;
            String transformersClassName = jaxbClassName + "Transformers";
            return (IHostTransformers)ClassUtil.newObject(coxbPackageName, transformersClassName);
        }
        catch (ClassLoadingException e) {
            throw new CobolBindingException(e);
        }
    }

    public static IHostTransformers newTransformers(String jaxbQualifiedClassName) throws CobolBindingException {
        ClassUtil.ClassName className = ClassUtil.toClassName(jaxbQualifiedClassName);
        return BindingUtil.newTransformers(className.packageName, className.className);
    }

    public static String getJavaClassName(String jaxbPackage, String jaxbTypeName) throws CobolBindingException {
        try {
            String qualifiedClassName = ClassUtil.toQualifiedClassName(jaxbPackage, jaxbTypeName);
            Class<?> clazz = ClassUtil.loadClass(qualifiedClassName);
            CobolComplexType annotation = clazz.getAnnotation(CobolComplexType.class);
            if (annotation != null && annotation.javaClassName() != null && annotation.javaClassName().length() > 0) {
                return annotation.javaClassName();
            }
            return qualifiedClassName;
        }
        catch (ClassNotFoundException e) {
            throw new CobolBindingException(e);
        }
    }

    public static Class<?> getJavaClass(Field hostField) throws CobolBindingException {
        Class<?> javaClass = hostField.getType();
        if (javaClass.getName().compareTo("java.util.List") == 0) {
            String jaxbTypeName = hostField.getGenericType().toString();
            jaxbTypeName = jaxbTypeName.substring(jaxbTypeName.indexOf("<") + 1, jaxbTypeName.length() - 1);
            try {
                javaClass = ClassUtil.loadClass(jaxbTypeName);
            }
            catch (ClassNotFoundException e) {
                throw new CobolBindingException(e);
            }
        }
        return javaClass;
    }

    public static String getJaxbTypeName(ICobolBinding binding) {
        if (binding.getJaxbType() == null) {
            return null;
        }
        return ClassUtil.toPropertyType(binding.getJaxbType().getName());
    }

    public static String getCoxbTypeName(ICobolBinding binding) {
        if (binding.getJaxbType() == null) {
            return NameUtil.upperFirstChar(binding.getBindingName()) + binding.getBindingName().substring(1, binding.getBindingName().length()) + BIND_SUFFIX;
        }
        if (binding instanceof ICobolArrayComplexBinding) {
            return BindingUtil.getJaxbTypeName(binding) + WRAPPER_SUFFIX + BIND_SUFFIX;
        }
        return BindingUtil.getJaxbTypeName(binding) + BIND_SUFFIX;
    }

    public static String getFieldName(ICobolBinding binding) {
        return NameUtil.lowerFirstChar(binding.getBindingName()) + binding.getBindingName().substring(1, binding.getBindingName().length());
    }

    public static String getXmlNamespace(String jaxbPackageName, String jaxbTypeName) throws HostException {
        try {
            JAXBElementDescriptor descriptor = new JAXBElementDescriptor(jaxbPackageName, jaxbTypeName);
            return descriptor.getNamespace();
        }
        catch (JAXBAnnotationException e) {
            throw new HostException(e);
        }
    }
}

