/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.transform;

import com.legstar.coxb.CobolBindingException;
import com.legstar.coxb.transform.HostTransformException;
import com.legstar.coxb.transform.HostTransformStatus;
import com.legstar.coxb.transform.IJavaToHostTransformer;
import com.legstar.coxb.transform.IXmlToHostTransformer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractXmlToHostTransformer
implements IXmlToHostTransformer {
    private final Log _log = LogFactory.getLog(AbstractXmlToHostTransformer.class);
    private IJavaToHostTransformer mJavaToHostTransformer;
    private JAXBContext mJaxbContext = null;
    private Unmarshaller mXmlUnmarshaller = null;

    public AbstractXmlToHostTransformer(IJavaToHostTransformer javaToHostTransformer) throws HostTransformException {
        try {
            this.mJavaToHostTransformer = javaToHostTransformer;
            this.mJaxbContext = JAXBContext.newInstance(this.mJavaToHostTransformer.newBinding().getJaxbType());
            this.mXmlUnmarshaller = this.mJaxbContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new HostTransformException(e);
        }
        catch (CobolBindingException e) {
            throw new HostTransformException(e);
        }
    }

    public byte[] transform(Source source, String hostCharset, HostTransformStatus status) throws HostTransformException {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Transforming XML to host data:");
        }
        return this.getJavaToHostTransformer().transform(this.getObjectFromXml(source), hostCharset, status);
    }

    public byte[] transform(Source source, String hostCharset) throws HostTransformException {
        return this.transform(source, hostCharset, new HostTransformStatus());
    }

    public byte[] transform(Source source) throws HostTransformException {
        return this.transform(source, (String)null);
    }

    public byte[] transform(Source source, HostTransformStatus status) throws HostTransformException {
        return this.transform(source, null, status);
    }

    public Object getObjectFromXml(Source source) throws HostTransformException {
        try {
            return this.getXmlUnmarshaller().unmarshal(source, this.getJavaToHostTransformer().newBinding().getJaxbType()).getValue();
        }
        catch (JAXBException e) {
            throw new HostTransformException(e);
        }
        catch (CobolBindingException e) {
            throw new HostTransformException(e);
        }
    }

    public IJavaToHostTransformer getJavaToHostTransformer() {
        return this.mJavaToHostTransformer;
    }

    public Unmarshaller getXmlUnmarshaller() {
        return this.mXmlUnmarshaller;
    }
}

