/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.transform;

import com.legstar.coxb.CobolBindingException;
import com.legstar.coxb.CobolBindingVisitorsFactory;
import com.legstar.coxb.CobolContext;
import com.legstar.coxb.ICobolBindingVisitorsFactory;
import com.legstar.coxb.ICobolComplexBinding;
import com.legstar.coxb.convert.CobolConvertersFactory;
import com.legstar.coxb.convert.ICobolConverters;
import com.legstar.coxb.convert.ICobolConvertersFactory;
import com.legstar.coxb.transform.IHostTransformer;
import com.legstar.coxb.util.ClassLoadingException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractTransformer
implements IHostTransformer {
    private ICobolConverters mCobolConverters;
    private ICobolBindingVisitorsFactory mCobolBindingVisitorsFactory;
    private ConcurrentMap<Long, ICobolComplexBinding> _cobolComplexBindingCache;
    private final Log _log = LogFactory.getLog(this.getClass());

    public AbstractTransformer() {
        this(new CobolContext());
    }

    public AbstractTransformer(String hostCharset) {
        this(new CobolContext());
        this.getCobolContext().setHostCharsetName(hostCharset);
    }

    public AbstractTransformer(CobolContext cobolContext) {
        try {
            ICobolConvertersFactory factory = CobolConvertersFactory.createCobolConvertersFactory();
            this.mCobolConverters = factory.createCobolConverters();
            this.mCobolBindingVisitorsFactory = CobolBindingVisitorsFactory.createCobolBindingVisitorsFactory();
            this.setCobolContext(cobolContext);
            this._cobolComplexBindingCache = new ConcurrentHashMap<Long, ICobolComplexBinding>();
        }
        catch (ClassLoadingException e) {
            throw new RuntimeException(e);
        }
    }

    public ICobolConverters getCobolConverters() {
        return this.mCobolConverters;
    }

    public void setCobolConverters(ICobolConverters cobolConverters) {
        this.mCobolConverters = cobolConverters;
    }

    public CobolContext getCobolContext() {
        return this.getCobolConverters().getCobolContext();
    }

    public void setCobolContext(CobolContext cobolContext) {
        this.getCobolConverters().setCobolContext(cobolContext);
    }

    public ICobolBindingVisitorsFactory getCobolBindingVisitorsFactory() {
        return this.mCobolBindingVisitorsFactory;
    }

    public void setCobolBindingVisitorsFactory(ICobolBindingVisitorsFactory cobolBindingVisitorsFactory) {
        this.mCobolBindingVisitorsFactory = cobolBindingVisitorsFactory;
    }

    public ICobolComplexBinding getCachedBinding() throws CobolBindingException {
        Long id = Thread.currentThread().getId();
        ICobolComplexBinding binding = (ICobolComplexBinding)this._cobolComplexBindingCache.get(id);
        if (binding == null) {
            ICobolComplexBinding newBinding;
            if (this._log.isDebugEnabled()) {
                this._log.debug("Creating new binding for thread: " + id + " object: " + this);
            }
            if ((binding = this._cobolComplexBindingCache.putIfAbsent(id, newBinding = this.newBinding())) == null) {
                binding = newBinding;
            }
        }
        return binding;
    }

    public ICobolComplexBinding getBinding() throws CobolBindingException {
        throw new CobolBindingException("Must override");
    }

    public ICobolComplexBinding newBinding() throws CobolBindingException {
        return this.getBinding();
    }

    public int getByteLength() throws CobolBindingException {
        return this.getCachedBinding().getByteLength();
    }
}

