/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.transform;

import com.legstar.coxb.CobolBindingException;
import com.legstar.coxb.transform.HostTransformException;
import com.legstar.coxb.transform.HostTransformStatus;
import com.legstar.coxb.transform.IHostToJavaTransformer;
import com.legstar.coxb.transform.IHostToXmlTransformer;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractHostToXmlTransformer
implements IHostToXmlTransformer {
    private final Log _log = LogFactory.getLog(AbstractHostToXmlTransformer.class);
    private IHostToJavaTransformer mHostToJavaTransformer;
    private JAXBContext mJaxbContext = null;
    private Marshaller mXmlMarshaller = null;

    public AbstractHostToXmlTransformer(IHostToJavaTransformer hostToJavaTransformer) throws HostTransformException {
        try {
            this.mHostToJavaTransformer = hostToJavaTransformer;
            this.mJaxbContext = JAXBContext.newInstance(this.mHostToJavaTransformer.newBinding().getJaxbType());
            this.mXmlMarshaller = this.mJaxbContext.createMarshaller();
        }
        catch (JAXBException e) {
            throw new HostTransformException(e);
        }
        catch (CobolBindingException e) {
            throw new HostTransformException(e);
        }
    }

    public void transform(byte[] hostData, int offset, Writer writer, String hostCharset, HostTransformStatus status) throws HostTransformException {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Transforming host data to XML:");
        }
        Object valueObject = this.getHostToJavaTransformer().transform(hostData, offset, hostCharset, status);
        this.getXmlFromObject(valueObject, writer);
    }

    public void transform(byte[] hostData, int offset, Writer writer, String hostCharset) throws HostTransformException {
        this.transform(hostData, offset, writer, hostCharset, new HostTransformStatus());
    }

    public void transform(byte[] hostData, Writer writer, String hostCharset) throws HostTransformException {
        this.transform(hostData, 0, writer, hostCharset);
    }

    public void transform(byte[] hostData, Writer writer) throws HostTransformException {
        this.transform(hostData, 0, writer, (String)null);
    }

    public void transform(byte[] hostData, int offset, Writer writer) throws HostTransformException {
        this.transform(hostData, offset, writer, (String)null);
    }

    public void transform(byte[] hostData, Writer writer, String hostCharset, HostTransformStatus status) throws HostTransformException {
        this.transform(hostData, 0, writer, hostCharset, status);
    }

    public void transform(byte[] hostData, Writer writer, HostTransformStatus status) throws HostTransformException {
        this.transform(hostData, 0, writer, null, status);
    }

    public void transform(byte[] hostData, int offset, Writer writer, HostTransformStatus status) throws HostTransformException {
        this.transform(hostData, offset, writer, null, status);
    }

    public void getXmlFromObject(Object valueObject, Writer writer) throws HostTransformException {
        try {
            if (this.isXmlRootElement()) {
                this.getXmlMarshaller().marshal(valueObject, writer);
            } else {
                QName qName = new QName(this.getNamespace(), this.getElementName());
                JAXBElement<Object> jaxbElement = new JAXBElement<Object>(qName, this.getHostToJavaTransformer().newBinding().getJaxbType(), valueObject);
                this.getXmlMarshaller().marshal(jaxbElement, writer);
            }
        }
        catch (JAXBException e) {
            throw new HostTransformException(e);
        }
        catch (CobolBindingException e) {
            throw new HostTransformException(e);
        }
    }

    public abstract boolean isXmlRootElement();

    public abstract String getNamespace();

    public abstract String getElementName();

    public IHostToJavaTransformer getHostToJavaTransformer() {
        return this.mHostToJavaTransformer;
    }

    public JAXBContext getJAXBContext() {
        return this.mJaxbContext;
    }

    public Marshaller getXmlMarshaller() {
        return this.mXmlMarshaller;
    }
}

