/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.impl.visitor;

import com.legstar.coxb.ICobolArrayBinaryBinding;
import com.legstar.coxb.ICobolArrayComplexBinding;
import com.legstar.coxb.ICobolArrayDbcsBinding;
import com.legstar.coxb.ICobolArrayDoubleBinding;
import com.legstar.coxb.ICobolArrayFloatBinding;
import com.legstar.coxb.ICobolArrayNationalBinding;
import com.legstar.coxb.ICobolArrayOctetStreamBinding;
import com.legstar.coxb.ICobolArrayPackedDecimalBinding;
import com.legstar.coxb.ICobolArrayStringBinding;
import com.legstar.coxb.ICobolArrayZonedDecimalBinding;
import com.legstar.coxb.ICobolBinaryBinding;
import com.legstar.coxb.ICobolComplexBinding;
import com.legstar.coxb.ICobolDbcsBinding;
import com.legstar.coxb.ICobolDoubleBinding;
import com.legstar.coxb.ICobolFloatBinding;
import com.legstar.coxb.ICobolNationalBinding;
import com.legstar.coxb.ICobolOctetStreamBinding;
import com.legstar.coxb.ICobolPackedDecimalBinding;
import com.legstar.coxb.ICobolStringBinding;
import com.legstar.coxb.ICobolZonedDecimalBinding;
import com.legstar.coxb.convert.ICobolConverters;
import com.legstar.coxb.host.HostException;
import com.legstar.coxb.impl.visitor.CobolUnmarshalVisitor;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlatCobolUnmarshalVisitor
extends CobolUnmarshalVisitor {
    private Map<String, Object> _keyValues = new LinkedHashMap<String, Object>();
    private String _suffix = "";
    private String _prefix = "";
    private final Log _log = LogFactory.getLog(this.getClass());

    public FlatCobolUnmarshalVisitor(byte[] hostBytes, int offset, ICobolConverters cobolConverters) {
        super(hostBytes, offset, cobolConverters);
    }

    @Override
    public void visit(ICobolComplexBinding ce) throws HostException {
        String prevPrefix = this._prefix;
        this._prefix = this._prefix + "_" + ce.getJaxbName();
        super.visit(ce);
        this._prefix = prevPrefix;
    }

    @Override
    public void visit(ICobolArrayComplexBinding ce) throws HostException {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Unmarshaling started for array of complex bindings " + ce.getBindingName());
        }
        ce.createValueObject();
        String prevSuffix = this._suffix;
        for (int i = 0; i < ce.getCurrentOccurs(); ++i) {
            this._suffix = this._suffix + "_" + Integer.toString(i);
            ICobolComplexBinding itemDesc = ce.getComplexItemBinding();
            itemDesc.accept(this);
            ce.addPropertyValue(i);
            this._suffix = prevSuffix;
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug("Unmarshaling successful for array of complex bindings " + ce.getBindingName());
        }
    }

    @Override
    public void visit(ICobolStringBinding ce) throws HostException {
        super.visit(ce);
        this._keyValues.put(this.uniqueName(ce.getJaxbName() + this._suffix), ce.getStringValue());
    }

    @Override
    public void visit(ICobolArrayStringBinding ce) throws HostException {
        super.visit(ce);
        for (int i = 0; i < ce.getCurrentOccurs(); ++i) {
            String newSuffix = this._suffix + "_" + Integer.toString(i);
            this._keyValues.put(this.uniqueName(ce.getJaxbName() + newSuffix), ce.getStringList().get(i));
        }
    }

    @Override
    public void visit(ICobolNationalBinding ce) throws HostException {
        super.visit(ce);
        this._keyValues.put(this.uniqueName(ce.getJaxbName() + this._suffix), ce.getStringValue());
    }

    @Override
    public void visit(ICobolArrayNationalBinding ce) throws HostException {
        super.visit(ce);
        for (int i = 0; i < ce.getCurrentOccurs(); ++i) {
            String newSuffix = this._suffix + "_" + Integer.toString(i);
            this._keyValues.put(this.uniqueName(ce.getJaxbName() + newSuffix), ce.getStringList().get(i));
        }
    }

    @Override
    public void visit(ICobolDbcsBinding ce) throws HostException {
        super.visit(ce);
        this._keyValues.put(this.uniqueName(ce.getJaxbName() + this._suffix), ce.getStringValue());
    }

    @Override
    public void visit(ICobolArrayDbcsBinding ce) throws HostException {
        super.visit(ce);
        for (int i = 0; i < ce.getCurrentOccurs(); ++i) {
            String newSuffix = this._suffix + "_" + Integer.toString(i);
            this._keyValues.put(this.uniqueName(ce.getJaxbName() + newSuffix), ce.getStringList().get(i));
        }
    }

    @Override
    public void visit(ICobolZonedDecimalBinding ce) throws HostException {
        super.visit(ce);
        this._keyValues.put(this.uniqueName(ce.getJaxbName() + this._suffix), ce.getObjectValue(ce.getJaxbType()));
    }

    @Override
    public void visit(ICobolArrayZonedDecimalBinding ce) throws HostException {
        super.visit(ce);
        for (int i = 0; i < ce.getCurrentOccurs(); ++i) {
            String newSuffix = this._suffix + "_" + Integer.toString(i);
            this._keyValues.put(this.uniqueName(ce.getJaxbName() + newSuffix), ((List)ce.getObjectValue(ce.getJaxbType())).get(i));
        }
    }

    @Override
    public void visit(ICobolPackedDecimalBinding ce) throws HostException {
        super.visit(ce);
        this._keyValues.put(this.uniqueName(ce.getJaxbName() + this._suffix), ce.getObjectValue(ce.getJaxbType()));
    }

    @Override
    public void visit(ICobolArrayPackedDecimalBinding ce) throws HostException {
        super.visit(ce);
        for (int i = 0; i < ce.getCurrentOccurs(); ++i) {
            String newSuffix = this._suffix + "_" + Integer.toString(i);
            this._keyValues.put(this.uniqueName(ce.getJaxbName() + newSuffix), ((List)ce.getObjectValue(ce.getJaxbType())).get(i));
        }
    }

    @Override
    public void visit(ICobolBinaryBinding ce) throws HostException {
        super.visit(ce);
        this._keyValues.put(this.uniqueName(ce.getJaxbName() + this._suffix), ce.getObjectValue(ce.getJaxbType()));
    }

    @Override
    public void visit(ICobolArrayBinaryBinding ce) throws HostException {
        super.visit(ce);
        for (int i = 0; i < ce.getCurrentOccurs(); ++i) {
            String newSuffix = this._suffix + "_" + Integer.toString(i);
            this._keyValues.put(this.uniqueName(ce.getJaxbName() + newSuffix), ((List)ce.getObjectValue(ce.getJaxbType())).get(i));
        }
    }

    @Override
    public void visit(ICobolFloatBinding ce) throws HostException {
        super.visit(ce);
        this._keyValues.put(this.uniqueName(ce.getJaxbName() + this._suffix), ce.getFloatValue());
    }

    @Override
    public void visit(ICobolArrayFloatBinding ce) throws HostException {
        super.visit(ce);
        for (int i = 0; i < ce.getCurrentOccurs(); ++i) {
            String newSuffix = this._suffix + "_" + Integer.toString(i);
            this._keyValues.put(this.uniqueName(ce.getJaxbName() + newSuffix), ce.getFloatList().get(i));
        }
    }

    @Override
    public void visit(ICobolDoubleBinding ce) throws HostException {
        super.visit(ce);
        this._keyValues.put(this.uniqueName(ce.getJaxbName() + this._suffix), ce.getDoubleValue());
    }

    @Override
    public void visit(ICobolArrayDoubleBinding ce) throws HostException {
        super.visit(ce);
        for (int i = 0; i < ce.getCurrentOccurs(); ++i) {
            String newSuffix = this._suffix + "_" + Integer.toString(i);
            this._keyValues.put(this.uniqueName(ce.getJaxbName() + newSuffix), ce.getDoubleList().get(i));
        }
    }

    @Override
    public void visit(ICobolOctetStreamBinding ce) throws HostException {
        super.visit(ce);
        this._keyValues.put(this.uniqueName(ce.getJaxbName() + this._suffix), ce.getByteArrayValue());
    }

    @Override
    public void visit(ICobolArrayOctetStreamBinding ce) throws HostException {
        super.visit(ce);
        for (int i = 0; i < ce.getCurrentOccurs(); ++i) {
            String newSuffix = this._suffix + "_" + Integer.toString(i);
            this._keyValues.put(this.uniqueName(ce.getJaxbName() + newSuffix), ce.getByteArrayList().get(i));
        }
    }

    protected String uniqueName(String proposedName) {
        String[] prefixes = this._prefix.split("_");
        String uniqueName = proposedName;
        for (int pos = prefixes.length - 1; this._keyValues.containsKey(uniqueName) && pos > -1; --pos) {
            uniqueName = prefixes[pos] + '_' + uniqueName;
        }
        return uniqueName;
    }

    public Map<String, Object> getKeyValues() {
        return this._keyValues;
    }
}

