/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.impl.visitor;

import com.legstar.coxb.CobolElementVisitor;
import com.legstar.coxb.ICobolArrayBinaryBinding;
import com.legstar.coxb.ICobolArrayComplexBinding;
import com.legstar.coxb.ICobolArrayDbcsBinding;
import com.legstar.coxb.ICobolArrayDoubleBinding;
import com.legstar.coxb.ICobolArrayFloatBinding;
import com.legstar.coxb.ICobolArrayNationalBinding;
import com.legstar.coxb.ICobolArrayOctetStreamBinding;
import com.legstar.coxb.ICobolArrayPackedDecimalBinding;
import com.legstar.coxb.ICobolArrayStringBinding;
import com.legstar.coxb.ICobolArrayZonedDecimalBinding;
import com.legstar.coxb.ICobolBinaryBinding;
import com.legstar.coxb.ICobolBinding;
import com.legstar.coxb.ICobolChoiceBinding;
import com.legstar.coxb.ICobolComplexBinding;
import com.legstar.coxb.ICobolDbcsBinding;
import com.legstar.coxb.ICobolDoubleBinding;
import com.legstar.coxb.ICobolFloatBinding;
import com.legstar.coxb.ICobolNationalBinding;
import com.legstar.coxb.ICobolOctetStreamBinding;
import com.legstar.coxb.ICobolPackedDecimalBinding;
import com.legstar.coxb.ICobolStringBinding;
import com.legstar.coxb.ICobolZonedDecimalBinding;
import com.legstar.coxb.convert.ICobolConverters;
import com.legstar.coxb.host.HostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CobolUnmarshalVisitor
extends CobolElementVisitor {
    private final Log _log = LogFactory.getLog(this.getClass());

    public CobolUnmarshalVisitor(byte[] hostBytes, int offset, ICobolConverters cobolConverters) {
        super(hostBytes, offset, cobolConverters);
    }

    public void visit(ICobolComplexBinding ce) throws HostException {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Unmarshaling started for complex binding " + ce.getBindingName());
        }
        if (!this.exists(ce)) {
            return;
        }
        ce.createValueObject();
        int index = 0;
        for (ICobolBinding child : ce.getChildrenList()) {
            child.accept(this);
            ce.setPropertyValue(index++);
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug("Unmarshaling successful for complex binding " + ce.getBindingName());
        }
    }

    public void visit(ICobolChoiceBinding ce) throws HostException {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Unmarshaling started for choice binding " + ce.getBindingName());
        }
        int maxAlternaliveLength = 0;
        for (ICobolBinding alternative : ce.getAlternativesList()) {
            alternative.setObjectValue(null);
            if (alternative.getByteLength() <= maxAlternaliveLength) continue;
            maxAlternaliveLength = alternative.getByteLength();
        }
        ICobolBinding chosenAlternative = null;
        if (ce.getUnmarshalChoiceStrategy() != null) {
            if (this._log.isDebugEnabled()) {
                this._log.debug("Calling Unmarshal choice strategy  " + ce.getUnmarshalChoiceStrategyClassName());
            }
            if ((chosenAlternative = ce.getUnmarshalChoiceStrategy().choose(ce, this.getVariablesMap(), this)) != null) {
                chosenAlternative.accept(this);
            }
        }
        if (chosenAlternative == null) {
            for (ICobolBinding alt : ce.getAlternativesList()) {
                int savedOffset = this.getStartOffset();
                try {
                    alt.accept(this);
                    chosenAlternative = alt;
                    break;
                }
                catch (HostException he) {
                    this.setOffset(savedOffset);
                }
            }
        }
        if (chosenAlternative == null) {
            throw new HostException("No alternative found for choice element " + ce.getBindingName());
        }
        ce.setPropertyValue(ce.getAlternativesList().indexOf(chosenAlternative));
        if (chosenAlternative.getByteLength() < maxAlternaliveLength) {
            this.setVirtualFillerLength(maxAlternaliveLength - chosenAlternative.getByteLength());
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug("Unmarshaling successful for choice binding " + ce.getBindingName());
        }
    }

    public void visit(ICobolArrayComplexBinding ce) throws HostException {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Unmarshaling started for array of complex bindings " + ce.getBindingName());
        }
        ce.createValueObject();
        for (int i = 0; i < ce.getCurrentOccurs(); ++i) {
            ICobolComplexBinding itemDesc = ce.getComplexItemBinding();
            itemDesc.accept(this);
            ce.addPropertyValue(i);
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug("Unmarshaling successful for array of complex bindings " + ce.getBindingName());
        }
    }

    public void visit(ICobolStringBinding ce) throws HostException {
        if (!this.exists(ce)) {
            return;
        }
        this.setOffset(this.getCobolConverters().getCobolStringConverter().fromHost(ce, this.getHostBytes(), this.getStartOffset()));
        if (ce.isCustomVariable()) {
            this.storeCustomVariable(ce);
        }
    }

    public void visit(ICobolArrayStringBinding ce) throws HostException {
        this.setOffset(this.getCobolConverters().getCobolStringConverter().fromHost(ce, this.getHostBytes(), this.getStartOffset(), ce.getCurrentOccurs()));
    }

    public void visit(ICobolNationalBinding ce) throws HostException {
        if (!this.exists(ce)) {
            return;
        }
        this.setOffset(this.getCobolConverters().getCobolNationalConverter().fromHost(ce, this.getHostBytes(), this.getStartOffset()));
        if (ce.isCustomVariable()) {
            this.storeCustomVariable(ce);
        }
    }

    public void visit(ICobolArrayNationalBinding ce) throws HostException {
        this.setOffset(this.getCobolConverters().getCobolNationalConverter().fromHost(ce, this.getHostBytes(), this.getStartOffset(), ce.getCurrentOccurs()));
    }

    public void visit(ICobolDbcsBinding ce) throws HostException {
        if (!this.exists(ce)) {
            return;
        }
        this.setOffset(this.getCobolConverters().getCobolDbcsConverter().fromHost(ce, this.getHostBytes(), this.getStartOffset()));
        if (ce.isCustomVariable()) {
            this.storeCustomVariable(ce);
        }
    }

    public void visit(ICobolArrayDbcsBinding ce) throws HostException {
        this.setOffset(this.getCobolConverters().getCobolDbcsConverter().fromHost(ce, this.getHostBytes(), this.getStartOffset(), ce.getCurrentOccurs()));
    }

    public void visit(ICobolZonedDecimalBinding ce) throws HostException {
        if (!this.exists(ce)) {
            return;
        }
        this.setOffset(this.getCobolConverters().getCobolZonedDecimalConverter().fromHost(ce, this.getHostBytes(), this.getStartOffset()));
        if (ce.isCustomVariable()) {
            this.storeCustomVariable(ce);
        }
    }

    public void visit(ICobolArrayZonedDecimalBinding ce) throws HostException {
        this.setOffset(this.getCobolConverters().getCobolZonedDecimalConverter().fromHost(ce, this.getHostBytes(), this.getStartOffset(), ce.getCurrentOccurs()));
    }

    public void visit(ICobolPackedDecimalBinding ce) throws HostException {
        if (!this.exists(ce)) {
            return;
        }
        this.setOffset(this.getCobolConverters().getCobolPackedDecimalConverter().fromHost(ce, this.getHostBytes(), this.getStartOffset()));
        if (ce.isCustomVariable()) {
            this.storeCustomVariable(ce);
        }
    }

    public void visit(ICobolArrayPackedDecimalBinding ce) throws HostException {
        this.setOffset(this.getCobolConverters().getCobolPackedDecimalConverter().fromHost(ce, this.getHostBytes(), this.getStartOffset(), ce.getCurrentOccurs()));
    }

    public void visit(ICobolBinaryBinding ce) throws HostException {
        if (!this.exists(ce)) {
            return;
        }
        this.setOffset(this.getCobolConverters().getCobolBinaryConverter().fromHost(ce, this.getHostBytes(), this.getStartOffset()));
        if (ce.isCustomVariable()) {
            this.storeCustomVariable(ce);
        }
    }

    public void visit(ICobolArrayBinaryBinding ce) throws HostException {
        this.setOffset(this.getCobolConverters().getCobolBinaryConverter().fromHost(ce, this.getHostBytes(), this.getStartOffset(), ce.getCurrentOccurs()));
    }

    public void visit(ICobolFloatBinding ce) throws HostException {
        if (!this.exists(ce)) {
            return;
        }
        this.setOffset(this.getCobolConverters().getCobolFloatConverter().fromHost(ce, this.getHostBytes(), this.getStartOffset()));
        if (ce.isCustomVariable()) {
            this.storeCustomVariable(ce);
        }
    }

    public void visit(ICobolArrayFloatBinding ce) throws HostException {
        this.setOffset(this.getCobolConverters().getCobolFloatConverter().fromHost(ce, this.getHostBytes(), this.getStartOffset(), ce.getCurrentOccurs()));
    }

    public void visit(ICobolDoubleBinding ce) throws HostException {
        if (!this.exists(ce)) {
            return;
        }
        this.setOffset(this.getCobolConverters().getCobolDoubleConverter().fromHost(ce, this.getHostBytes(), this.getStartOffset()));
        if (ce.isCustomVariable()) {
            this.storeCustomVariable(ce);
        }
    }

    public void visit(ICobolArrayDoubleBinding ce) throws HostException {
        this.setOffset(this.getCobolConverters().getCobolDoubleConverter().fromHost(ce, this.getHostBytes(), this.getStartOffset(), ce.getCurrentOccurs()));
    }

    public void visit(ICobolOctetStreamBinding ce) throws HostException {
        if (!this.exists(ce)) {
            return;
        }
        this.setOffset(this.getCobolConverters().getCobolOctetStreamConverter().fromHost(ce, this.getHostBytes(), this.getStartOffset()));
        if (ce.isCustomVariable()) {
            this.storeCustomVariable(ce);
        }
    }

    public void visit(ICobolArrayOctetStreamBinding ce) throws HostException {
        this.setOffset(this.getCobolConverters().getCobolOctetStreamConverter().fromHost(ce, this.getHostBytes(), this.getStartOffset(), ce.getCurrentOccurs()));
    }
}

