/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.impl.visitor;

import com.legstar.coxb.CobolElementVisitor;
import com.legstar.coxb.ICobolArrayBinaryBinding;
import com.legstar.coxb.ICobolArrayComplexBinding;
import com.legstar.coxb.ICobolArrayDbcsBinding;
import com.legstar.coxb.ICobolArrayDoubleBinding;
import com.legstar.coxb.ICobolArrayFloatBinding;
import com.legstar.coxb.ICobolArrayNationalBinding;
import com.legstar.coxb.ICobolArrayOctetStreamBinding;
import com.legstar.coxb.ICobolArrayPackedDecimalBinding;
import com.legstar.coxb.ICobolArrayStringBinding;
import com.legstar.coxb.ICobolArrayZonedDecimalBinding;
import com.legstar.coxb.ICobolBinaryBinding;
import com.legstar.coxb.ICobolBinding;
import com.legstar.coxb.ICobolChoiceBinding;
import com.legstar.coxb.ICobolComplexBinding;
import com.legstar.coxb.ICobolDbcsBinding;
import com.legstar.coxb.ICobolDoubleBinding;
import com.legstar.coxb.ICobolElement;
import com.legstar.coxb.ICobolFloatBinding;
import com.legstar.coxb.ICobolNationalBinding;
import com.legstar.coxb.ICobolOctetStreamBinding;
import com.legstar.coxb.ICobolPackedDecimalBinding;
import com.legstar.coxb.ICobolStringBinding;
import com.legstar.coxb.ICobolZonedDecimalBinding;
import com.legstar.coxb.convert.ICobolConverters;
import com.legstar.coxb.host.HostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CobolMarshalVisitor
extends CobolElementVisitor {
    private final Log _log = LogFactory.getLog(CobolMarshalVisitor.class);

    public CobolMarshalVisitor(byte[] hostBytes, int offset, ICobolConverters cobolConverters) {
        super(hostBytes, offset, cobolConverters);
    }

    public void visit(ICobolComplexBinding ce) throws HostException {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Marshaling started for complex binding " + ce.getBindingName());
        }
        HashMap<ICobolBinding, Integer> dynCounters = null;
        if (!this.exists(ce)) {
            return;
        }
        ce.setChildrenValues();
        for (ICobolBinding child : ce.getChildrenList()) {
            if (child.isODOObject()) {
                if (dynCounters == null) {
                    dynCounters = new HashMap<ICobolBinding, Integer>();
                }
                dynCounters.put(child, this.getStartOffset());
            }
            child.accept(this);
        }
        if (dynCounters != null) {
            int endOffset = this.getStartOffset();
            for (Map.Entry entry : dynCounters.entrySet()) {
                this.setOffset((Integer)entry.getValue());
                ((ICobolBinding)entry.getKey()).accept(this);
            }
            this.setOffset(endOffset);
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug("Marshaling successful for complex binding " + ce.getBindingName());
        }
    }

    public void visit(ICobolChoiceBinding ce) throws HostException {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Marshaling started for choice binding " + ce.getBindingName());
        }
        ce.setAlternativesValues();
        int maxAlternaliveLength = 0;
        for (ICobolBinding alternative : ce.getAlternativesList()) {
            if (alternative.getByteLength() <= maxAlternaliveLength) continue;
            maxAlternaliveLength = alternative.getByteLength();
        }
        ICobolElement chosenAlternative = null;
        if (ce.getMarshalChoiceStrategy() != null) {
            if (this._log.isDebugEnabled()) {
                this._log.debug("Calling Marshal choice strategy  " + ce.getMarshalChoiceStrategyClassName());
            }
            if ((chosenAlternative = ce.getMarshalChoiceStrategy().choose(ce, this.getVariablesMap(), this)) != null) {
                chosenAlternative.accept(this);
            }
        }
        if (chosenAlternative == null) {
            for (ICobolBinding alt : ce.getAlternativesList()) {
                if (!alt.isSet()) continue;
                int savedOffset = this.getStartOffset();
                alt.accept(this);
                if (savedOffset >= this.getStartOffset()) continue;
                chosenAlternative = alt;
                break;
            }
        }
        if (chosenAlternative == null) {
            throw new HostException("No alternative found for choice element " + ce.getBindingName());
        }
        if (chosenAlternative.getByteLength() < maxAlternaliveLength) {
            this.setVirtualFillerLength(maxAlternaliveLength - chosenAlternative.getByteLength());
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug("Marshaling successful for choice binding " + ce.getBindingName());
        }
    }

    public void visit(ICobolArrayComplexBinding ce) throws HostException {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Marshaling started for array of complex bindings " + ce.getBindingName());
        }
        int currentOccurs = ce.getCurrentOccurs();
        for (int i = 0; i < currentOccurs; ++i) {
            ce.setItemValue(i);
            ICobolComplexBinding itemDesc = ce.getComplexItemBinding();
            itemDesc.accept(this);
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug("Marshaling successful for array of complex bindings " + ce.getBindingName());
        }
    }

    public void visit(ICobolStringBinding ce) throws HostException {
        if (!this.exists(ce)) {
            return;
        }
        this.setOffset(this.getCobolConverters().getCobolStringConverter().toHost(ce, this.getHostBytes(), this.getStartOffset()));
        if (ce.isCustomVariable()) {
            this.storeCustomVariable(ce);
        }
    }

    public void visit(ICobolArrayStringBinding ce) throws HostException {
        this.setOffset(this.getCobolConverters().getCobolStringConverter().toHost(ce, this.getHostBytes(), this.getStartOffset(), ce.getCurrentOccurs()));
    }

    public void visit(ICobolNationalBinding ce) throws HostException {
        if (!this.exists(ce)) {
            return;
        }
        this.setOffset(this.getCobolConverters().getCobolNationalConverter().toHost(ce, this.getHostBytes(), this.getStartOffset()));
        if (ce.isCustomVariable()) {
            this.storeCustomVariable(ce);
        }
    }

    public void visit(ICobolArrayNationalBinding ce) throws HostException {
        this.setOffset(this.getCobolConverters().getCobolNationalConverter().toHost(ce, this.getHostBytes(), this.getStartOffset(), ce.getCurrentOccurs()));
    }

    public void visit(ICobolDbcsBinding ce) throws HostException {
        if (!this.exists(ce)) {
            return;
        }
        this.setOffset(this.getCobolConverters().getCobolDbcsConverter().toHost(ce, this.getHostBytes(), this.getStartOffset()));
        if (ce.isCustomVariable()) {
            this.storeCustomVariable(ce);
        }
    }

    public void visit(ICobolArrayDbcsBinding ce) throws HostException {
        this.setOffset(this.getCobolConverters().getCobolDbcsConverter().toHost(ce, this.getHostBytes(), this.getStartOffset(), ce.getCurrentOccurs()));
    }

    public void visit(ICobolZonedDecimalBinding ce) throws HostException {
        if (!this.exists(ce)) {
            return;
        }
        this.setOffset(this.getCobolConverters().getCobolZonedDecimalConverter().toHost(ce, this.getHostBytes(), this.getStartOffset()));
        if (ce.isCustomVariable()) {
            this.storeCustomVariable(ce);
        }
    }

    public void visit(ICobolArrayZonedDecimalBinding ce) throws HostException {
        this.setOffset(this.getCobolConverters().getCobolZonedDecimalConverter().toHost(ce, this.getHostBytes(), this.getStartOffset(), ce.getCurrentOccurs()));
    }

    public void visit(ICobolPackedDecimalBinding ce) throws HostException {
        if (!this.exists(ce)) {
            return;
        }
        this.setOffset(this.getCobolConverters().getCobolPackedDecimalConverter().toHost(ce, this.getHostBytes(), this.getStartOffset()));
        if (ce.isCustomVariable()) {
            this.storeCustomVariable(ce);
        }
    }

    public void visit(ICobolArrayPackedDecimalBinding ce) throws HostException {
        this.setOffset(this.getCobolConverters().getCobolPackedDecimalConverter().toHost(ce, this.getHostBytes(), this.getStartOffset(), ce.getCurrentOccurs()));
    }

    public void visit(ICobolBinaryBinding ce) throws HostException {
        if (!this.exists(ce)) {
            return;
        }
        this.setOffset(this.getCobolConverters().getCobolBinaryConverter().toHost(ce, this.getHostBytes(), this.getStartOffset()));
        if (ce.isCustomVariable()) {
            this.storeCustomVariable(ce);
        }
    }

    public void visit(ICobolArrayBinaryBinding ce) throws HostException {
        this.setOffset(this.getCobolConverters().getCobolBinaryConverter().toHost(ce, this.getHostBytes(), this.getStartOffset(), ce.getCurrentOccurs()));
    }

    public void visit(ICobolFloatBinding ce) throws HostException {
        if (!this.exists(ce)) {
            return;
        }
        this.setOffset(this.getCobolConverters().getCobolFloatConverter().toHost(ce, this.getHostBytes(), this.getStartOffset()));
        if (ce.isCustomVariable()) {
            this.storeCustomVariable(ce);
        }
    }

    public void visit(ICobolArrayFloatBinding ce) throws HostException {
        this.setOffset(this.getCobolConverters().getCobolFloatConverter().toHost(ce, this.getHostBytes(), this.getStartOffset(), ce.getCurrentOccurs()));
    }

    public void visit(ICobolDoubleBinding ce) throws HostException {
        if (!this.exists(ce)) {
            return;
        }
        this.setOffset(this.getCobolConverters().getCobolDoubleConverter().toHost(ce, this.getHostBytes(), this.getStartOffset()));
        if (ce.isCustomVariable()) {
            this.storeCustomVariable(ce);
        }
    }

    public void visit(ICobolArrayDoubleBinding ce) throws HostException {
        this.setOffset(this.getCobolConverters().getCobolDoubleConverter().toHost(ce, this.getHostBytes(), this.getStartOffset(), ce.getCurrentOccurs()));
    }

    public void visit(ICobolOctetStreamBinding ce) throws HostException {
        if (!this.exists(ce)) {
            return;
        }
        this.setOffset(this.getCobolConverters().getCobolOctetStreamConverter().toHost(ce, this.getHostBytes(), this.getStartOffset()));
        if (ce.isCustomVariable()) {
            this.storeCustomVariable(ce);
        }
    }

    public void visit(ICobolArrayOctetStreamBinding ce) throws HostException {
        this.setOffset(this.getCobolConverters().getCobolOctetStreamConverter().toHost(ce, this.getHostBytes(), this.getStartOffset(), ce.getCurrentOccurs()));
    }
}

