/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.impl.reflect;

import com.legstar.coxb.CobolBindingException;
import com.legstar.coxb.CobolComplexType;
import com.legstar.coxb.CobolElement;
import com.legstar.coxb.ICobolArrayComplexBinding;
import com.legstar.coxb.ICobolBinaryBinding;
import com.legstar.coxb.ICobolBinding;
import com.legstar.coxb.ICobolChoiceBinding;
import com.legstar.coxb.ICobolComplexBinding;
import com.legstar.coxb.common.CComplexBinding;
import com.legstar.coxb.host.HostException;
import com.legstar.coxb.impl.CBinaryBinding;
import com.legstar.coxb.impl.RedefinesMap;
import com.legstar.coxb.impl.reflect.ReflectBindingException;
import com.legstar.coxb.impl.reflect.ReflectBindingFactory;
import com.legstar.coxb.util.BindingUtil;
import com.legstar.coxb.util.ClassUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CComplexReflectBinding
extends CComplexBinding {
    private Object _jaxbObjectFactory;
    private Object _jaxbObject;
    private boolean _unusedJaxbObject = false;
    private static final String COUNTER_SUFFIX = "Counter";
    private static final String COUNTER_COBOL_SUFFIX = "--C";
    private final Log _log = LogFactory.getLog(this.getClass());

    public CComplexReflectBinding(Object jaxbObjectFactory, Object jaxbObject) throws ReflectBindingException {
        this(jaxbObject.getClass().getSimpleName(), jaxbObject.getClass().getSimpleName(), jaxbObject.getClass(), null, null, jaxbObjectFactory);
        this._jaxbObject = jaxbObject;
        this._unusedJaxbObject = true;
    }

    public CComplexReflectBinding(Object jaxbObjectFactory, Class<?> jaxbType) throws ReflectBindingException {
        this(jaxbType.getSimpleName(), jaxbType.getSimpleName(), jaxbType, null, null, jaxbObjectFactory);
    }

    public CComplexReflectBinding(String bindingName, String jaxbName, Class<?> jaxbType, CobolElement cobolAnnotations, ICobolComplexBinding parentBinding, Object jaxbObjectFactory) throws ReflectBindingException {
        super(bindingName, jaxbName, jaxbType, cobolAnnotations, parentBinding);
        this._jaxbObjectFactory = jaxbObjectFactory;
        this.initComplexElement(jaxbType, jaxbObjectFactory);
    }

    private void initComplexElement(Class<?> jaxbType, Object jaxbObjectFactory) throws ReflectBindingException {
        XmlType xmlType;
        if (this._log.isDebugEnabled()) {
            this._log.debug("Initializing Complex binding for " + jaxbType);
        }
        if ((xmlType = jaxbType.getAnnotation(XmlType.class)) == null) {
            throw new ReflectBindingException("No jaxb annotations found in " + jaxbType);
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug("Found JAXB annotations: " + xmlType.toString());
        }
        this.setValueObjectClassName(jaxbType.getName());
        this.setValueObjectsFactoryClassName(jaxbObjectFactory.getClass().getName());
        CobolComplexType cobolComplexType = jaxbType.getAnnotation(CobolComplexType.class);
        if (cobolComplexType != null && cobolComplexType.javaClassName() != null && cobolComplexType.javaClassName().length() > 0) {
            this.setValueObjectClassName(cobolComplexType.javaClassName());
            this.setValueObjectsFactoryClassName(null);
        }
        this.initChildren(jaxbType, xmlType);
        if (this._log.isDebugEnabled()) {
            this._log.debug("Complex binding sucessfully initialized for: " + jaxbType);
        }
    }

    public void initChildren(Class<?> parentJaxbType, XmlType xmlType) throws ReflectBindingException {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Initializing children of: " + parentJaxbType.getSimpleName());
        }
        RedefinesMap redefinesMap = new RedefinesMap();
        for (String prop : xmlType.propOrder()) {
            ICobolChoiceBinding choice;
            Class<?> jaxbType;
            Field field;
            try {
                field = parentJaxbType.getDeclaredField(prop);
                jaxbType = BindingUtil.getJavaClass(field);
            }
            catch (SecurityException e) {
                throw new ReflectBindingException(e);
            }
            catch (NoSuchFieldException e) {
                throw new ReflectBindingException(e);
            }
            catch (CobolBindingException e) {
                throw new ReflectBindingException(e);
            }
            ICobolBinding cobolBinding = ReflectBindingFactory.createBinding(jaxbType, field, this, this._jaxbObjectFactory);
            if (this._log.isDebugEnabled()) {
                this._log.debug("Java field " + jaxbType.getSimpleName() + " bound to " + cobolBinding);
            }
            if (cobolBinding.getMaxOccurs() > 1 && cobolBinding.getMinOccurs() < cobolBinding.getMaxOccurs() && (cobolBinding.getDependingOn() == null || cobolBinding.getDependingOn().length() == 0)) {
                this.createDynamicCounter(cobolBinding);
            }
            String redefines = cobolBinding.getRedefines();
            if (cobolBinding.isRedefined()) {
                if (this._log.isDebugEnabled()) {
                    this._log.debug("Creating Choice binding for redefined Cobol element " + cobolBinding.getCobolName());
                }
                choice = ReflectBindingFactory.createChoiceBinding(this, cobolBinding, redefinesMap);
                this.getChildrenList().add(choice);
                continue;
            }
            if (redefines != null && redefines.length() > 0) {
                if (this._log.isDebugEnabled()) {
                    this._log.debug("Adding " + cobolBinding.getCobolName() + " to Choice binding for Cobol element " + redefines);
                }
                if ((choice = redefinesMap.getChoiceElement(redefines)) == null) {
                    throw new ReflectBindingException("Cobol element " + cobolBinding.getCobolName() + " redefining unbound element " + redefines);
                }
                choice.addAlternative(cobolBinding);
                continue;
            }
            this.getChildrenList().add(cobolBinding);
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug("Children sucessfully initialized for: " + parentJaxbType.getSimpleName());
        }
    }

    private void createDynamicCounter(ICobolBinding cobolElement) throws ReflectBindingException {
        ICobolBinaryBinding counter = this.createDynamicCounterBinding(cobolElement);
        this.storeCounter(counter);
        cobolElement.setDependingOn(counter.getCobolName());
        if (cobolElement instanceof ICobolArrayComplexBinding) {
            ((ICobolArrayComplexBinding)cobolElement).getComplexItemBinding().setDependingOn(counter.getCobolName());
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug("Created depending on relationship for " + cobolElement.getBindingName() + " with " + counter.getCobolName());
        }
    }

    private ICobolBinaryBinding createDynamicCounterBinding(ICobolBinding listBinding) throws ReflectBindingException {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Creating a dynamic counter for " + listBinding.getBindingName());
        }
        CBinaryBinding counter = new CBinaryBinding(listBinding.getBindingName() + COUNTER_SUFFIX, null, null, null, this);
        counter.setCobolName(this.getCounterCobolName(listBinding.getCobolName()));
        counter.setLevelNumber(listBinding.getLevelNumber());
        counter.setUsage("BINARY");
        counter.setPicture("9(9)");
        counter.setByteLength(4);
        counter.setTotalDigits(9);
        counter.setIsODOObject(true);
        return counter;
    }

    private String getCounterCobolName(String cobolName) {
        if (cobolName.length() < 31 - COUNTER_COBOL_SUFFIX.length()) {
            return cobolName + COUNTER_COBOL_SUFFIX;
        }
        return cobolName.substring(0, 30 - COUNTER_COBOL_SUFFIX.length()) + COUNTER_COBOL_SUFFIX;
    }

    @Override
    public void createJaxbObject() throws HostException {
        this.createValueObject();
    }

    @Override
    public void createValueObject() throws HostException {
        if (this._unusedJaxbObject && this._jaxbObject != null) {
            this._unusedJaxbObject = false;
            return;
        }
        this._jaxbObject = BindingUtil.newJaxbObject(this._jaxbObjectFactory, this.getJaxbType().getName());
    }

    @Override
    public void setChildrenValues() throws HostException {
        if (this._jaxbObject == null) {
            this.createJaxbObject();
        }
        for (ICobolBinding child : this.getChildrenList()) {
            if (!child.isBound()) continue;
            Object value = ClassUtil.invokeGetProperty(this._jaxbObject, child.getJaxbName(), child.getJaxbType(), child.getMaxOccurs());
            if (this._log.isDebugEnabled()) {
                this._log.debug("Getting value from JAXB property " + child.getJaxbName() + " value=" + value);
            }
            child.setObjectValue(value);
            if (child.getMaxOccurs() <= 1 || child.getMinOccurs() >= child.getMaxOccurs()) continue;
            this.setCounterValue(child.getDependingOn(), ((List)value).size());
        }
    }

    @Override
    public void setJaxbPropertyValue(int index) throws HostException {
        this.setPropertyValue(index);
    }

    @Override
    public void setPropertyValue(int index) throws HostException {
        ICobolBinding child = this.getChildrenList().get(index);
        if (!child.isBound()) {
            return;
        }
        Class<?> param = child.getJaxbType();
        String setterName = ClassUtil.getSetterMethodName(child.getJaxbName());
        for (Method method : this._jaxbObject.getClass().getMethods()) {
            if (!method.getName().equals(setterName)) continue;
            param = method.getParameterTypes()[0];
            break;
        }
        Object value = child.getObjectValue(param);
        if (this._log.isDebugEnabled()) {
            this._log.debug("Setting value of JAXB property " + child.getJaxbName() + " value=" + value);
        }
        ClassUtil.invokeSetProperty(this._jaxbObject, child.getJaxbName(), value, param);
    }

    @Override
    public Object getObjectValue(Class<?> type) throws HostException {
        if (type.equals(this.getJaxbType())) {
            return this._jaxbObject;
        }
        if (type.getName().equals(this.getValueObjectClassName())) {
            return this._jaxbObject;
        }
        throw new HostException("Attempt to get binding " + this.getJaxbName() + " as an incompatible type " + type);
    }

    @Override
    public void setObjectValue(Object value) throws HostException {
        if (value == null) {
            this._jaxbObject = null;
            return;
        }
        if (value.getClass().equals(this.getJaxbType())) {
            this._jaxbObject = value;
        } else if (value.getClass().getName().equals(this.getValueObjectClassName())) {
            this._jaxbObject = value;
        } else {
            throw new HostException("Attempt to set binding " + this.getJaxbName() + " from an incompatible value " + value);
        }
    }

    @Override
    public Object getObjectFactory() {
        return this._jaxbObjectFactory;
    }

    @Override
    public void setObjectFactory(Object objectFactory) {
        this._jaxbObjectFactory = objectFactory;
    }

    @Override
    public boolean isSet() {
        return this._jaxbObject != null;
    }
}

