/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.impl;

import com.legstar.coxb.CobolElement;
import com.legstar.coxb.CobolElementVisitor;
import com.legstar.coxb.CobolType;
import com.legstar.coxb.ICobolComplexBinding;
import com.legstar.coxb.ICobolStringBinding;
import com.legstar.coxb.host.HostException;
import com.legstar.coxb.impl.AbstractAlphaNumericBinding;
import com.legstar.coxb.util.PictureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CStringBinding
extends AbstractAlphaNumericBinding
implements ICobolStringBinding {
    public CStringBinding(String bindingName, String jaxbName, Class<?> jaxbType, CobolElement cobolAnnotations, ICobolComplexBinding parentBinding) {
        super(bindingName, jaxbName, jaxbType, cobolAnnotations, parentBinding);
    }

    @Override
    public void accept(CobolElementVisitor cev) throws HostException {
        cev.visit(this);
    }

    @Override
    public int calcByteLength() {
        return CStringBinding.calcStringByteLength(this.getPicture(), this.getCobolType());
    }

    public static int calcStringByteLength(String picture, CobolType cobolType) {
        switch (cobolType) {
            case ALPHABETIC_ITEM: {
                return PictureUtil.getSymbolsNumber(new char[]{'A'}, picture);
            }
            case ALPHANUMERIC_ITEM: {
                return PictureUtil.getSymbolsNumber(new char[]{'A', 'X', '9'}, picture);
            }
            case ALPHANUMERIC_EDITED_ITEM: {
                return PictureUtil.getSymbolsNumber(new char[]{'A', 'X', '9', 'B', '0', '/'}, picture);
            }
            case EXTERNAL_FLOATING_ITEM: {
                return PictureUtil.getSymbolsNumber(new char[]{'+', '-', '9', '.', 'E'}, picture);
            }
            case NUMERIC_EDITED_ITEM: {
                int count = 0;
                String strippedPicture = picture;
                int idx = picture.indexOf("CR");
                if (idx > -1) {
                    count += 2;
                    strippedPicture = strippedPicture.replaceFirst("CR", "");
                }
                if ((idx = picture.indexOf("DB")) > -1) {
                    count += 2;
                    strippedPicture = strippedPicture.replaceFirst("DB", "");
                }
                return count += PictureUtil.getSymbolsNumber(new char[]{'B', 'Z', '9', '0', ',', '.', '-', '+', '/', '*', '$'}, strippedPicture);
            }
        }
        return PictureUtil.getSymbolsNumber(new char[]{'X'}, picture);
    }
}

