/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.impl;

import com.legstar.coxb.CobolElement;
import com.legstar.coxb.CobolElementVisitor;
import com.legstar.coxb.ICobolComplexBinding;
import com.legstar.coxb.ICobolOctetStreamBinding;
import com.legstar.coxb.common.CBinding;
import com.legstar.coxb.host.HostException;
import com.legstar.coxb.util.PictureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class COctetStreamBinding
extends CBinding
implements ICobolOctetStreamBinding {
    private byte[] mValue = null;

    public COctetStreamBinding(String bindingName, String jaxbName, Class<?> jaxbType, CobolElement cobolAnnotations, ICobolComplexBinding parentBinding) {
        super(bindingName, jaxbName, jaxbType, cobolAnnotations, parentBinding);
    }

    @Override
    public void accept(CobolElementVisitor cev) throws HostException {
        cev.visit(this);
    }

    @Override
    public byte[] getByteArrayValue() throws HostException {
        return this.mValue;
    }

    @Override
    public void setByteArrayValue(byte[] value) throws HostException {
        this.mValue = value;
    }

    @Override
    public int calcByteLength() {
        return COctetStreamBinding.calcOctetStreamByteLength(this.getPicture(), this.getUsage());
    }

    public static int calcOctetStreamByteLength(String picture, String usage) {
        if (usage.equals("INDEX")) {
            return 4;
        }
        if (usage.equals("POINTER")) {
            return 4;
        }
        if (usage.equals("PROCEDURE-POINTER")) {
            return 8;
        }
        if (usage.equals("FUNCTION-POINTER")) {
            return 4;
        }
        return PictureUtil.getSymbolsNumber('X', picture);
    }

    @Override
    public Object getObjectValue(Class<?> type) throws HostException {
        if (type.equals(byte[].class)) {
            return this.mValue;
        }
        throw new HostException("Attempt to get binding " + this.getBindingName() + " as an incompatible type " + type);
    }

    @Override
    public void setObjectValue(Object value) throws HostException {
        if (value == null) {
            this.mValue = null;
            return;
        }
        if (!(value instanceof byte[])) {
            throw new HostException("Attempt to set binding " + this.getBindingName() + " from an incompatible value " + value);
        }
        this.mValue = (byte[])value;
    }

    @Override
    public boolean isSet() {
        return this.mValue != null;
    }
}

