/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.impl;

import com.legstar.coxb.CobolElement;
import com.legstar.coxb.CobolElementVisitor;
import com.legstar.coxb.ICobolComplexBinding;
import com.legstar.coxb.ICobolFloatBinding;
import com.legstar.coxb.common.CBinding;
import com.legstar.coxb.host.HostException;
import java.math.BigDecimal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFloatBinding
extends CBinding
implements ICobolFloatBinding {
    private Float mValue = null;
    public static final int BYTE_LENGTH = 4;

    public CFloatBinding(String bindingName, String jaxbName, Class<?> jaxbType, CobolElement cobolAnnotations, ICobolComplexBinding parentBinding) {
        super(bindingName, jaxbName, jaxbType, cobolAnnotations, parentBinding);
    }

    @Override
    public void accept(CobolElementVisitor cev) throws HostException {
        cev.visit(this);
    }

    @Override
    public Float getFloatValue() throws HostException {
        return this.mValue;
    }

    @Override
    public void setFloatValue(Float value) throws HostException {
        this.mValue = value;
    }

    @Override
    public BigDecimal getBigDecimalValue() throws HostException {
        return new BigDecimal(this.mValue.floatValue());
    }

    @Override
    public void setBigDecimalValue(BigDecimal value) throws HostException {
        this.mValue = Float.valueOf(value.floatValue());
    }

    @Override
    public int calcByteLength() {
        return CFloatBinding.calcFloatByteLength();
    }

    public static int calcFloatByteLength() {
        return 4;
    }

    @Override
    public Object getObjectValue(Class<?> type) throws HostException {
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return this.mValue;
        }
        if (type.equals(BigDecimal.class)) {
            return this.getBigDecimalValue();
        }
        throw new HostException("Attempt to get binding " + this.getBindingName() + " as an incompatible type " + type);
    }

    @Override
    public void setObjectValue(Object value) throws HostException {
        if (value == null) {
            this.mValue = null;
            return;
        }
        if (value instanceof Float) {
            this.mValue = (Float)value;
        } else if (value instanceof BigDecimal) {
            this.setBigDecimalValue((BigDecimal)value);
        } else {
            throw new HostException("Attempt to set binding " + this.getBindingName() + " from an incompatible value " + value);
        }
    }

    @Override
    public boolean isSet() {
        return this.mValue != null;
    }
}

