/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.impl;

import com.legstar.coxb.CobolElement;
import com.legstar.coxb.CobolElementVisitor;
import com.legstar.coxb.ICobolArrayFloatBinding;
import com.legstar.coxb.ICobolComplexBinding;
import com.legstar.coxb.common.CArrayBinding;
import com.legstar.coxb.host.HostException;
import com.legstar.coxb.impl.CFloatBinding;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CArrayFloatBinding
extends CArrayBinding
implements ICobolArrayFloatBinding {
    private List<Float> mList = null;

    public CArrayFloatBinding(String bindingName, String jaxbName, Class<?> jaxbType, CobolElement cobolAnnotations, ICobolComplexBinding parentBinding) {
        super(bindingName, jaxbName, jaxbType, cobolAnnotations, parentBinding);
    }

    @Override
    public void accept(CobolElementVisitor cev) throws HostException {
        cev.visit(this);
    }

    @Override
    public int calcItemByteLength() {
        return CFloatBinding.calcFloatByteLength();
    }

    @Override
    public List<Float> getFloatList() {
        return this.mList;
    }

    @Override
    public void setFloatList(List<Float> list) {
        this.mList = list;
    }

    @Override
    public List<BigDecimal> getBigDecimalList() {
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
        for (Float value : this.mList) {
            list.add(new BigDecimal(value.floatValue()));
        }
        return list;
    }

    @Override
    public void setBigDecimalList(List<BigDecimal> list) {
        this.mList = new ArrayList<Float>();
        for (BigDecimal value : list) {
            this.mList.add(Float.valueOf(value.floatValue()));
        }
    }

    @Override
    public Object getObjectValue(Class<?> type) throws HostException {
        if (type.equals(Float.class)) {
            return this.mList;
        }
        if (type.equals(BigDecimal.class)) {
            return this.getBigDecimalList();
        }
        throw new HostException("Attempt to get binding " + this.getBindingName() + " as an incompatible type " + type);
    }

    @Override
    public void setObjectValue(Object value) throws HostException {
        if (value == null) {
            this.mList = null;
            return;
        }
        if (value instanceof List) {
            if (((List)value).size() == 0) {
                this.mList = new ArrayList<Float>();
                return;
            }
            Object item = ((List)value).get(0);
            if (item instanceof Float) {
                this.mList = (List)value;
                return;
            }
            if (item instanceof BigDecimal) {
                this.setBigDecimalList((List)value);
                return;
            }
        }
        throw new HostException("Attempt to set binding " + this.getBindingName() + " from an incompatible value " + value);
    }

    @Override
    public boolean isSet() {
        return this.mList != null;
    }
}

