/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.impl;

import com.legstar.coxb.CobolElement;
import com.legstar.coxb.ICobolComplexBinding;
import com.legstar.coxb.common.CBinding;
import com.legstar.coxb.host.HostException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNumericBinding
extends CBinding {
    private BigDecimal mValue = null;

    public AbstractNumericBinding(String bindingName, String jaxbName, Class<?> jaxbType, CobolElement cobolAnnotations, ICobolComplexBinding parentBinding) {
        super(bindingName, jaxbName, jaxbType, cobolAnnotations, parentBinding);
    }

    public void setByteValue(Byte value) throws HostException {
        this.mValue = new BigDecimal(value.byteValue());
    }

    public Byte getByteValue() throws HostException {
        return this.mValue.byteValue();
    }

    public void setShortValue(Short value) throws HostException {
        this.mValue = new BigDecimal(value.shortValue());
    }

    public Short getShortValue() throws HostException {
        return this.mValue.shortValue();
    }

    public void setIntegerValue(Integer value) throws HostException {
        this.mValue = new BigDecimal(value);
    }

    public Integer getIntegerValue() throws HostException {
        return this.mValue.intValue();
    }

    public void setLongValue(Long value) throws HostException {
        this.mValue = new BigDecimal(value);
    }

    public Long getLongValue() throws HostException {
        return this.mValue.longValue();
    }

    public void setFloatValue(Float value) throws HostException {
        this.mValue = new BigDecimal(value.floatValue());
    }

    public Float getFloatValue() throws HostException {
        return Float.valueOf(this.mValue.floatValue());
    }

    public void setDoubleValue(Double value) throws HostException {
        this.mValue = new BigDecimal(value);
    }

    public Double getDoubleValue() throws HostException {
        return this.mValue.doubleValue();
    }

    public void setBigDecimalValue(BigDecimal value) throws HostException {
        this.mValue = value;
    }

    public BigDecimal getBigDecimalValue() throws HostException {
        return this.mValue;
    }

    public void setBigIntegerValue(BigInteger value) throws HostException {
        this.mValue = new BigDecimal(value);
    }

    public BigInteger getBigIntegerValue() throws HostException {
        return this.mValue.toBigInteger();
    }

    public void setBooleanValue(Boolean value) throws HostException {
        this.mValue = new BigDecimal(value != false ? "1" : "0");
    }

    public Boolean getBooleanValue() throws HostException {
        if (this.mValue.intValue() == 0) {
            return false;
        }
        return true;
    }

    public Object getEnumValue(Class<?> type) throws HostException {
        try {
            Method value = type.getMethod("value", new Class[0]);
            Method fromValue = type.getMethod("fromValue", value.getReturnType());
            return fromValue.invoke(null, this.getObjectValue(value.getReturnType()));
        }
        catch (SecurityException e) {
            throw new HostException(e);
        }
        catch (IllegalArgumentException e) {
            throw new HostException(e);
        }
        catch (IllegalAccessException e) {
            throw new HostException(e);
        }
        catch (NoSuchMethodException e) {
            throw new HostException(e);
        }
        catch (InvocationTargetException e) {
            throw new HostException(e);
        }
    }

    public void setEnumValue(Enum<?> value) throws HostException {
        try {
            Method valueMethod = value.getClass().getMethod("value", new Class[0]);
            Object numValue = valueMethod.invoke(value, new Object[0]);
            this.setObjectValue(numValue);
        }
        catch (SecurityException e) {
            throw new HostException(e);
        }
        catch (IllegalArgumentException e) {
            throw new HostException(e);
        }
        catch (IllegalAccessException e) {
            throw new HostException(e);
        }
        catch (NoSuchMethodException e) {
            throw new HostException(e);
        }
        catch (InvocationTargetException e) {
            throw new HostException(e);
        }
    }

    @Override
    public Object getObjectValue(Class<?> type) throws HostException {
        if (type.equals(BigDecimal.class)) {
            return this.mValue;
        }
        if (type.equals(BigInteger.class)) {
            return this.getBigIntegerValue();
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return this.getLongValue();
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return this.getFloatValue();
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return this.getDoubleValue();
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return this.getIntegerValue();
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            return this.getShortValue();
        }
        if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
            return this.getByteValue();
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return this.getBooleanValue();
        }
        if (type.isEnum()) {
            return this.getEnumValue(type);
        }
        throw new HostException("Attempt to get binding " + this.getBindingName() + " as an incompatible type " + type);
    }

    @Override
    public void setObjectValue(Object value) throws HostException {
        if (value == null) {
            this.mValue = null;
            return;
        }
        if (value instanceof BigDecimal) {
            this.mValue = (BigDecimal)value;
        } else if (value instanceof BigInteger) {
            this.setBigIntegerValue((BigInteger)value);
        } else if (value instanceof Long) {
            this.setLongValue((Long)value);
        } else if (value instanceof Float) {
            this.setFloatValue((Float)value);
        } else if (value instanceof Double) {
            this.setDoubleValue((Double)value);
        } else if (value instanceof Integer) {
            this.setIntegerValue((Integer)value);
        } else if (value instanceof Short) {
            this.setShortValue((Short)value);
        } else if (value instanceof Byte) {
            this.setByteValue((Byte)value);
        } else if (value instanceof Boolean) {
            this.setBooleanValue((Boolean)value);
        } else if (value instanceof Enum) {
            this.setEnumValue((Enum)value);
        } else {
            throw new HostException("Attempt to set binding " + this.getBindingName() + " from an incompatible value " + value);
        }
    }

    @Override
    public boolean isSet() {
        return this.mValue != null;
    }
}

