/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.impl;

import com.legstar.coxb.CobolElement;
import com.legstar.coxb.ICobolComplexBinding;
import com.legstar.coxb.common.CArrayBinding;
import com.legstar.coxb.host.HostException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractArrayNumericBinding
extends CArrayBinding {
    private List<BigDecimal> mList = null;

    public AbstractArrayNumericBinding(String bindingName, String jaxbName, Class<?> jaxbType, CobolElement cobolAnnotations, ICobolComplexBinding parentBinding) {
        super(bindingName, jaxbName, jaxbType, cobolAnnotations, parentBinding);
    }

    public List<Byte> getByteList() {
        ArrayList<Byte> list = new ArrayList<Byte>();
        for (BigDecimal value : this.mList) {
            list.add(value.byteValue());
        }
        return list;
    }

    public void setByteList(List<Byte> list) {
        this.mList = new ArrayList<BigDecimal>();
        for (Byte value : list) {
            this.mList.add(new BigDecimal(value.byteValue()));
        }
    }

    public List<Short> getShortList() {
        ArrayList<Short> list = new ArrayList<Short>();
        for (BigDecimal value : this.mList) {
            list.add(value.shortValue());
        }
        return list;
    }

    public void setShortList(List<Short> list) {
        this.mList = new ArrayList<BigDecimal>();
        for (Short value : list) {
            this.mList.add(new BigDecimal(value.shortValue()));
        }
    }

    public List<Integer> getIntegerList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (BigDecimal value : this.mList) {
            list.add(value.intValue());
        }
        return list;
    }

    public void setIntegerList(List<Integer> list) {
        this.mList = new ArrayList<BigDecimal>();
        for (Integer value : list) {
            this.mList.add(new BigDecimal(value));
        }
    }

    public List<Long> getLongList() {
        ArrayList<Long> list = new ArrayList<Long>();
        for (BigDecimal value : this.mList) {
            list.add(value.longValue());
        }
        return list;
    }

    public void setLongList(List<Long> list) {
        this.mList = new ArrayList<BigDecimal>();
        for (Long value : list) {
            this.mList.add(new BigDecimal(value));
        }
    }

    public List<BigDecimal> getBigDecimalList() {
        return this.mList;
    }

    public void setBigDecimalList(List<BigDecimal> list) {
        this.mList = list;
    }

    public List<BigInteger> getBigIntegerList() {
        ArrayList<BigInteger> list = new ArrayList<BigInteger>();
        for (BigDecimal value : this.mList) {
            list.add(value.toBigInteger());
        }
        return list;
    }

    public void setBigIntegerList(List<BigInteger> list) {
        this.mList = new ArrayList<BigDecimal>();
        for (BigInteger value : list) {
            this.mList.add(new BigDecimal(value));
        }
    }

    public List<Boolean> getBooleanList() {
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        for (BigDecimal value : this.mList) {
            if (value.intValue() == 0) {
                list.add(Boolean.FALSE);
                continue;
            }
            list.add(Boolean.TRUE);
        }
        return list;
    }

    public void setBooleanList(List<Boolean> list) {
        this.mList = new ArrayList<BigDecimal>();
        for (Boolean value : list) {
            this.mList.add(new BigDecimal(value != false ? "1" : "0"));
        }
    }

    @Override
    public Object getObjectValue(Class<?> type) throws HostException {
        if (type.equals(BigDecimal.class)) {
            return this.mList;
        }
        if (type.equals(BigInteger.class)) {
            return this.getBigIntegerList();
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return this.getLongList();
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return this.getIntegerList();
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            return this.getShortList();
        }
        if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
            return this.getByteList();
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return this.getBooleanList();
        }
        throw new HostException("Attempt to get binding " + this.getBindingName() + " as an incompatible type " + type);
    }

    @Override
    public void setObjectValue(Object value) throws HostException {
        if (value == null) {
            this.mList = null;
            return;
        }
        if (value instanceof List) {
            if (((List)value).size() == 0) {
                this.mList = new ArrayList<BigDecimal>();
                return;
            }
            Object item = ((List)value).get(0);
            if (item instanceof BigDecimal) {
                this.mList = (List)value;
                return;
            }
            if (item instanceof BigInteger) {
                this.setBigIntegerList((List)value);
                return;
            }
            if (item instanceof Long) {
                this.setLongList((List)value);
                return;
            }
            if (item instanceof Integer) {
                this.setIntegerList((List)value);
                return;
            }
            if (item instanceof Short) {
                this.setShortList((List)value);
                return;
            }
            if (item instanceof Byte) {
                this.setByteList((List)value);
                return;
            }
            if (item instanceof Boolean) {
                this.setBooleanList((List)value);
                return;
            }
        }
        throw new HostException("Attempt to set binding " + this.getBindingName() + " from an incompatible value " + value);
    }

    @Override
    public boolean isSet() {
        return this.mList != null;
    }
}

