/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.impl;

import com.legstar.coxb.CobolElement;
import com.legstar.coxb.ICobolComplexBinding;
import com.legstar.coxb.common.CBinding;
import com.legstar.coxb.host.HostException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAlphaNumericBinding
extends CBinding {
    private String mValue = null;

    public AbstractAlphaNumericBinding(String bindingName, String jaxbName, Class<?> jaxbType, CobolElement cobolAnnotations, ICobolComplexBinding parentBinding) {
        super(bindingName, jaxbName, jaxbType, cobolAnnotations, parentBinding);
    }

    public String getStringValue() throws HostException {
        return this.mValue;
    }

    public void setStringValue(String value) throws HostException {
        this.mValue = value;
    }

    @Override
    public Object getObjectValue(Class<?> type) throws HostException {
        if (type.equals(String.class)) {
            return this.mValue;
        }
        if (type.equals(Date.class)) {
            return new Date(Timestamp.valueOf(this.mValue).getTime());
        }
        if (type.isEnum()) {
            try {
                Method fromValue = this.getFromValueMethod(type);
                return fromValue.invoke(null, this.mValue.trim());
            }
            catch (SecurityException e) {
                throw new HostException(e);
            }
            catch (IllegalArgumentException e) {
                throw new HostException(e);
            }
            catch (IllegalAccessException e) {
                throw new HostException(e);
            }
            catch (InvocationTargetException e) {
                throw new HostException(e);
            }
        }
        throw new HostException("Attempt to get binding " + this.getBindingName() + " as an incompatible type " + type);
    }

    protected Method getFromValueMethod(Class<?> type) throws HostException {
        try {
            Method fromValueMethod = null;
            try {
                fromValueMethod = type.getMethod("fromValue", String.class);
            }
            catch (NoSuchMethodException e) {
                fromValueMethod = type.getMethod("valueOf", String.class);
            }
            return fromValueMethod;
        }
        catch (SecurityException e) {
            throw new HostException(e);
        }
        catch (NoSuchMethodException e) {
            throw new HostException(e);
        }
    }

    @Override
    public void setObjectValue(Object value) throws HostException {
        if (value == null) {
            this.mValue = null;
            return;
        }
        if (value instanceof String) {
            this.mValue = (String)value;
        } else if (value instanceof Date) {
            this.mValue = new Timestamp(((Date)value).getTime()).toString();
        } else if (value instanceof Enum) {
            try {
                Method valueMethod = this.getValueMethod(value.getClass());
                this.mValue = (String)valueMethod.invoke(value, new Object[0]);
            }
            catch (SecurityException e) {
                throw new HostException(e);
            }
            catch (IllegalArgumentException e) {
                throw new HostException(e);
            }
            catch (IllegalAccessException e) {
                throw new HostException(e);
            }
            catch (InvocationTargetException e) {
                throw new HostException(e);
            }
        } else {
            throw new HostException("Attempt to set binding " + this.getBindingName() + " from an incompatible value " + value);
        }
    }

    protected Method getValueMethod(Class<?> type) throws HostException {
        try {
            Method valueMethod = null;
            try {
                valueMethod = type.getMethod("value", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                valueMethod = type.getMethod("toString", new Class[0]);
            }
            return valueMethod;
        }
        catch (SecurityException e) {
            throw new HostException(e);
        }
        catch (NoSuchMethodException e) {
            throw new HostException(e);
        }
    }

    @Override
    public boolean isSet() {
        return this.mValue != null;
    }
}

