/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.convert.simple;

import com.legstar.coxb.CobolContext;
import com.legstar.coxb.ICobolArrayZonedDecimalBinding;
import com.legstar.coxb.ICobolZonedDecimalBinding;
import com.legstar.coxb.convert.CobolConversionException;
import com.legstar.coxb.convert.ICobolZonedDecimalConverter;
import com.legstar.coxb.convert.simple.CobolSimpleConverter;
import com.legstar.coxb.host.HostData;
import com.legstar.coxb.host.HostException;
import java.math.BigDecimal;
import java.util.ArrayList;

public class CobolZonedDecimalSimpleConverterNoCodePage
extends CobolSimpleConverter
implements ICobolZonedDecimalConverter {
    private static final byte PLUS_EBCDIC = 78;
    private static final byte MINUS_EBCDIC = 96;

    public CobolZonedDecimalSimpleConverterNoCodePage(CobolContext cobolContext) {
        super(cobolContext);
    }

    public int toHost(ICobolZonedDecimalBinding ce, byte[] hostTarget, int offset) throws HostException {
        int newOffset = 0;
        try {
            newOffset = CobolZonedDecimalSimpleConverterNoCodePage.toHostSingle(ce.getBigDecimalValue(), ce.getByteLength(), ce.getTotalDigits(), ce.getFractionDigits(), ce.isSigned(), ce.isSignSeparate(), ce.isSignLeading(), hostTarget, offset);
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int toHost(ICobolArrayZonedDecimalBinding ce, byte[] hostTarget, int offset, int currentOccurs) throws HostException {
        int newOffset = offset;
        try {
            for (BigDecimal javaSource : ce.getBigDecimalList()) {
                newOffset = CobolZonedDecimalSimpleConverterNoCodePage.toHostSingle(javaSource, ce.getItemByteLength(), ce.getTotalDigits(), ce.getFractionDigits(), ce.isSigned(), ce.isSignSeparate(), ce.isSignLeading(), hostTarget, newOffset);
            }
            for (int i = ce.getBigDecimalList().size(); i < currentOccurs; ++i) {
                newOffset = CobolZonedDecimalSimpleConverterNoCodePage.toHostSingle(BigDecimal.ZERO, ce.getItemByteLength(), ce.getTotalDigits(), ce.getFractionDigits(), ce.isSignSeparate(), ce.isSignLeading(), ce.isSigned(), hostTarget, newOffset);
            }
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int fromHost(ICobolZonedDecimalBinding ce, byte[] hostSource, int offset) throws HostException {
        int newOffset = offset;
        try {
            BigDecimal javaDecimal = CobolZonedDecimalSimpleConverterNoCodePage.fromHostSingle(ce.getByteLength(), ce.getTotalDigits(), ce.getFractionDigits(), ce.isSigned(), ce.isSignSeparate(), ce.isSignLeading(), hostSource, newOffset);
            ce.setBigDecimalValue(javaDecimal);
            newOffset += ce.getByteLength();
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int fromHost(ICobolArrayZonedDecimalBinding ce, byte[] hostSource, int offset, int currentOccurs) throws HostException {
        ArrayList<BigDecimal> lArray = new ArrayList<BigDecimal>();
        int newOffset = offset;
        try {
            for (int i = 0; i < currentOccurs; ++i) {
                BigDecimal javaDecimal = CobolZonedDecimalSimpleConverterNoCodePage.fromHostSingle(ce.getItemByteLength(), ce.getTotalDigits(), ce.getFractionDigits(), ce.isSigned(), ce.isSignSeparate(), ce.isSignLeading(), hostSource, newOffset);
                lArray.add(javaDecimal);
                newOffset += ce.getItemByteLength();
            }
            ce.setBigDecimalList(lArray);
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public static final int toHostSingle(BigDecimal javaDecimal, int cobolByteLength, int totalDigits, int fractionDigits, boolean isSigned, boolean isSignSeparate, boolean isSignLeading, byte[] hostTarget, int offset) throws CobolConversionException {
        int i;
        String sDecimal;
        int lastOffset = offset + cobolByteLength;
        if (lastOffset > hostTarget.length) {
            throw new CobolConversionException("Attempt to write past end of host source buffer", new HostData(hostTarget), offset, cobolByteLength);
        }
        if (javaDecimal == null) {
            sDecimal = "0";
        } else {
            sDecimal = javaDecimal.toString();
            if (javaDecimal.scale() != fractionDigits) {
                sDecimal = javaDecimal.setScale(fractionDigits, 1).toString();
            }
        }
        int javaDigits = 0;
        for (int i2 = 0; i2 < sDecimal.length(); ++i2) {
            if (!Character.isDigit(sDecimal.charAt(i2))) continue;
            ++javaDigits;
        }
        if (javaDigits > totalDigits) {
            throw new CobolConversionException("BigDecimal value too large for target Cobol field", new HostData(hostTarget), offset, cobolByteLength);
        }
        int pad = totalDigits - javaDigits;
        int iTarget = offset;
        if (isSigned && isSignSeparate && isSignLeading) {
            ++iTarget;
        }
        for (i = 0; i < pad; ++i) {
            hostTarget[iTarget] = -16;
            ++iTarget;
        }
        for (i = 0; i < sDecimal.length(); ++i) {
            char sC = sDecimal.charAt(i);
            if (!Character.isDigit(sC)) continue;
            hostTarget[iTarget] = (byte)(240 + Character.digit(sC, 10));
            ++iTarget;
        }
        if (isSigned) {
            if (isSignSeparate) {
                if (isSignLeading) {
                    hostTarget[offset] = sDecimal.charAt(0) == '-' ? 96 : 78;
                } else {
                    hostTarget[iTarget] = sDecimal.charAt(0) == '-' ? 96 : 78;
                    ++iTarget;
                }
            } else if (isSignLeading) {
                hostTarget[offset] = sDecimal.charAt(0) == '-' ? (byte)(hostTarget[offset] - 32) : (byte)(hostTarget[offset] - 48);
            } else {
                hostTarget[iTarget - 1] = sDecimal.charAt(0) == '-' ? (byte)(hostTarget[iTarget - 1] - 32) : (byte)(hostTarget[iTarget - 1] - 48);
            }
        }
        return iTarget;
    }

    public static final BigDecimal fromHostSingle(int cobolByteLength, int totalDigits, int fractionDigits, boolean isSigned, boolean isSignSeparate, boolean isSignLeading, byte[] hostSource, int offset) throws CobolConversionException {
        StringBuffer sDecimal = new StringBuffer();
        int lastOffset = offset + cobolByteLength;
        if (lastOffset > hostSource.length) {
            return new BigDecimal(0);
        }
        if (lastOffset < 1) {
            throw new CobolConversionException("Invalid host byte length", new HostData(hostSource), offset, cobolByteLength);
        }
        if (isSigned) {
            if (isSignSeparate) {
                if (isSignLeading) {
                    if (hostSource[offset] == 96) {
                        sDecimal.append('-');
                    }
                } else if (hostSource[lastOffset - 1] == 96) {
                    sDecimal.append('-');
                }
            } else {
                int s;
                int n = s = isSignLeading ? hostSource[offset] & 0xF0 : hostSource[lastOffset - 1] & 0xF0;
                if (s == 208) {
                    sDecimal.append('-');
                } else if (s != 192 && s != 240) {
                    throw new CobolConversionException("Host data sign byte is not a valid zoned decimal byte", new HostData(hostSource), offset, cobolByteLength);
                }
            }
        }
        int integerPart = 0;
        for (int i = offset; i < lastOffset; ++i) {
            if (i == offset && isSigned && isSignSeparate && isSignLeading || i == lastOffset - 1 && isSigned && isSignSeparate && !isSignLeading) continue;
            String sByte = Integer.toHexString(hostSource[i] & 0xFF | 0x100).substring(1, 3);
            if (integerPart == totalDigits - fractionDigits) {
                sDecimal.append('.');
            }
            if (!Character.isDigit(sByte.charAt(1))) {
                throw new CobolConversionException("Host data contains a byte that is not a valid zoned decimal byte", new HostData(hostSource), offset, cobolByteLength);
            }
            sDecimal.append(sByte.charAt(1));
            ++integerPart;
        }
        return new BigDecimal(sDecimal.toString());
    }
}

