/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.convert.simple;

import com.legstar.coxb.CobolContext;
import com.legstar.coxb.ICobolArrayZonedDecimalBinding;
import com.legstar.coxb.ICobolZonedDecimalBinding;
import com.legstar.coxb.convert.CobolConversionException;
import com.legstar.coxb.convert.ICobolZonedDecimalConverter;
import com.legstar.coxb.convert.simple.CobolSimpleConverter;
import com.legstar.coxb.host.HostData;
import com.legstar.coxb.host.HostException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;

public class CobolZonedDecimalSimpleConverter
extends CobolSimpleConverter
implements ICobolZonedDecimalConverter {
    private static final byte PLUS_EBCDIC = 78;
    private static final byte MINUS_EBCDIC = 96;
    private static final byte ZERO_EBCDIC = -16;
    private static final byte[] ORDERED_ZONED_DECIMAL_EBCDIC_BYTES = new byte[]{-16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 0, 64, 78, 96};
    private static final char[] ZONED_DECIMAL_EBCDIC_BYTES_TO_JAVA_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '0', '+', '-'};
    private static final byte[] ORDERED_ZONED_DECIMAL_ASCII_BYTES = new byte[]{0, 32, 43, 45, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static final char[] ZONED_DECIMAL_ASCII_BYTES_TO_JAVA_CHARS = new char[]{'0', '0', '+', '-', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public CobolZonedDecimalSimpleConverter(CobolContext cobolContext) {
        super(cobolContext);
    }

    public int toHost(ICobolZonedDecimalBinding ce, byte[] hostTarget, int offset) throws HostException {
        int newOffset = 0;
        try {
            newOffset = CobolZonedDecimalSimpleConverter.toHostSingle(ce.getBigDecimalValue(), ce.getByteLength(), ce.getTotalDigits(), ce.getFractionDigits(), ce.isSigned(), ce.isSignSeparate(), ce.isSignLeading(), hostTarget, offset, this.getCobolContext().getHostCharsetName());
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int toHost(ICobolArrayZonedDecimalBinding ce, byte[] hostTarget, int offset, int currentOccurs) throws HostException {
        int newOffset = offset;
        try {
            for (BigDecimal javaSource : ce.getBigDecimalList()) {
                newOffset = CobolZonedDecimalSimpleConverter.toHostSingle(javaSource, ce.getItemByteLength(), ce.getTotalDigits(), ce.getFractionDigits(), ce.isSigned(), ce.isSignSeparate(), ce.isSignLeading(), hostTarget, newOffset, this.getCobolContext().getHostCharsetName());
            }
            for (int i = ce.getBigDecimalList().size(); i < currentOccurs; ++i) {
                newOffset = CobolZonedDecimalSimpleConverter.toHostSingle(BigDecimal.ZERO, ce.getItemByteLength(), ce.getTotalDigits(), ce.getFractionDigits(), ce.isSignSeparate(), ce.isSignLeading(), ce.isSigned(), hostTarget, newOffset, this.getCobolContext().getHostCharsetName());
            }
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int fromHost(ICobolZonedDecimalBinding ce, byte[] hostSource, int offset) throws HostException {
        int newOffset = offset;
        try {
            BigDecimal javaDecimal = CobolZonedDecimalSimpleConverter.fromHostSingle(ce.getByteLength(), ce.getTotalDigits(), ce.getFractionDigits(), ce.isSigned(), ce.isSignSeparate(), ce.isSignLeading(), hostSource, newOffset, this.getCobolContext().getHostCharsetName());
            ce.setBigDecimalValue(javaDecimal);
            newOffset += ce.getByteLength();
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int fromHost(ICobolArrayZonedDecimalBinding ce, byte[] hostSource, int offset, int currentOccurs) throws HostException {
        ArrayList<BigDecimal> lArray = new ArrayList<BigDecimal>();
        int newOffset = offset;
        try {
            for (int i = 0; i < currentOccurs; ++i) {
                BigDecimal javaDecimal = CobolZonedDecimalSimpleConverter.fromHostSingle(ce.getItemByteLength(), ce.getTotalDigits(), ce.getFractionDigits(), ce.isSigned(), ce.isSignSeparate(), ce.isSignLeading(), hostSource, newOffset, this.getCobolContext().getHostCharsetName());
                lArray.add(javaDecimal);
                newOffset += ce.getItemByteLength();
            }
            ce.setBigDecimalList(lArray);
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public static final int toHostSingle(BigDecimal javaDecimal, int cobolByteLength, int totalDigits, int fractionDigits, boolean isSigned, boolean isSignSeparate, boolean isSignLeading, byte[] hostTarget, int offset, String hostCharsetName) throws CobolConversionException {
        int i;
        int iSource;
        int totalJavaDigits;
        int lastOffset = offset + cobolByteLength;
        if (lastOffset > hostTarget.length) {
            throw new CobolConversionException("Attempt to write past end of host source buffer", new HostData(hostTarget), offset, cobolByteLength);
        }
        boolean toEBCDIC = hostCharsetName.startsWith("IBM");
        int hostZero = toEBCDIC ? -16 : 48;
        int hostMinus = toEBCDIC ? 96 : 45;
        int hostPlus = toEBCDIC ? 78 : 43;
        int iTarget = offset + (isSigned && isSignSeparate && isSignLeading ? 1 : 0);
        int intHostDigits = totalDigits - fractionDigits;
        char[] source = new char[]{'0'};
        int fractionJavaDigits = 0;
        int intJavaPrecision = 0;
        boolean isNegative = false;
        if (javaDecimal != null) {
            source = javaDecimal.toPlainString().toCharArray();
            fractionJavaDigits = javaDecimal.scale();
            intJavaPrecision = javaDecimal.precision();
            isNegative = javaDecimal.signum() == -1;
        }
        int n = totalJavaDigits = intJavaPrecision > fractionJavaDigits ? intJavaPrecision : fractionJavaDigits + 1;
        if (totalJavaDigits > totalDigits) {
            throw new CobolConversionException("BigDecimal value too large for target Cobol field", new HostData(hostTarget), offset, cobolByteLength);
        }
        int intJavaDigits = totalJavaDigits - fractionJavaDigits;
        int n2 = iSource = intJavaDigits > intHostDigits ? intJavaDigits - intHostDigits : 0;
        if (isNegative) {
            ++iSource;
        }
        for (i = 0; i < intHostDigits; ++i) {
            if (i < intHostDigits - intJavaDigits) {
                hostTarget[iTarget] = hostZero;
            } else {
                hostTarget[iTarget] = toEBCDIC ? ORDERED_ZONED_DECIMAL_EBCDIC_BYTES[source[iSource] - 48] : (byte)source[iSource];
                ++iSource;
            }
            ++iTarget;
        }
        ++iSource;
        for (i = 0; i < fractionDigits; ++i) {
            if (i >= fractionJavaDigits) {
                hostTarget[iTarget] = hostZero;
            } else {
                hostTarget[iTarget] = toEBCDIC ? ORDERED_ZONED_DECIMAL_EBCDIC_BYTES[source[iSource] - 48] : (byte)source[iSource];
                ++iSource;
            }
            ++iTarget;
        }
        if (isSigned && isSignSeparate && !isSignLeading) {
            ++iTarget;
        }
        if (isSigned) {
            if (isSignSeparate) {
                if (isSignLeading) {
                    hostTarget[offset] = isNegative ? hostMinus : hostPlus;
                } else {
                    hostTarget[iTarget - 1] = isNegative ? hostMinus : hostPlus;
                }
            } else if (isSignLeading) {
                hostTarget[offset] = isNegative ? (byte)(hostTarget[offset] - 32) : (byte)(hostTarget[offset] - 48);
            } else {
                hostTarget[iTarget - 1] = isNegative ? (byte)(hostTarget[iTarget - 1] - 32) : (byte)(hostTarget[iTarget - 1] - 48);
            }
        }
        return iTarget;
    }

    public static final BigDecimal fromHostSingle(int cobolByteLength, int totalDigits, int fractionDigits, boolean isSigned, boolean isSignSeparate, boolean isSignLeading, byte[] hostSource, int offset, String hostCharsetName) throws CobolConversionException {
        BigDecimal result;
        int lastOffset = offset + cobolByteLength;
        if (lastOffset > hostSource.length) {
            return new BigDecimal(0).setScale(fractionDigits);
        }
        if (lastOffset < 1) {
            throw new CobolConversionException("Invalid host byte length", new HostData(hostSource), offset, cobolByteLength);
        }
        int sourceSize = totalDigits;
        if (isSigned) {
            ++sourceSize;
        }
        char[] workDecimal = new char[sourceSize];
        int i = isSigned && (!isSignLeading || isSignLeading && !isSignSeparate) ? 1 : 0;
        for (int iSource = offset; iSource < lastOffset; ++iSource) {
            byte hostByte = hostSource[iSource];
            if (isSigned) {
                if (iSource == offset && isSignLeading && !isSignSeparate) {
                    CobolZonedDecimalSimpleConverter.setFromOverPunch(workDecimal, hostByte, i);
                    ++i;
                    continue;
                }
                if (iSource == lastOffset - 1 && !isSignLeading) {
                    if (isSignSeparate) {
                        workDecimal[0] = CobolZonedDecimalSimpleConverter.toJavaChar(hostByte);
                    } else {
                        CobolZonedDecimalSimpleConverter.setFromOverPunch(workDecimal, hostByte, i);
                    }
                    ++i;
                    continue;
                }
            }
            workDecimal[i] = CobolZonedDecimalSimpleConverter.toJavaChar(hostByte);
            ++i;
        }
        try {
            result = new BigDecimal(workDecimal);
        }
        catch (NumberFormatException e) {
            throw new CobolConversionException("Host data contains a byte that is not a valid zoned decimal byte", new HostData(hostSource), offset, cobolByteLength);
        }
        if (fractionDigits == 0) {
            return result;
        }
        return result.movePointLeft(fractionDigits);
    }

    protected static void setFromOverPunch(char[] workDecimal, byte hostByte, int i) {
        int signCode = hostByte & 0xF0;
        workDecimal[0] = signCode == 208 ? CobolZonedDecimalSimpleConverter.toJavaChar((byte)96) : CobolZonedDecimalSimpleConverter.toJavaChar((byte)78);
        workDecimal[i] = CobolZonedDecimalSimpleConverter.toJavaChar((byte)((hostByte & 0xF) + 240));
    }

    public static char toJavaChar(byte hostByte) {
        int i = Arrays.binarySearch(ORDERED_ZONED_DECIMAL_EBCDIC_BYTES, hostByte);
        if (i < 0) {
            i = Arrays.binarySearch(ORDERED_ZONED_DECIMAL_ASCII_BYTES, hostByte);
            if (i < 0) {
                return '\u0000';
            }
            return ZONED_DECIMAL_ASCII_BYTES_TO_JAVA_CHARS[i];
        }
        return ZONED_DECIMAL_EBCDIC_BYTES_TO_JAVA_CHARS[i];
    }
}

