/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.convert.simple;

import com.legstar.coxb.CobolContext;
import com.legstar.coxb.ICobolArrayStringBinding;
import com.legstar.coxb.ICobolStringBinding;
import com.legstar.coxb.convert.CobolConversionException;
import com.legstar.coxb.convert.ICobolStringConverter;
import com.legstar.coxb.convert.simple.CobolSimpleConverter;
import com.legstar.coxb.host.HostData;
import com.legstar.coxb.host.HostException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CobolStringSimpleConverter
extends CobolSimpleConverter
implements ICobolStringConverter {
    private static final Pattern BINARY_CONTENT_PATTERN = Pattern.compile("0x[\\da-fA-F]+");

    public CobolStringSimpleConverter(CobolContext cobolContext) {
        super(cobolContext);
    }

    public int toHost(ICobolStringBinding ce, byte[] hostTarget, int offset) throws HostException {
        int newOffset = 0;
        try {
            newOffset = CobolStringSimpleConverter.toHostSingle(ce.getStringValue(), this.getCobolContext().getHostCharsetName(), this.getCobolContext().getAlphanumPaddingChar(), this.getCobolContext().failOnAlphanumOverflow(), ce.getByteLength(), ce.isJustifiedRight(), hostTarget, offset);
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int toHost(ICobolArrayStringBinding ce, byte[] hostTarget, int offset, int currentOccurs) throws HostException {
        int newOffset = offset;
        try {
            for (String javaSource : ce.getStringList()) {
                newOffset = CobolStringSimpleConverter.toHostSingle(javaSource, this.getCobolContext().getHostCharsetName(), this.getCobolContext().getAlphanumPaddingChar(), this.getCobolContext().failOnAlphanumOverflow(), ce.getItemByteLength(), ce.isJustifiedRight(), hostTarget, newOffset);
            }
            for (int i = ce.getStringList().size(); i < currentOccurs; ++i) {
                newOffset = CobolStringSimpleConverter.toHostSingle("", this.getCobolContext().getHostCharsetName(), this.getCobolContext().getAlphanumPaddingChar(), this.getCobolContext().failOnAlphanumOverflow(), ce.getItemByteLength(), ce.isJustifiedRight(), hostTarget, newOffset);
            }
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int fromHost(ICobolStringBinding ce, byte[] hostSource, int offset) throws HostException {
        int newOffset = offset;
        try {
            String javaString = CobolStringSimpleConverter.fromHostSingle(this.getCobolContext().getHostCharsetName(), ce.getByteLength(), hostSource, newOffset);
            ce.setStringValue(javaString);
            newOffset += ce.getByteLength();
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int fromHost(ICobolArrayStringBinding ce, byte[] hostSource, int offset, int currentOccurs) throws HostException {
        ArrayList<String> lArray = new ArrayList<String>();
        int newOffset = offset;
        try {
            for (int i = 0; i < currentOccurs; ++i) {
                String javaString = CobolStringSimpleConverter.fromHostSingle(this.getCobolContext().getHostCharsetName(), ce.getItemByteLength(), hostSource, newOffset);
                lArray.add(javaString);
                newOffset += ce.getItemByteLength();
            }
            ce.setStringList(lArray);
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public static final int toHostSingle(String javaString, String hostCharsetName, Byte paddingChar, int cobolByteLength, boolean isJustifiedRight, byte[] hostTarget, int offset) throws CobolConversionException {
        return CobolStringSimpleConverter.toHostSingle(javaString, hostCharsetName, paddingChar, false, cobolByteLength, isJustifiedRight, hostTarget, offset);
    }

    public static final int toHostSingle(String javaString, String hostCharsetName, Byte paddingChar, boolean failOnOverflow, int cobolByteLength, boolean isJustifiedRight, byte[] hostTarget, int offset) throws CobolConversionException {
        byte padChar;
        int lastOffset = offset + cobolByteLength;
        if (lastOffset > hostTarget.length) {
            throw new CobolConversionException("Attempt to write past end of host source buffer", new HostData(hostTarget), offset, cobolByteLength);
        }
        byte[] hostSource = new byte[]{};
        if (CobolStringSimpleConverter.isBinaryContent(javaString)) {
            padChar = paddingChar == null ? (byte)0 : paddingChar;
            hostSource = HostData.toByteArray(javaString.substring(2));
        } else {
            try {
                byte by = padChar = paddingChar == null ? " ".getBytes(hostCharsetName)[0] : paddingChar;
                if (javaString != null) {
                    hostSource = javaString.getBytes(hostCharsetName);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new CobolConversionException("UnsupportedEncodingException:" + e.getMessage());
            }
        }
        if (failOnOverflow && hostSource.length > cobolByteLength) {
            throw new CobolConversionException("Java string content too long for target COBOL alphanumeric data item");
        }
        int leftPadIndex = offset;
        int rightPadIndex = lastOffset;
        if (hostSource.length < cobolByteLength) {
            if (isJustifiedRight) {
                leftPadIndex = offset + cobolByteLength - hostSource.length;
            } else {
                rightPadIndex = lastOffset - 1 - cobolByteLength + hostSource.length;
            }
        }
        int iSource = 0;
        for (int iTarget = offset; iTarget < lastOffset; ++iTarget) {
            if (iTarget < leftPadIndex || iTarget > rightPadIndex) {
                hostTarget[iTarget] = padChar;
                continue;
            }
            hostTarget[iTarget] = hostSource[iSource];
            ++iSource;
        }
        return lastOffset;
    }

    private static boolean isBinaryContent(String javaString) {
        Matcher matcher;
        return javaString != null && javaString.length() > 2 && javaString.charAt(0) == '0' && (matcher = BINARY_CONTENT_PATTERN.matcher(javaString)).matches();
    }

    public static final String fromHostSingle(String hostCharsetName, int cobolByteLength, byte[] hostSource, int offset) throws CobolConversionException {
        String javaString = null;
        int javaStringLength = cobolByteLength;
        int lastOffset = offset + cobolByteLength;
        if (lastOffset > hostSource.length) {
            if (offset >= hostSource.length) {
                return javaString;
            }
            javaStringLength = hostSource.length - offset;
        }
        try {
            int i;
            for (i = javaStringLength; i > 0 && (hostSource[offset + i - 1] == 64 || hostSource[offset + i - 1] == 0); --i) {
            }
            javaStringLength = i;
            javaString = new String(hostSource, offset, javaStringLength, hostCharsetName);
            if (javaString.indexOf("\u0000") != -1) {
                javaString = javaString.replace('\u0000', ' ');
            }
            return javaString;
        }
        catch (UnsupportedEncodingException uee) {
            throw new CobolConversionException("UnsupportedEncodingException:" + uee.getMessage());
        }
    }
}

