/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.convert.simple;

import com.legstar.coxb.CobolContext;
import com.legstar.coxb.ICobolArrayPackedDecimalBinding;
import com.legstar.coxb.ICobolPackedDecimalBinding;
import com.legstar.coxb.convert.CobolConversionException;
import com.legstar.coxb.convert.ICobolPackedDecimalConverter;
import com.legstar.coxb.convert.simple.CobolSimpleConverter;
import com.legstar.coxb.host.HostData;
import com.legstar.coxb.host.HostException;
import java.math.BigDecimal;
import java.util.ArrayList;

public class CobolPackedDecimalSimpleConverter
extends CobolSimpleConverter
implements ICobolPackedDecimalConverter {
    private static final char[] JAVA_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final int MAX_PACKED_CHARS = 128;

    public CobolPackedDecimalSimpleConverter(CobolContext cobolContext) {
        super(cobolContext);
    }

    public int toHost(ICobolPackedDecimalBinding ce, byte[] hostTarget, int offset) throws HostException {
        int newOffset = 0;
        try {
            newOffset = CobolPackedDecimalSimpleConverter.toHostSingle(ce.getBigDecimalValue(), ce.getByteLength(), ce.getTotalDigits(), ce.getFractionDigits(), ce.isSigned(), hostTarget, offset);
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int toHost(ICobolArrayPackedDecimalBinding ce, byte[] hostTarget, int offset, int currentOccurs) throws HostException {
        int newOffset = offset;
        try {
            for (BigDecimal javaSource : ce.getBigDecimalList()) {
                newOffset = CobolPackedDecimalSimpleConverter.toHostSingle(javaSource, ce.getItemByteLength(), ce.getTotalDigits(), ce.getFractionDigits(), ce.isSigned(), hostTarget, newOffset);
            }
            for (int i = ce.getBigDecimalList().size(); i < currentOccurs; ++i) {
                newOffset = CobolPackedDecimalSimpleConverter.toHostSingle(BigDecimal.ZERO, ce.getItemByteLength(), ce.getTotalDigits(), ce.getFractionDigits(), ce.isSigned(), hostTarget, newOffset);
            }
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int fromHost(ICobolPackedDecimalBinding ce, byte[] hostSource, int offset) throws HostException {
        int newOffset = offset;
        try {
            BigDecimal javaDecimal = CobolPackedDecimalSimpleConverter.fromHostSingle(ce.getByteLength(), ce.getTotalDigits(), ce.getFractionDigits(), hostSource, newOffset);
            ce.setBigDecimalValue(javaDecimal);
            newOffset += ce.getByteLength();
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int fromHost(ICobolArrayPackedDecimalBinding ce, byte[] hostSource, int offset, int currentOccurs) throws HostException {
        ArrayList<BigDecimal> lArray = new ArrayList<BigDecimal>();
        int newOffset = offset;
        try {
            for (int i = 0; i < currentOccurs; ++i) {
                BigDecimal javaDecimal = CobolPackedDecimalSimpleConverter.fromHostSingle(ce.getItemByteLength(), ce.getTotalDigits(), ce.getFractionDigits(), hostSource, newOffset);
                lArray.add(javaDecimal);
                newOffset += ce.getItemByteLength();
            }
            ce.setBigDecimalList(lArray);
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public static final int toHostSingle(BigDecimal javaDecimal, int cobolByteLength, int totalDigits, int fractionDigits, boolean isSigned, byte[] hostTarget, int offset) throws CobolConversionException {
        int i;
        int lastOffset = offset + cobolByteLength;
        if (lastOffset > hostTarget.length) {
            throw new CobolConversionException("Attempt to write past end of host source buffer", new HostData(hostTarget), offset, cobolByteLength);
        }
        BigDecimal localDecimal = javaDecimal;
        if (localDecimal == null) {
            localDecimal = BigDecimal.ZERO;
        }
        String sDecimal = localDecimal.toString();
        if (localDecimal.scale() != fractionDigits) {
            sDecimal = localDecimal.setScale(fractionDigits, 1).toString();
        }
        int javaDigits = 0;
        for (int i2 = 0; i2 < sDecimal.length(); ++i2) {
            if (!Character.isDigit(sDecimal.charAt(i2))) continue;
            ++javaDigits;
        }
        if (javaDigits > totalDigits) {
            throw new CobolConversionException("BigDecimal value too large for target Cobol field", new HostData(hostTarget), offset, cobolByteLength);
        }
        int pad = totalDigits - javaDigits;
        int iTarget = offset;
        boolean flip = false;
        int bByte = 0;
        if (totalDigits % 2 == 0) {
            flip = true;
        }
        for (i = 0; i < pad; ++i) {
            if (flip) {
                hostTarget[iTarget] = 0;
                ++iTarget;
                flip = false;
                continue;
            }
            flip = true;
        }
        for (i = 0; i < sDecimal.length(); ++i) {
            char sC = sDecimal.charAt(i);
            if (!Character.isDigit(sC)) continue;
            int digit = Character.digit(sC, 10);
            if (flip) {
                hostTarget[iTarget] = (byte)(bByte += digit);
                ++iTarget;
                flip = false;
                continue;
            }
            bByte = digit * 16;
            flip = true;
        }
        bByte = !isSigned ? (bByte += 15) : (localDecimal.signum() == -1 ? (bByte += 13) : (bByte += 12));
        hostTarget[iTarget] = (byte)bByte;
        return ++iTarget;
    }

    public static final BigDecimal fromHostSingle(int cobolByteLength, int totalDigits, int fractionDigits, byte[] hostSource, int offset) throws CobolConversionException {
        char[] sDecimal = new char[128];
        int lastOffset = offset + cobolByteLength;
        int pos = 0;
        if (lastOffset > hostSource.length) {
            return new BigDecimal(0).setScale(fractionDigits);
        }
        if (lastOffset < 1) {
            throw new CobolConversionException("Invalid host byte length", new HostData(hostSource), offset, cobolByteLength);
        }
        int s = hostSource[lastOffset - 1] & 0xF;
        if (s == 13) {
            sDecimal[pos++] = 45;
        } else if (s != 12 && s != 15) {
            throw new CobolConversionException("Host data last byte is not a valid packed decimal byte", new HostData(hostSource), offset, cobolByteLength);
        }
        int integerPart = 0;
        int[] d = new int[2];
        for (int i = offset; i < lastOffset; ++i) {
            d[0] = (hostSource[i] & 0xF0) >>> 4;
            d[1] = hostSource[i] & 0xF;
            for (int j = 0; j < 2; ++j) {
                if ((j != 0 || i == offset && totalDigits % 2 == 0) && (j != 1 || i == lastOffset - 1)) continue;
                if (integerPart == totalDigits - fractionDigits) {
                    sDecimal[pos++] = 46;
                }
                if (d[j] >= JAVA_DIGITS.length) {
                    throw new CobolConversionException("Host data contains a byte that is not a valid packed decimal byte", new HostData(hostSource), offset, cobolByteLength);
                }
                sDecimal[pos++] = JAVA_DIGITS[d[j]];
                ++integerPart;
            }
        }
        return new BigDecimal(sDecimal, 0, pos);
    }
}

