/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.convert.simple;

import com.legstar.coxb.CobolContext;
import com.legstar.coxb.ICobolArrayOctetStreamBinding;
import com.legstar.coxb.ICobolOctetStreamBinding;
import com.legstar.coxb.convert.CobolConversionException;
import com.legstar.coxb.convert.ICobolOctetStreamConverter;
import com.legstar.coxb.convert.simple.CobolSimpleConverter;
import com.legstar.coxb.host.HostData;
import com.legstar.coxb.host.HostException;
import java.util.ArrayList;

public class CobolOctetStreamSimpleConverter
extends CobolSimpleConverter
implements ICobolOctetStreamConverter {
    public CobolOctetStreamSimpleConverter(CobolContext cobolContext) {
        super(cobolContext);
    }

    public int toHost(ICobolOctetStreamBinding ce, byte[] hostTarget, int offset) throws HostException {
        int newOffset = 0;
        try {
            newOffset = CobolOctetStreamSimpleConverter.toHostSingle(ce.getByteArrayValue(), ce.getByteLength(), hostTarget, offset);
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int toHost(ICobolArrayOctetStreamBinding ce, byte[] hostTarget, int offset, int currentOccurs) throws HostException {
        int newOffset = offset;
        try {
            for (byte[] javaSource : ce.getByteArrayList()) {
                newOffset = CobolOctetStreamSimpleConverter.toHostSingle(javaSource, ce.getItemByteLength(), hostTarget, newOffset);
            }
            for (int i = ce.getByteArrayList().size(); i < currentOccurs; ++i) {
                newOffset = CobolOctetStreamSimpleConverter.toHostSingle(new byte[]{0}, ce.getItemByteLength(), hostTarget, newOffset);
            }
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int fromHost(ICobolOctetStreamBinding ce, byte[] hostSource, int offset) throws HostException {
        int newOffset = offset;
        try {
            byte[] javaBytes = CobolOctetStreamSimpleConverter.fromHostSingle(ce.getByteLength(), hostSource, newOffset);
            ce.setByteArrayValue(javaBytes);
            newOffset += ce.getByteLength();
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int fromHost(ICobolArrayOctetStreamBinding ce, byte[] hostSource, int offset, int currentOccurs) throws HostException {
        ArrayList<byte[]> lArray = new ArrayList<byte[]>();
        int newOffset = offset;
        try {
            for (int i = 0; i < currentOccurs; ++i) {
                byte[] javaBytes = CobolOctetStreamSimpleConverter.fromHostSingle(ce.getItemByteLength(), hostSource, newOffset);
                lArray.add(javaBytes);
                newOffset += ce.getItemByteLength();
            }
            ce.setByteArrayList(lArray);
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public static final int toHostSingle(byte[] javaBytes, int cobolByteLength, byte[] hostTarget, int offset) throws CobolConversionException {
        int lastOffset = offset + cobolByteLength;
        if (lastOffset > hostTarget.length) {
            throw new CobolConversionException("Attempt to write past end of host source buffer", new HostData(hostTarget), offset, cobolByteLength);
        }
        byte[] localBytes = javaBytes;
        if (localBytes == null) {
            localBytes = new byte[cobolByteLength];
        }
        for (int i = 0; i < localBytes.length && i < cobolByteLength; ++i) {
            hostTarget[offset + i] = localBytes[i];
        }
        return lastOffset;
    }

    public static final byte[] fromHostSingle(int cobolByteLength, byte[] hostSource, int offset) throws CobolConversionException {
        int i;
        int lastOffset = offset + cobolByteLength;
        int fill = 0;
        if (lastOffset > hostSource.length) {
            fill = offset >= hostSource.length ? cobolByteLength : hostSource.length - offset;
        }
        byte[] javaBytes = new byte[cobolByteLength];
        for (i = 0; i < cobolByteLength - fill; ++i) {
            javaBytes[i] = hostSource[offset + i];
        }
        for (i = cobolByteLength - fill; i < cobolByteLength; ++i) {
            javaBytes[i] = 0;
        }
        return javaBytes;
    }
}

