/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.convert.simple;

import com.legstar.coxb.CobolContext;
import com.legstar.coxb.ICobolArrayNationalBinding;
import com.legstar.coxb.ICobolNationalBinding;
import com.legstar.coxb.convert.CobolConversionException;
import com.legstar.coxb.convert.ICobolNationalConverter;
import com.legstar.coxb.convert.simple.CobolSimpleConverter;
import com.legstar.coxb.host.HostData;
import com.legstar.coxb.host.HostException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class CobolNationalSimpleConverter
extends CobolSimpleConverter
implements ICobolNationalConverter {
    private static final byte[] SPACE_UTF_16 = new byte[]{0, 32};
    private static final String NATIONAL_CHARSET = "UTF-16BE";

    public CobolNationalSimpleConverter(CobolContext cobolContext) {
        super(cobolContext);
    }

    public int toHost(ICobolNationalBinding ce, byte[] hostTarget, int offset) throws HostException {
        int newOffset = 0;
        try {
            newOffset = CobolNationalSimpleConverter.toHostSingle(ce.getStringValue(), ce.getByteLength(), ce.isJustifiedRight(), hostTarget, offset);
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int toHost(ICobolArrayNationalBinding ce, byte[] hostTarget, int offset, int currentOccurs) throws HostException {
        int newOffset = offset;
        try {
            for (String javaSource : ce.getStringList()) {
                newOffset = CobolNationalSimpleConverter.toHostSingle(javaSource, ce.getItemByteLength(), ce.isJustifiedRight(), hostTarget, newOffset);
            }
            for (int i = ce.getStringList().size(); i < currentOccurs; ++i) {
                newOffset = CobolNationalSimpleConverter.toHostSingle("", ce.getItemByteLength(), ce.isJustifiedRight(), hostTarget, newOffset);
            }
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int fromHost(ICobolNationalBinding ce, byte[] hostSource, int offset) throws HostException {
        int newOffset = offset;
        try {
            String javaString = CobolNationalSimpleConverter.fromHostSingle(ce.getByteLength(), hostSource, newOffset);
            ce.setStringValue(javaString);
            newOffset += ce.getByteLength();
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int fromHost(ICobolArrayNationalBinding ce, byte[] hostSource, int offset, int currentOccurs) throws HostException {
        ArrayList<String> lArray = new ArrayList<String>();
        int newOffset = offset;
        try {
            for (int i = 0; i < currentOccurs; ++i) {
                String javaString = CobolNationalSimpleConverter.fromHostSingle(ce.getItemByteLength(), hostSource, newOffset);
                lArray.add(javaString);
                newOffset += ce.getItemByteLength();
            }
            ce.setStringList(lArray);
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public static final int toHostSingle(String javaString, int cobolByteLength, boolean isJustifiedRight, byte[] hostTarget, int offset) throws CobolConversionException {
        int iTarget;
        byte[] hostSource;
        int lastOffset = offset + cobolByteLength;
        if (lastOffset > hostTarget.length) {
            throw new CobolConversionException("Attempt to write past end of host source buffer", new HostData(hostTarget), offset, cobolByteLength);
        }
        try {
            hostSource = javaString == null ? "".getBytes(NATIONAL_CHARSET) : javaString.getBytes(NATIONAL_CHARSET);
        }
        catch (UnsupportedEncodingException uee) {
            throw new CobolConversionException("UnsupportedEncodingException:" + uee.getMessage());
        }
        int iSource = 0;
        int hsl = hostSource.length;
        boolean flip = true;
        if (isJustifiedRight) {
            for (iTarget = offset; iTarget < lastOffset - hsl; ++iTarget) {
                hostTarget[iTarget] = SPACE_UTF_16[flip ? 0 : 1];
                flip = !flip;
            }
        }
        while (iSource < hostSource.length && iTarget < lastOffset) {
            hostTarget[iTarget] = hostSource[iSource];
            ++iSource;
            ++iTarget;
        }
        flip = true;
        if (!isJustifiedRight) {
            while (iTarget < lastOffset) {
                hostTarget[iTarget] = SPACE_UTF_16[flip ? 0 : 1];
                ++iTarget;
                flip = !flip;
            }
        }
        return lastOffset;
    }

    public static final String fromHostSingle(int cobolByteLength, byte[] hostSource, int offset) throws CobolConversionException {
        String javaString = null;
        int javaStringLength = cobolByteLength;
        int lastOffset = offset + cobolByteLength;
        if (lastOffset > hostSource.length) {
            if (offset >= hostSource.length) {
                return javaString;
            }
            javaStringLength = hostSource.length - offset;
        }
        try {
            javaString = new String(hostSource, offset, javaStringLength, NATIONAL_CHARSET);
            if (javaString.indexOf("\u0000") != -1) {
                javaString = javaString.replace('\u0000', ' ');
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new CobolConversionException("UnsupportedEncodingException:" + uee.getMessage());
        }
        return javaString;
    }
}

