/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.convert.simple;

import com.legstar.coxb.CobolContext;
import com.legstar.coxb.ICobolArrayFloatBinding;
import com.legstar.coxb.ICobolFloatBinding;
import com.legstar.coxb.convert.CobolConversionException;
import com.legstar.coxb.convert.ICobolFloatConverter;
import com.legstar.coxb.convert.simple.CobolSimpleConverter;
import com.legstar.coxb.host.HostData;
import com.legstar.coxb.host.HostException;
import com.legstar.coxb.host.HostFloat;
import java.util.ArrayList;

public class CobolFloatSimpleConverter
extends CobolSimpleConverter
implements ICobolFloatConverter {
    public CobolFloatSimpleConverter(CobolContext cobolContext) {
        super(cobolContext);
    }

    public int toHost(ICobolFloatBinding ce, byte[] hostTarget, int offset) throws HostException {
        int newOffset = 0;
        try {
            newOffset = CobolFloatSimpleConverter.toHostSingle(ce.getFloatValue(), hostTarget, offset);
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int toHost(ICobolArrayFloatBinding ce, byte[] hostTarget, int offset, int currentOccurs) throws HostException {
        int newOffset = offset;
        try {
            for (Float javaSource : ce.getFloatList()) {
                newOffset = CobolFloatSimpleConverter.toHostSingle(javaSource, hostTarget, newOffset);
            }
            for (int i = ce.getFloatList().size(); i < currentOccurs; ++i) {
                newOffset = CobolFloatSimpleConverter.toHostSingle(Float.valueOf(0.0f), hostTarget, newOffset);
            }
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int fromHost(ICobolFloatBinding ce, byte[] hostSource, int offset) throws HostException {
        int newOffset = offset;
        try {
            Float javaFloat = CobolFloatSimpleConverter.fromHostSingle(ce.getByteLength(), hostSource, newOffset);
            ce.setFloatValue(javaFloat);
            newOffset += ce.getByteLength();
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int fromHost(ICobolArrayFloatBinding ce, byte[] hostSource, int offset, int currentOccurs) throws HostException {
        ArrayList<Float> lArray = new ArrayList<Float>();
        int newOffset = offset;
        try {
            for (int i = 0; i < currentOccurs; ++i) {
                Float javaFloat = CobolFloatSimpleConverter.fromHostSingle(ce.getItemByteLength(), hostSource, newOffset);
                lArray.add(javaFloat);
                newOffset += ce.getItemByteLength();
            }
            ce.setFloatList(lArray);
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public static final int toHostSingle(Float javaFloat, byte[] hostTarget, int offset) throws CobolConversionException {
        int cobolByteLength = 4;
        int lastOffset = offset + cobolByteLength;
        if (lastOffset > hostTarget.length) {
            throw new CobolConversionException("Attempt to write past end of host source buffer", new HostData(hostTarget), offset);
        }
        Float localFloat = javaFloat;
        if (localFloat == null) {
            localFloat = Float.valueOf(0.0f);
        }
        if (localFloat.isInfinite()) {
            throw new CobolConversionException("Infinite floats are not supported", new HostData(hostTarget), offset);
        }
        if (localFloat.isNaN()) {
            throw new CobolConversionException("NaN floats are not supported", new HostData(hostTarget), offset);
        }
        if (localFloat.floatValue() == 0.0f || localFloat.floatValue() == -0.0f) {
            for (int i = 0; i < 4; ++i) {
                hostTarget[offset + i] = 0;
            }
            return offset + cobolByteLength;
        }
        HostFloat jF = CobolFloatSimpleConverter.parseJavaFloat(localFloat.floatValue());
        HostFloat hF = new HostFloat();
        hF.setSign(jF.getSign());
        int r = jF.getExponent() % 4;
        int mantissaShift = 0;
        mantissaShift = r <= 0 ? -1 * r : 4 - r;
        hF.setExponent((jF.getExponent() + mantissaShift) / 4);
        hF.setMantissa(jF.getMantissa() >> mantissaShift);
        int hostIntBits = CobolFloatSimpleConverter.createHostFloat(hF);
        for (int i = 0; i < 4; ++i) {
            hostTarget[offset + i] = (byte)(hostIntBits >>> 24 - i * 8 & 0xFF);
        }
        return offset + cobolByteLength;
    }

    public static final Float fromHostSingle(int cobolByteLength, byte[] hostSource, int offset) throws CobolConversionException {
        int lastOffset = offset + cobolByteLength;
        if (lastOffset > hostSource.length) {
            return Float.valueOf(0.0f);
        }
        int hostIntBits = 0;
        for (int i = 0; i < 4; ++i) {
            hostIntBits |= (hostSource[offset + (3 - i)] & 0xFF) << i * 8;
        }
        HostFloat hF = CobolFloatSimpleConverter.parseHostFloat(hostIntBits);
        HostFloat jF = new HostFloat();
        jF.setSign(hF.getSign());
        if (hF.getMantissa() != 0) {
            jF.setExponent(4 * hF.getExponent() - 1);
        }
        jF.setMantissa(hF.getMantissa());
        while (jF.getMantissa() > 0 && (jF.getMantissa() & 0x800000) == 0) {
            jF.setMantissa(jF.getMantissa() << 1);
            jF.setExponent(jF.getExponent() - 1);
        }
        return Float.valueOf(CobolFloatSimpleConverter.createJavaFloat(jF));
    }

    public static final HostFloat parseJavaFloat(float f) {
        HostFloat jF = new HostFloat();
        if (f == 0.0f) {
            return jF;
        }
        int javaIntBits = Float.floatToIntBits(f);
        jF.setSign((javaIntBits & Integer.MIN_VALUE) >>> 31);
        int excess = (javaIntBits & 0x7F800000) >>> 23;
        jF.setExponent(excess - 127 + 1);
        int orMask = 0x800000;
        jF.setMantissa(javaIntBits & 0x7FFFFF | orMask);
        return jF;
    }

    public static final float createJavaFloat(HostFloat jF) {
        if (jF.getExponent() == 0 && jF.getMantissa() == 0) {
            return 0.0f;
        }
        int javaIntBits = jF.getMantissa() & 0x7FFFFF;
        javaIntBits |= jF.getExponent() + 127 << 23;
        return Float.intBitsToFloat(javaIntBits |= jF.getSign() << 31);
    }

    public static final HostFloat parseHostFloat(int hostIntBits) {
        HostFloat hF = new HostFloat();
        hF.setSign((hostIntBits & Integer.MIN_VALUE) >>> 31);
        int excess = (hostIntBits & 0x7F000000) >>> 24;
        if (excess != 0) {
            hF.setExponent(excess - 64);
        }
        hF.setMantissa(hostIntBits & 0xFFFFFF);
        return hF;
    }

    public static final int createHostFloat(HostFloat hF) {
        if (hF.getExponent() == 0 && hF.getMantissa() == 0) {
            return 0;
        }
        int hostIntBits = hF.getMantissa();
        hostIntBits |= hF.getExponent() + 64 << 24;
        return hostIntBits |= hF.getSign() << 31;
    }
}

