/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.convert.simple;

import com.legstar.coxb.CobolContext;
import com.legstar.coxb.ICobolArrayDoubleBinding;
import com.legstar.coxb.ICobolDoubleBinding;
import com.legstar.coxb.convert.CobolConversionException;
import com.legstar.coxb.convert.ICobolDoubleConverter;
import com.legstar.coxb.convert.simple.CobolSimpleConverter;
import com.legstar.coxb.host.HostData;
import com.legstar.coxb.host.HostDouble;
import com.legstar.coxb.host.HostException;
import java.util.ArrayList;

public class CobolDoubleSimpleConverter
extends CobolSimpleConverter
implements ICobolDoubleConverter {
    public CobolDoubleSimpleConverter(CobolContext cobolContext) {
        super(cobolContext);
    }

    public int toHost(ICobolDoubleBinding ce, byte[] hostTarget, int offset) throws HostException {
        int newOffset = 0;
        try {
            newOffset = CobolDoubleSimpleConverter.toHostSingle(ce.getDoubleValue(), hostTarget, offset);
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int toHost(ICobolArrayDoubleBinding ce, byte[] hostTarget, int offset, int currentOccurs) throws HostException {
        int newOffset = offset;
        try {
            for (Double javaSource : ce.getDoubleList()) {
                newOffset = CobolDoubleSimpleConverter.toHostSingle(javaSource, hostTarget, newOffset);
            }
            for (int i = ce.getDoubleList().size(); i < currentOccurs; ++i) {
                newOffset = CobolDoubleSimpleConverter.toHostSingle(0.0, hostTarget, newOffset);
            }
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int fromHost(ICobolDoubleBinding ce, byte[] hostSource, int offset) throws HostException {
        int newOffset = offset;
        try {
            Double javaDouble = CobolDoubleSimpleConverter.fromHostSingle(ce.getByteLength(), hostSource, newOffset);
            ce.setDoubleValue(javaDouble);
            newOffset += ce.getByteLength();
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int fromHost(ICobolArrayDoubleBinding ce, byte[] hostSource, int offset, int currentOccurs) throws HostException {
        ArrayList<Double> lArray = new ArrayList<Double>();
        int newOffset = offset;
        try {
            for (int i = 0; i < currentOccurs; ++i) {
                Double javaDouble = CobolDoubleSimpleConverter.fromHostSingle(ce.getItemByteLength(), hostSource, newOffset);
                lArray.add(javaDouble);
                newOffset += ce.getItemByteLength();
            }
            ce.setDoubleList(lArray);
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public static final int toHostSingle(Double javaDouble, byte[] hostTarget, int offset) throws CobolConversionException {
        int cobolByteLength = 8;
        int lastOffset = offset + cobolByteLength;
        if (lastOffset > hostTarget.length) {
            throw new CobolConversionException("Attempt to write past end of host source buffer", new HostData(hostTarget), offset);
        }
        Double localDouble = javaDouble;
        if (localDouble == null) {
            localDouble = 0.0;
        }
        if (localDouble.isInfinite()) {
            throw new CobolConversionException("Infinite doubles are not supported", new HostData(hostTarget), offset);
        }
        if (localDouble.isNaN()) {
            throw new CobolConversionException("NaN doubles are not supported", new HostData(hostTarget), offset);
        }
        if (localDouble == 0.0 || localDouble == -0.0) {
            for (int i = 0; i < 8; ++i) {
                hostTarget[offset + i] = 0;
            }
            return offset + cobolByteLength;
        }
        HostDouble jF = CobolDoubleSimpleConverter.parseJavaDouble(localDouble);
        HostDouble hF = new HostDouble();
        hF.setSign(jF.getSign());
        int r = jF.getExponent() % 4;
        int mantissaShift = 0;
        mantissaShift = r <= 0 ? -1 * r : 4 - r;
        hF.setExponent((jF.getExponent() + mantissaShift) / 4);
        hF.setMantissa(jF.getMantissa() >> mantissaShift);
        hF.setMantissa(hF.getMantissa() << 3);
        long hostLongBits = CobolDoubleSimpleConverter.createHostDouble(hF);
        for (int i = 0; i < 8; ++i) {
            hostTarget[offset + i] = (byte)(hostLongBits >>> 56 - i * 8 & 0xFFL);
        }
        return offset + cobolByteLength;
    }

    public static final Double fromHostSingle(int cobolByteLength, byte[] hostSource, int offset) throws CobolConversionException {
        int lastOffset = offset + cobolByteLength;
        if (lastOffset > hostSource.length) {
            return 0.0;
        }
        long hostLongBits = 0L;
        for (int i = 0; i < 8; ++i) {
            hostLongBits |= (long)(hostSource[offset + (7 - i)] & 0xFF) << i * 8;
        }
        HostDouble hF = CobolDoubleSimpleConverter.parseHostDouble(hostLongBits);
        HostDouble jF = new HostDouble();
        jF.setSign(hF.getSign());
        if (hF.getMantissa() != 0L) {
            jF.setExponent(4 * hF.getExponent() - 1);
        }
        jF.setMantissa(hF.getMantissa() >>> 3);
        while (jF.getMantissa() > 0L && (jF.getMantissa() & 0x10000000000000L) == 0L) {
            jF.setMantissa(jF.getMantissa() << 1);
            jF.setExponent(jF.getExponent() - 1);
        }
        return CobolDoubleSimpleConverter.createJavaDouble(jF);
    }

    public static final HostDouble parseJavaDouble(double f) {
        HostDouble jF = new HostDouble();
        if (f == 0.0) {
            return jF;
        }
        long javaLongBits = Double.doubleToLongBits(f);
        jF.setSign((int)((javaLongBits & Long.MIN_VALUE) >>> 63));
        int excess = (int)(javaLongBits >> 52 & 0x7FFL);
        jF.setExponent(excess - 1023 + 1);
        long orMask = 0x10000000000000L;
        jF.setMantissa(javaLongBits & 0xFFFFFFFFFFFFFL | orMask);
        return jF;
    }

    public static final double createJavaDouble(HostDouble jF) {
        if (jF.getExponent() == 0 && jF.getMantissa() == 0L) {
            return 0.0;
        }
        long javaLongBits = jF.getMantissa() & 0xFFFFFFFFFFFFFL;
        javaLongBits |= (long)(jF.getExponent() + 1023) << 52;
        return Double.longBitsToDouble(javaLongBits |= (long)jF.getSign() << 63);
    }

    public static final HostDouble parseHostDouble(long hostLongBits) {
        HostDouble hF = new HostDouble();
        hF.setSign((int)((hostLongBits & Long.MIN_VALUE) >>> 63));
        int excess = (int)((hostLongBits & 0x7F00000000000000L) >>> 56);
        if (excess != 0) {
            hF.setExponent(excess - 64);
        }
        hF.setMantissa(hostLongBits & 0xFFFFFFFFFFFFFFL);
        return hF;
    }

    public static final long createHostDouble(HostDouble hF) {
        if (hF.getExponent() == 0 && hF.getMantissa() == 0L) {
            return 0L;
        }
        long hostLongBits = hF.getMantissa();
        hostLongBits |= (long)(hF.getExponent() + 64) << 56;
        return hostLongBits |= (long)hF.getSign() << 63;
    }
}

