/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.convert.simple;

import com.legstar.coxb.CobolContext;
import com.legstar.coxb.ICobolArrayDbcsBinding;
import com.legstar.coxb.ICobolDbcsBinding;
import com.legstar.coxb.convert.CobolConversionException;
import com.legstar.coxb.convert.ICobolDbcsConverter;
import com.legstar.coxb.convert.simple.CobolSimpleConverter;
import com.legstar.coxb.host.HostData;
import com.legstar.coxb.host.HostException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class CobolDbcsSimpleConverter
extends CobolSimpleConverter
implements ICobolDbcsConverter {
    public static final char SHIFT_IN = '\u000e';
    public static final char SHIFT_OUT = '\u000f';

    public CobolDbcsSimpleConverter(CobolContext cobolContext) {
        super(cobolContext);
    }

    public int toHost(ICobolDbcsBinding ce, byte[] hostTarget, int offset) throws HostException {
        int newOffset = 0;
        try {
            newOffset = CobolDbcsSimpleConverter.toHostSingle(ce.getStringValue(), this.getCobolContext().getHostCharsetName(), ce.getByteLength(), ce.isJustifiedRight(), hostTarget, offset);
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int toHost(ICobolArrayDbcsBinding ce, byte[] hostTarget, int offset, int currentOccurs) throws HostException {
        int newOffset = offset;
        try {
            for (String javaSource : ce.getStringList()) {
                newOffset = CobolDbcsSimpleConverter.toHostSingle(javaSource, this.getCobolContext().getHostCharsetName(), ce.getItemByteLength(), ce.isJustifiedRight(), hostTarget, newOffset);
            }
            for (int i = ce.getStringList().size(); i < currentOccurs; ++i) {
                newOffset = CobolDbcsSimpleConverter.toHostSingle("", this.getCobolContext().getHostCharsetName(), ce.getItemByteLength(), ce.isJustifiedRight(), hostTarget, newOffset);
            }
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int fromHost(ICobolDbcsBinding ce, byte[] hostSource, int offset) throws HostException {
        int newOffset = offset;
        try {
            String javaString = CobolDbcsSimpleConverter.fromHostSingle(this.getCobolContext().getHostCharsetName(), ce.getByteLength(), hostSource, newOffset);
            ce.setStringValue(javaString);
            newOffset += ce.getByteLength();
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int fromHost(ICobolArrayDbcsBinding ce, byte[] hostSource, int offset, int currentOccurs) throws HostException {
        ArrayList<String> lArray = new ArrayList<String>();
        int newOffset = offset;
        try {
            for (int i = 0; i < currentOccurs; ++i) {
                String javaString = CobolDbcsSimpleConverter.fromHostSingle(this.getCobolContext().getHostCharsetName(), ce.getItemByteLength(), hostSource, newOffset);
                lArray.add(javaString);
                newOffset += ce.getItemByteLength();
            }
            ce.setStringList(lArray);
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public static final int toHostSingle(String javaString, String hostCharsetName, int cobolByteLength, boolean isJustifiedRight, byte[] hostTarget, int offset) throws CobolConversionException {
        int lastOffset = offset + cobolByteLength;
        if (lastOffset > hostTarget.length) {
            throw new CobolConversionException("Attempt to write past end of host source buffer", new HostData(hostTarget), offset, cobolByteLength);
        }
        try {
            byte[] hostSource = javaString == null ? "".getBytes(hostCharsetName) : javaString.getBytes(hostCharsetName);
            int iSource = 0;
            int iTarget = offset;
            int iLength = hostSource.length;
            if (iLength > 0) {
                if (hostSource[0] == 14) {
                    ++iSource;
                }
                if (hostSource[hostSource.length - 1] == 15) {
                    --iLength;
                }
            }
            if (isJustifiedRight) {
                iTarget += CobolDbcsSimpleConverter.pad(hostTarget, iTarget, lastOffset - iLength, hostCharsetName);
            }
            while (iSource < iLength && iTarget < lastOffset) {
                hostTarget[iTarget] = hostSource[iSource];
                ++iSource;
                ++iTarget;
            }
            if (!isJustifiedRight) {
                CobolDbcsSimpleConverter.pad(hostTarget, iTarget, lastOffset, hostCharsetName);
            }
            return lastOffset;
        }
        catch (UnsupportedEncodingException uee) {
            throw new CobolConversionException("UnsupportedEncodingException:" + uee.getMessage());
        }
    }

    public static final String fromHostSingle(String hostCharsetName, int cobolByteLength, byte[] hostSource, int offset) throws CobolConversionException {
        String javaString = null;
        int javaStringLength = cobolByteLength;
        int lastOffset = offset + cobolByteLength;
        if (lastOffset > hostSource.length) {
            if (offset >= hostSource.length) {
                return javaString;
            }
            javaStringLength = hostSource.length - offset;
        }
        byte[] shiftHostSource = new byte[javaStringLength + 2];
        shiftHostSource[0] = 14;
        System.arraycopy(hostSource, offset, shiftHostSource, 1, javaStringLength);
        shiftHostSource[shiftHostSource.length - 1] = 15;
        javaStringLength += 2;
        try {
            javaString = new String(shiftHostSource, 0, javaStringLength, hostCharsetName);
            if (javaString.indexOf("\u0000") != -1) {
                javaString = javaString.replace('\u0000', ' ');
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new CobolConversionException("UnsupportedEncodingException:" + uee.getMessage());
        }
        return javaString.trim();
    }

    private static byte getPadChar(String hostCharsetName) throws UnsupportedEncodingException {
        return " ".getBytes(hostCharsetName)[0];
    }

    public static int pad(byte[] bytes, int beginIndex, int endIndex, String hostCharsetName) throws UnsupportedEncodingException {
        byte padChar = CobolDbcsSimpleConverter.getPadChar(hostCharsetName);
        int j = 0;
        for (int i = beginIndex; i < endIndex; ++i) {
            bytes[i] = padChar;
            ++j;
        }
        return j;
    }
}

