/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.coxb.convert.simple;

import com.legstar.coxb.CobolContext;
import com.legstar.coxb.ICobolArrayBinaryBinding;
import com.legstar.coxb.ICobolBinaryBinding;
import com.legstar.coxb.convert.CobolConversionException;
import com.legstar.coxb.convert.ICobolBinaryConverter;
import com.legstar.coxb.convert.simple.CobolSimpleConverter;
import com.legstar.coxb.host.HostData;
import com.legstar.coxb.host.HostException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;

public class CobolBinarySimpleConverter
extends CobolSimpleConverter
implements ICobolBinaryConverter {
    public CobolBinarySimpleConverter(CobolContext cobolContext) {
        super(cobolContext);
    }

    public int toHost(ICobolBinaryBinding ce, byte[] hostTarget, int offset) throws HostException {
        int newOffset = 0;
        try {
            newOffset = CobolBinarySimpleConverter.toHostSingle(ce.getBigDecimalValue(), ce.getByteLength(), ce.isSigned(), hostTarget, offset);
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int toHost(ICobolArrayBinaryBinding ce, byte[] hostTarget, int offset, int currentOccurs) throws HostException {
        int newOffset = offset;
        try {
            for (BigDecimal javaSource : ce.getBigDecimalList()) {
                newOffset = CobolBinarySimpleConverter.toHostSingle(javaSource, ce.getItemByteLength(), ce.isSigned(), hostTarget, newOffset);
            }
            for (int i = ce.getBigDecimalList().size(); i < currentOccurs; ++i) {
                newOffset = CobolBinarySimpleConverter.toHostSingle(BigDecimal.ZERO, ce.getItemByteLength(), ce.isSigned(), hostTarget, newOffset);
            }
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int fromHost(ICobolBinaryBinding ce, byte[] hostSource, int offset) throws HostException {
        int newOffset = offset;
        try {
            BigDecimal javaDecimal = CobolBinarySimpleConverter.fromHostSingle(ce.getByteLength(), ce.isSigned(), ce.getTotalDigits(), ce.getFractionDigits(), hostSource, newOffset);
            ce.setBigDecimalValue(javaDecimal);
            newOffset += ce.getByteLength();
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public int fromHost(ICobolArrayBinaryBinding ce, byte[] hostSource, int offset, int currentOccurs) throws HostException {
        ArrayList<BigDecimal> lArray = new ArrayList<BigDecimal>();
        int newOffset = offset;
        try {
            for (int i = 0; i < currentOccurs; ++i) {
                BigDecimal javaDecimal = CobolBinarySimpleConverter.fromHostSingle(ce.getItemByteLength(), ce.isSigned(), ce.getTotalDigits(), ce.getFractionDigits(), hostSource, newOffset);
                lArray.add(javaDecimal);
                newOffset += ce.getItemByteLength();
            }
            ce.setBigDecimalList(lArray);
        }
        catch (CobolConversionException e) {
            this.throwHostException(ce, e);
        }
        return newOffset;
    }

    public static final int toHostSingle(BigDecimal javaDecimal, int cobolByteLength, boolean isSigned, byte[] hostTarget, int offset) throws CobolConversionException {
        int lastOffset = offset + cobolByteLength;
        if (lastOffset > hostTarget.length) {
            throw new CobolConversionException("Attempt to write past end of host source buffer", new HostData(hostTarget), offset, cobolByteLength);
        }
        BigInteger javaInteger = javaDecimal == null ? BigInteger.ZERO : javaDecimal.unscaledValue();
        byte[] javaBytes = javaInteger.toByteArray();
        if (!isSigned) {
            if (javaBytes.length > cobolByteLength + 1) {
                throw new CobolConversionException("Java binary too large for Cobol element", new HostData(hostTarget), offset, cobolByteLength);
            }
            if (javaBytes.length == cobolByteLength + 1 && javaBytes[0] != 0) {
                throw new CobolConversionException("Java binary too large for Cobol element", new HostData(hostTarget), offset, cobolByteLength);
            }
        } else if (javaBytes.length > cobolByteLength) {
            throw new CobolConversionException("Java binary too large for Cobol element", new HostData(hostTarget), offset, cobolByteLength);
        }
        int j = offset + cobolByteLength;
        for (int i = javaBytes.length; i > 0; --i) {
            if (j <= offset) continue;
            hostTarget[j - 1] = javaBytes[i - 1];
            --j;
        }
        while (j > offset) {
            hostTarget[j - 1] = javaInteger.signum() == -1 ? -1 : 0;
            --j;
        }
        return offset + cobolByteLength;
    }

    public static final BigDecimal fromHostSingle(int cobolByteLength, boolean isSigned, int totalDigits, int fractionDigits, byte[] hostSource, int offset) throws CobolConversionException {
        int j;
        byte[] javaBytes;
        if (isSigned) {
            javaBytes = new byte[cobolByteLength];
            j = cobolByteLength;
        } else {
            javaBytes = new byte[cobolByteLength + 1];
            j = cobolByteLength + 1;
        }
        for (int i = offset + cobolByteLength; i > offset; --i) {
            if (j > 0) {
                javaBytes[j - 1] = i > hostSource.length ? (byte)0 : hostSource[i - 1];
                --j;
                continue;
            }
            javaBytes[0] = 0;
        }
        BigInteger result = new BigInteger(javaBytes);
        BigDecimal bDecimal = new BigDecimal(result, fractionDigits);
        return bDecimal;
    }
}

