/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.config.commons;

import com.legstar.config.LegStarConfigurationException;
import com.legstar.config.PoolingEngineConfig;
import com.legstar.coxb.util.ClassLoadingException;
import com.legstar.coxb.util.ClassUtil;
import com.legstar.messaging.ConnectionFactory;
import com.legstar.messaging.HostEndpoint;
import com.legstar.messaging.LegStarAddress;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.DefaultConfigurationBuilder;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegStarConfigCommons {
    private HierarchicalConfiguration _generalConfig;
    public static final String HOST_ENDPOINT_KEY = "hostEndPoints/hostEndPoint";
    private static final String WORK_MANAGER_LOCATION_KEY = "engine/workManager/threadPool/JNDILocation";
    private static final String WORK_MANAGER_THREAD_POOL_SIZE_KEY = "engine/workManager/defaultThreadPool/size";
    private static final String POOLING_MAXIMUM_REQUESTS_KEY = "engine/maxRequests";
    private static final String TAKE_TIMEOUT_KEY = "engine/takeTimeout";
    private final Log _log = LogFactory.getLog(this.getClass());

    public LegStarConfigCommons(String generalConfigFileName) throws LegStarConfigurationException {
        this._generalConfig = this.loadGeneralConfig(generalConfigFileName);
    }

    public HostEndpoint getHostEndpoint(String endpointName) throws LegStarConfigurationException {
        String strXPath;
        List endpoints;
        if (this._log.isDebugEnabled()) {
            this._log.debug("Looking up endpoint: " + endpointName);
        }
        if ((endpoints = this._generalConfig.configurationsAt(strXPath = "hostEndPoints/hostEndPoint[@name='" + endpointName + "']")) == null || endpoints.isEmpty()) {
            throw new LegStarConfigurationException("The requested endpoint:" + endpointName + " is not defined.");
        }
        return this.getHostEndpoint((HierarchicalConfiguration)endpoints.get(0));
    }

    public HostEndpoint getHostEndpoint(LegStarAddress address) throws LegStarConfigurationException {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Searching for an endpoint matching address: " + address);
        }
        if (address == null || address.getEndPointName() == null || address.getEndPointName().length() == 0) {
            return this.getDefaultHostEndpoint();
        }
        return this.getHostEndpoint(address.getEndPointName());
    }

    public HostEndpoint getDefaultHostEndpoint() throws LegStarConfigurationException {
        String strXPath;
        List endpoints;
        if (this._log.isDebugEnabled()) {
            this._log.debug("Searching for default endpoint");
        }
        if ((endpoints = this._generalConfig.configurationsAt(strXPath = HOST_ENDPOINT_KEY)) == null || endpoints.isEmpty()) {
            throw new LegStarConfigurationException("There are no endpoints defined.");
        }
        return this.getHostEndpoint((HierarchicalConfiguration)endpoints.get(0));
    }

    public List<HostEndpoint> getHostEndpoints() throws LegStarConfigurationException {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Searching for all endpoints");
        }
        ArrayList<HostEndpoint> endpoints = new ArrayList<HostEndpoint>();
        String strXPath = HOST_ENDPOINT_KEY;
        List endpointConfigs = this._generalConfig.configurationsAt(strXPath);
        for (HierarchicalConfiguration endpointConfig : endpointConfigs) {
            endpoints.add(this.getHostEndpoint(endpointConfig));
        }
        return endpoints;
    }

    public PoolingEngineConfig getPoolingEngineConfig() throws LegStarConfigurationException {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Searching for pooling engine configuration");
        }
        PoolingEngineConfig poolingEngineConfig = new PoolingEngineConfig();
        poolingEngineConfig.setMaxRequests(this._generalConfig.getInt(POOLING_MAXIMUM_REQUESTS_KEY, 100000));
        poolingEngineConfig.setThreadPoolSize(this._generalConfig.getInt(WORK_MANAGER_THREAD_POOL_SIZE_KEY, 25));
        poolingEngineConfig.setWorkManagerJNDILocation(this._generalConfig.getString(WORK_MANAGER_LOCATION_KEY));
        poolingEngineConfig.setHostEndpoints(this.getHostEndpoints());
        poolingEngineConfig.setTakeTimeout(this._generalConfig.getInt(TAKE_TIMEOUT_KEY, 1000));
        return poolingEngineConfig;
    }

    protected HierarchicalConfiguration loadGeneralConfig(String configFileName) throws LegStarConfigurationException {
        try {
            HierarchicalConfiguration generalConfig;
            if (this._log.isDebugEnabled()) {
                this._log.debug("Loading configuration file: " + configFileName);
            }
            if ((generalConfig = new XMLConfiguration(configFileName)).configurationsAt("additional").size() > 0) {
                DefaultConfigurationBuilder dcb = new DefaultConfigurationBuilder();
                dcb.setFileName(configFileName);
                generalConfig = (HierarchicalConfiguration)dcb.getConfiguration(true).getConfiguration(DefaultConfigurationBuilder.ADDITIONAL_NAME);
            }
            generalConfig.setExpressionEngine(new XPathExpressionEngine());
            return generalConfig;
        }
        catch (ConfigurationException e) {
            throw new LegStarConfigurationException((Throwable)((Object)e));
        }
    }

    protected HostEndpoint getHostEndpoint(HierarchicalConfiguration endpointConfig) throws LegStarConfigurationException {
        ConnectionFactory connectionFactory = this.loadConnectionFactory(endpointConfig);
        HostEndpoint endpoint = connectionFactory.createEndpoint();
        this.setValues(endpoint, endpointConfig);
        return endpoint;
    }

    protected ConnectionFactory loadConnectionFactory(HierarchicalConfiguration endpointConfig) throws LegStarConfigurationException {
        String factoryClass = endpointConfig.getString("hostConnectionfactoryClass");
        if (factoryClass == null || factoryClass.length() == 0) {
            throw new LegStarConfigurationException("There are no connection factories in the configuration.");
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug("Loading connection factory class: " + factoryClass);
        }
        try {
            return (ConnectionFactory)ClassUtil.newObject(factoryClass);
        }
        catch (SecurityException e) {
            throw new LegStarConfigurationException(e);
        }
        catch (IllegalArgumentException e) {
            throw new LegStarConfigurationException(e);
        }
        catch (ClassLoadingException e) {
            throw new LegStarConfigurationException(e);
        }
    }

    protected void setValues(Object endpoint, HierarchicalConfiguration endpointConfig) throws LegStarConfigurationException {
        Iterator iterator = endpointConfig.getKeys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            this.setValue(endpoint, key, endpointConfig.getString(key));
        }
    }

    protected void setValue(Object o, String key, String value) throws LegStarConfigurationException {
        String setterName = LegStarConfigCommons.getSetterName(key);
        if (this._log.isDebugEnabled()) {
            this._log.debug("Using setter method: " + setterName + ", for value: " + value);
        }
        try {
            Method[] allMethods;
            for (Method method : allMethods = o.getClass().getMethods()) {
                if (!method.getName().equals(setterName)) continue;
                method.setAccessible(true);
                Class parm = (Class)method.getGenericParameterTypes()[0];
                if (parm.isAssignableFrom(String.class)) {
                    method.invoke(o, value);
                    break;
                }
                if (parm.isAssignableFrom(Boolean.TYPE)) {
                    method.invoke(o, Boolean.parseBoolean(value));
                    break;
                }
                if (parm.isAssignableFrom(Integer.TYPE)) {
                    method.invoke(o, Integer.parseInt(value));
                    break;
                }
                if (parm.isAssignableFrom(Long.TYPE)) {
                    method.invoke(o, Long.parseLong(value));
                    break;
                }
                if (parm.isAssignableFrom(HostEndpoint.AccessStrategy.class)) {
                    method.invoke(o, new Object[]{HostEndpoint.AccessStrategy.valueOf(value)});
                    break;
                }
                this._log.warn("Setter method: " + setterName + ", parameter type: " + parm + ", not compatible with value: " + value);
            }
        }
        catch (SecurityException e) {
            throw new LegStarConfigurationException(e);
        }
        catch (IllegalArgumentException e) {
            throw new LegStarConfigurationException(e);
        }
        catch (IllegalAccessException e) {
            throw new LegStarConfigurationException(e);
        }
        catch (InvocationTargetException e) {
            throw new LegStarConfigurationException(e);
        }
    }

    protected static String getSetterName(String key) {
        String setterName = key;
        if (setterName == null || setterName.length() == 0) {
            return null;
        }
        if (setterName.charAt(0) == '@') {
            setterName = setterName.substring(1);
        }
        String prefix = "set" + setterName.substring(0, 1).toUpperCase(Locale.getDefault());
        return prefix + setterName.substring(1);
    }
}

