/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.RemoveLinkedFolderDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;

public class RemoveFromBuildpathAction
extends Action
implements ISelectionChangedListener {
    private final IWorkbenchSite fSite;
    private List fSelectedElements;
    static /* synthetic */ Class class$0;

    public RemoveFromBuildpathAction(IWorkbenchSite site) {
        super(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_RemoveFromCP_label, JavaPluginImages.DESC_ELCL_REMOVE_FROM_BP);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_RemoveFromCP_tooltip);
        this.fSite = site;
        this.fSelectedElements = new ArrayList();
    }

    public void run() {
        try {
            IJavaProject project;
            Object object = this.fSelectedElements.get(0);
            if (object instanceof IJavaProject) {
                project = (IJavaProject)object;
            } else if (object instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)object;
                project = root.getJavaProject();
            } else {
                ClassPathContainer container = (ClassPathContainer)object;
                project = container.getJavaProject();
            }
            final ArrayList elementsToRemove = new ArrayList();
            final ArrayList foldersToDelete = new ArrayList();
            this.queryToRemoveLinkedFolders(elementsToRemove, foldersToDelete);
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_RemoveFromBuildpath, elementsToRemove.size() + foldersToDelete.size());
                            List result = RemoveFromBuildpathAction.this.removeFromClasspath(elementsToRemove, project, (IProgressMonitor)new SubProgressMonitor(monitor, elementsToRemove.size()));
                            result.removeAll(foldersToDelete);
                            RemoveFromBuildpathAction.this.deleteFolders(foldersToDelete, (IProgressMonitor)new SubProgressMonitor(monitor, foldersToDelete.size()));
                            if (result.size() == 0) {
                                result.add(project);
                            }
                            RemoveFromBuildpathAction.this.selectAndReveal((ISelection)new StructuredSelection(result));
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var3_5 = null;
                        monitor.done();
                        throw throwable;
                    }
                    {
                        Object var3_6 = null;
                    }
                    monitor.done();
                }
            };
            PlatformUI.getWorkbench().getProgressService().run(true, false, runnable);
        }
        catch (CoreException e) {
            this.showExceptionDialog(e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                this.showExceptionDialog((CoreException)e.getCause());
            } else {
                JavaPlugin.log(e);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteFolders(List folders, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_RemoveFromBuildpath, folders.size());
            Iterator iter = folders.iterator();
            while (iter.hasNext()) {
                IFolder folder = (IFolder)iter.next();
                folder.delete(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
    }

    private List removeFromClasspath(List elements, IJavaProject project, IProgressMonitor monitor) throws CoreException {
        ArrayList<IJavaProject> arrayList;
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_RemoveFromBuildpath, elements.size() + 1);
            List existingEntries = ClasspathModifier.getExistingEntries(project);
            ArrayList<IJavaProject> result = new ArrayList<IJavaProject>();
            int i = 0;
            while (i < elements.size()) {
                IJavaProject res;
                Object element = elements.get(i);
                if (element instanceof IJavaProject) {
                    res = ClasspathModifier.removeFromClasspath((IJavaProject)element, existingEntries, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    result.add(res);
                } else if (element instanceof IPackageFragmentRoot) {
                    res = ClasspathModifier.removeFromClasspath((IPackageFragmentRoot)element, existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (res != null) {
                        result.add(res);
                    }
                } else {
                    existingEntries.remove(CPListElement.createFromExisting(((ClassPathContainer)element).getClasspathEntry(), project));
                }
                ++i;
            }
            ClasspathModifier.commitClassPath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            arrayList = result;
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return arrayList;
    }

    private void queryToRemoveLinkedFolders(List elementsToRemove, List foldersToDelete) throws JavaModelException {
        Shell shell = this.fSite.getShell() != null ? this.fSite.getShell() : JavaPlugin.getActiveWorkbenchShell();
        Iterator iter = this.fSelectedElements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof IPackageFragmentRoot) {
                IFolder folder = this.getLinkedSourceFolder((IPackageFragmentRoot)element);
                if (folder != null) {
                    int result;
                    RemoveLinkedFolderDialog dialog = new RemoveLinkedFolderDialog(shell, folder);
                    int n = result = dialog.open() == 0 ? dialog.getRemoveStatus() : 0;
                    if (result == 0) continue;
                    if (result == 1) {
                        elementsToRemove.add(element);
                        continue;
                    }
                    if (result != 2) continue;
                    elementsToRemove.add(element);
                    foldersToDelete.add(folder);
                    continue;
                }
                elementsToRemove.add(element);
                continue;
            }
            elementsToRemove.add(element);
        }
    }

    private IFolder getLinkedSourceFolder(IPackageFragmentRoot root) throws JavaModelException {
        if (root.getKind() != 1) {
            return null;
        }
        IResource resource = root.getCorrespondingResource();
        if (!(resource instanceof IFolder)) {
            return null;
        }
        IFolder folder = (IFolder)resource;
        if (!folder.isLinked()) {
            return null;
        }
        return folder;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.setEnabled(this.canHandle((IStructuredSelection)selection));
        } else {
            this.setEnabled(this.canHandle((IStructuredSelection)StructuredSelection.EMPTY));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canHandle(IStructuredSelection elements) {
        if (elements.size() == 0) {
            return false;
        }
        try {
            IClasspathEntry entry;
            IJavaProject project;
            Object element;
            this.fSelectedElements.clear();
            Iterator iter = elements.iterator();
            do {
                if (!iter.hasNext()) {
                    return true;
                }
                element = iter.next();
                this.fSelectedElements.add(element);
                if (element instanceof IPackageFragmentRoot || element instanceof IJavaProject || element instanceof ClassPathContainer) continue;
                return false;
            } while (!(element instanceof IJavaProject ? !ClasspathModifier.isSourceFolder(project = (IJavaProject)element) : element instanceof IPackageFragmentRoot && (entry = ((IPackageFragmentRoot)element).getRawClasspathEntry()) != null && entry.getEntryKind() == 5));
            return false;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private void showExceptionDialog(CoreException exception) {
        this.showError(exception, this.fSite.getShell(), NewWizardMessages.RemoveFromBuildpathAction_ErrorTitle, exception.getMessage());
    }

    private void showError(CoreException e, Shell shell, String title, String message) {
        IStatus status = e.getStatus();
        if (status != null) {
            ErrorDialog.openError((Shell)shell, (String)message, (String)title, (IStatus)status);
        } else {
            MessageDialog.openError((Shell)shell, (String)title, (String)message);
        }
    }

    private void selectAndReveal(final ISelection selection) {
        IWorkbenchPart part;
        IWorkbenchPage page = this.fSite.getPage();
        if (page == null) {
            return;
        }
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            part = refs[i].getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++i;
        }
        refs = page.getEditorReferences();
        i = 0;
        while (i < refs.length) {
            if (refs[i].getPart(false) != null) {
                parts.add(refs[i].getPart(false));
            }
            ++i;
        }
        Iterator itr = parts.iterator();
        while (itr.hasNext()) {
            part = (IWorkbenchPart)itr.next();
            ISetSelectionTarget target = null;
            if (part instanceof ISetSelectionTarget) {
                target = (ISetSelectionTarget)part;
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ui.part.ISetSelectionTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                target = (ISetSelectionTarget)part.getAdapter((Class)clazz);
            }
            if (target == null) continue;
            final ISetSelectionTarget finalTarget = target;
            page.getWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    finalTarget.selectReveal(selection);
                }
            });
        }
    }
}

