/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.link.ProposalPosition;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class LinkedCorrectionProposal
extends ASTRewriteCorrectionProposal {
    private ITrackedNodePosition fSelectionDescription = null;
    private Map fLinkGroups = null;
    private List fPositionOrder;

    public LinkedCorrectionProposal(String name, ICompilationUnit cu, ASTRewrite rewrite, int relevance, Image image) {
        super(name, cu, rewrite, relevance, image);
    }

    public void addLinkedPosition(ITrackedNodePosition position, boolean isFirst, String groupID) {
        this.getLinkedModeGroup((String)groupID).fPositions.add(position);
        if (this.fPositionOrder == null) {
            this.fPositionOrder = new ArrayList();
        }
        if (isFirst) {
            this.fPositionOrder.add(0, position);
        } else {
            this.fPositionOrder.add(position);
        }
    }

    public void setEndPosition(ITrackedNodePosition position) {
        this.fSelectionDescription = position;
    }

    public void addLinkedPositionProposal(String groupID, String proposal, Image image) {
        this.addLinkedPositionProposal(groupID, new LinkedModeProposal(proposal, proposal));
    }

    public void addLinkedPositionProposal(String groupID, String displayString, String proposal, Image image) {
        this.addLinkedPositionProposal(groupID, new LinkedModeProposal(displayString, proposal));
    }

    public void addLinkedPositionProposal(String groupID, ITypeBinding proposal) {
        this.addLinkedPositionProposal(groupID, new LinkedModeProposal(this.getCompilationUnit(), proposal));
    }

    public void addLinkedPositionProposal(String groupID, IJavaCompletionProposal proposal) {
        this.getLinkedModeGroup((String)groupID).fProposals.add(proposal);
    }

    public LinkedModeGroup[] getLinkedModeGroups() {
        if (this.fLinkGroups == null) {
            return new LinkedModeGroup[0];
        }
        Collection values = this.fLinkGroups.values();
        return values.toArray(new LinkedModeGroup[values.size()]);
    }

    private LinkedModeGroup getLinkedModeGroup(String name) {
        LinkedModeGroup linkedGroup;
        if (this.fLinkGroups == null) {
            this.fLinkGroups = new HashMap();
        }
        if ((linkedGroup = (LinkedModeGroup)this.fLinkGroups.get(name)) == null) {
            linkedGroup = new LinkedModeGroup();
            this.fLinkGroups.put(name, linkedGroup);
        }
        return linkedGroup;
    }

    protected void performChange(IEditorPart part, IDocument document) throws CoreException {
        try {
            super.performChange(part, document);
            if (part == null) {
                return;
            }
            if (this.fLinkGroups != null && !this.fLinkGroups.isEmpty() && part instanceof JavaEditor) {
                ISourceViewer viewer = ((JavaEditor)part).getViewer();
                this.enterLinkedMode((ITextViewer)viewer);
            } else if (this.fSelectionDescription != null && part instanceof ITextEditor) {
                int pos = this.fSelectionDescription.getStartPosition() + this.fSelectionDescription.getLength();
                ((ITextEditor)part).selectAndReveal(pos, 0);
            }
        }
        catch (BadLocationException e) {
            throw new CoreException(JavaUIStatus.createError(4, e));
        }
    }

    private void enterLinkedMode(ITextViewer viewer) throws BadLocationException {
        IDocument document = viewer.getDocument();
        LinkedModeModel model = new LinkedModeModel();
        boolean added = false;
        Iterator iterator = this.fLinkGroups.values().iterator();
        while (iterator.hasNext()) {
            ITrackedNodePosition pos;
            int i;
            LinkedModeGroup curr = (LinkedModeGroup)iterator.next();
            LinkedPositionGroup group = new LinkedPositionGroup();
            List positions = curr.fPositions;
            if (positions.isEmpty()) continue;
            ICompletionProposal[] linkedModeProposals = curr.getProposals();
            if (linkedModeProposals.length <= 1) {
                i = 0;
                while (i < positions.size()) {
                    pos = (ITrackedNodePosition)positions.get(i);
                    if (pos.getStartPosition() != -1) {
                        group.addPosition(new LinkedPosition(document, pos.getStartPosition(), pos.getLength(), this.fPositionOrder.indexOf(pos)));
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < positions.size()) {
                    pos = (ITrackedNodePosition)positions.get(i);
                    if (pos.getStartPosition() != -1) {
                        group.addPosition((LinkedPosition)new ProposalPosition(document, pos.getStartPosition(), pos.getLength(), this.fPositionOrder.indexOf(pos), linkedModeProposals));
                    }
                    ++i;
                }
                i = 0;
                while (i < linkedModeProposals.length) {
                    if (linkedModeProposals[i] instanceof ILinkedModeProposal) {
                        ((ILinkedModeProposal)linkedModeProposals[i]).setLinkedPositionGroup(group);
                    }
                    ++i;
                }
            }
            model.addGroup(group);
            added = true;
        }
        model.forceInstall();
        JavaEditor editor = this.getJavaEditor();
        if (editor != null) {
            model.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(editor));
        }
        if (added) {
            EditorLinkedModeUI ui = new EditorLinkedModeUI(model, viewer);
            if (this.fSelectionDescription != null && this.fSelectionDescription.getStartPosition() != -1) {
                ui.setExitPosition(viewer, this.fSelectionDescription.getStartPosition() + this.fSelectionDescription.getLength(), 0, Integer.MAX_VALUE);
            } else {
                int cursorPosition = viewer.getSelectedRange().x;
                if (cursorPosition != 0) {
                    ui.setExitPosition(viewer, cursorPosition, 0, Integer.MAX_VALUE);
                }
            }
            ui.setExitPolicy((LinkedModeUI.IExitPolicy)new LinkedModeExitPolicy());
            ui.enter();
            IRegion region = ui.getSelectedRegion();
            viewer.setSelectedRange(region.getOffset(), region.getLength());
            viewer.revealRange(region.getOffset(), region.getLength());
        }
    }

    private JavaEditor getJavaEditor() {
        IEditorPart part = JavaPlugin.getActivePage().getActiveEditor();
        if (part instanceof JavaEditor) {
            return (JavaEditor)part;
        }
        return null;
    }

    public static interface ILinkedModeProposal
    extends IJavaCompletionProposal {
        public void setLinkedPositionGroup(LinkedPositionGroup var1);
    }

    private static class LinkedModeExitPolicy
    implements LinkedModeUI.IExitPolicy {
        private LinkedModeExitPolicy() {
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            if (event.character == '=') {
                return new LinkedModeUI.ExitFlags(1, true);
            }
            return null;
        }
    }

    public static class LinkedModeGroup {
        final List fPositions = new ArrayList();
        final List fProposals = new ArrayList();

        public ITrackedNodePosition[] getPositions() {
            return this.fPositions.toArray(new ITrackedNodePosition[this.fPositions.size()]);
        }

        public IJavaCompletionProposal[] getProposals() {
            return this.fProposals.toArray(new IJavaCompletionProposal[this.fProposals.size()]);
        }
    }

    private static class LinkedModeProposal
    implements ILinkedModeProposal,
    ICompletionProposalExtension2 {
        private String fProposal;
        private String fDisplayString;
        private ITypeBinding fTypeProposal;
        private ICompilationUnit fCompilationUnit;
        private LinkedPositionGroup fLinkedPositionGroup;

        public LinkedModeProposal(String displayString, String proposal) {
            this.fProposal = proposal;
            this.fDisplayString = displayString;
            this.fLinkedPositionGroup = null;
        }

        public LinkedModeProposal(ICompilationUnit unit, ITypeBinding typeProposal) {
            this(typeProposal.getName(), typeProposal.getName());
            this.fTypeProposal = typeProposal;
            this.fCompilationUnit = unit;
        }

        public void setLinkedPositionGroup(LinkedPositionGroup group) {
            this.fLinkedPositionGroup = group;
        }

        public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
            IDocument document = viewer.getDocument();
            try {
                String replaceString = this.fProposal;
                ImportRewrite impRewrite = null;
                if (this.fTypeProposal != null) {
                    impRewrite = StubUtility.createImportRewrite(this.fCompilationUnit, true);
                    replaceString = impRewrite.addImport(this.fTypeProposal);
                }
                IRegion region = this.getReplaceRegion(viewer, offset);
                document.replace(region.getOffset(), region.getLength(), replaceString);
                if (impRewrite != null) {
                    JavaModelUtil.applyEdit(this.fCompilationUnit, impRewrite.rewriteImports(null), false, null);
                }
            }
            catch (BadLocationException e) {
                JavaPlugin.log(e);
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }

        private Position getCurrentPosition(int offset) {
            if (this.fLinkedPositionGroup != null) {
                LinkedPosition[] positions = this.fLinkedPositionGroup.getPositions();
                int i = 0;
                while (i < positions.length) {
                    LinkedPosition position = positions[i];
                    if (position.overlapsWith(offset, 0)) {
                        return position;
                    }
                    ++i;
                }
            }
            return null;
        }

        private IRegion getReplaceRegion(ITextViewer viewer, int offset) {
            Position pos = this.getCurrentPosition(offset);
            if (pos != null) {
                return new Region(pos.getOffset(), pos.getLength());
            }
            Point point = viewer.getSelectedRange();
            return new Region(point.x, point.y);
        }

        public String getDisplayString() {
            if (this.fTypeProposal != null) {
                return BindingLabelProvider.getBindingLabel((IBinding)this.fTypeProposal, JavaElementLabels.ALL_DEFAULT | JavaElementLabels.ALL_POST_QUALIFIED);
            }
            return this.fDisplayString;
        }

        public Image getImage() {
            ImageDescriptor desc;
            if (this.fTypeProposal != null && (desc = BindingLabelProvider.getBindingImageDescriptor((IBinding)this.fTypeProposal, 1)) != null) {
                return JavaPlugin.getImageDescriptorRegistry().get(desc);
            }
            return null;
        }

        public int getRelevance() {
            return 0;
        }

        public void apply(IDocument document) {
        }

        public Point getSelection(IDocument document) {
            return null;
        }

        public String getAdditionalProposalInfo() {
            return null;
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public void selected(ITextViewer viewer, boolean smartToggle) {
        }

        public void unselected(ITextViewer viewer) {
        }

        public boolean validate(IDocument document, int offset, DocumentEvent event) {
            String insert = this.getDisplayString();
            if (insert == null) {
                return false;
            }
            Position pos = this.getCurrentPosition(offset);
            int off = pos != null ? pos.getOffset() : Math.max(0, offset - insert.length());
            int length = offset - off;
            if (offset <= document.getLength()) {
                try {
                    String content = document.get(off, length);
                    if (insert.startsWith(content)) {
                        return true;
                    }
                }
                catch (BadLocationException e) {
                    JavaPlugin.log(e);
                }
            }
            return false;
        }
    }
}

