/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.packageview;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class PackageFragmentProvider
implements IPropertyChangeListener {
    private TreeViewer fViewer;
    private boolean fFoldPackages = this.arePackagesFoldedInHierarchicalLayout();

    public PackageFragmentProvider() {
        JavaPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public Object[] getChildren(Object parentElement) {
        block11: {
            try {
                if (parentElement instanceof IFolder) {
                    IResource[] resources = ((IFolder)parentElement).members();
                    return this.filter(this.getFolders(resources)).toArray();
                }
                if (!(parentElement instanceof IJavaElement)) break block11;
                IJavaElement iJavaElement = (IJavaElement)parentElement;
                int type = iJavaElement.getElementType();
                switch (type) {
                    case 2: {
                        IJavaProject project = (IJavaProject)iJavaElement;
                        IPackageFragmentRoot root = project.findPackageFragmentRoot(project.getPath());
                        if (root != null) {
                            List children = PackageFragmentProvider.getTopLevelChildren(root);
                            return this.filter(children).toArray();
                        }
                        break;
                    }
                    case 3: {
                        IPackageFragmentRoot root = (IPackageFragmentRoot)parentElement;
                        if (root.exists()) {
                            return this.filter(PackageFragmentProvider.getTopLevelChildren(root)).toArray();
                        }
                        break;
                    }
                    case 4: {
                        IPackageFragment packageFragment = (IPackageFragment)parentElement;
                        if (!packageFragment.isDefaultPackage()) {
                            IPackageFragmentRoot root = (IPackageFragmentRoot)packageFragment.getParent();
                            List children = PackageFragmentProvider.getPackageChildren(root, packageFragment);
                            return this.filter(children).toArray();
                        }
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
        return new Object[0];
    }

    private List filter(List children) throws JavaModelException {
        if (this.fFoldPackages) {
            int size = children.size();
            int i = 0;
            while (i < size) {
                IPackageFragment collapsed;
                IPackageFragment fragment;
                Object curr = children.get(i);
                if (curr instanceof IPackageFragment && !(fragment = (IPackageFragment)curr).isDefaultPackage() && this.isEmpty(fragment) && (collapsed = this.getCollapsed(fragment)) != null) {
                    children.set(i, collapsed);
                }
                ++i;
            }
        }
        return children;
    }

    private IPackageFragment getCollapsed(IPackageFragment pack) throws JavaModelException {
        IJavaElement[] children = ((IPackageFragmentRoot)pack.getParent()).getChildren();
        IPackageFragment child = PackageFragmentProvider.getSinglePackageChild(pack, children);
        while (child != null && this.isEmpty(child)) {
            IPackageFragment collapsed = PackageFragmentProvider.getSinglePackageChild(child, children);
            if (collapsed == null) {
                return child;
            }
            child = collapsed;
        }
        return child;
    }

    private boolean isEmpty(IPackageFragment fragment) throws JavaModelException {
        return !fragment.containsJavaResources() && fragment.getNonJavaResources().length == 0;
    }

    private static IPackageFragment getSinglePackageChild(IPackageFragment fragment, IJavaElement[] children) {
        String prefix = String.valueOf(fragment.getElementName()) + '.';
        int prefixLen = prefix.length();
        IPackageFragment found = null;
        int i = 0;
        while (i < children.length) {
            IJavaElement element = children[i];
            String name = element.getElementName();
            if (name.startsWith(prefix) && name.length() > prefixLen && name.indexOf(46, prefixLen) == -1) {
                if (found == null) {
                    found = (IPackageFragment)element;
                } else {
                    return null;
                }
            }
            ++i;
        }
        return found;
    }

    private static List getPackageChildren(IPackageFragmentRoot parent, IPackageFragment fragment) throws JavaModelException {
        IJavaElement[] children = parent.getChildren();
        ArrayList<IJavaElement> list = new ArrayList<IJavaElement>(children.length);
        String prefix = String.valueOf(fragment.getElementName()) + '.';
        int prefixLen = prefix.length();
        int i = 0;
        while (i < children.length) {
            String name;
            IJavaElement element = children[i];
            if (element instanceof IPackageFragment && (name = element.getElementName()).startsWith(prefix) && name.length() > prefixLen && name.indexOf(46, prefixLen) == -1) {
                list.add(element);
            }
            ++i;
        }
        return list;
    }

    private static List getTopLevelChildren(IPackageFragmentRoot root) throws JavaModelException {
        IJavaElement[] elements = root.getChildren();
        ArrayList<IJavaElement> topLevelElements = new ArrayList<IJavaElement>(elements.length);
        int i = 0;
        while (i < elements.length) {
            IJavaElement iJavaElement = elements[i];
            if (iJavaElement instanceof IPackageFragment && iJavaElement.getElementName().indexOf(46) == -1) {
                topLevelElements.add(iJavaElement);
            }
            ++i;
        }
        return topLevelElements;
    }

    private List getFolders(IResource[] resources) throws JavaModelException {
        ArrayList<IJavaElement> list = new ArrayList<IJavaElement>(resources.length);
        int i = 0;
        while (i < resources.length) {
            IFolder folder;
            IJavaElement element;
            IResource resource = resources[i];
            if (resource instanceof IFolder && (element = JavaCore.create((IFolder)(folder = (IFolder)resource))) instanceof IPackageFragment) {
                list.add(element);
            }
            ++i;
        }
        return list;
    }

    public Object getParent(Object element) {
        if (element instanceof IPackageFragment) {
            IPackageFragment frag = (IPackageFragment)element;
            return this.filterParent(this.getActualParent(frag));
        }
        return null;
    }

    private Object getActualParent(IPackageFragment fragment) {
        try {
            IJavaElement parent;
            if (fragment.exists() && (parent = fragment.getParent()) instanceof IPackageFragmentRoot && parent.exists()) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)parent;
                if (root.isArchive()) {
                    return this.findNextLevelParentByElementName(fragment);
                }
                IResource resource = fragment.getUnderlyingResource();
                if (resource != null && resource instanceof IFolder) {
                    IFolder folder = (IFolder)resource;
                    IContainer res = folder.getParent();
                    IJavaElement el = JavaCore.create((IResource)res);
                    if (el != null) {
                        return el;
                    }
                    return res;
                }
                return parent;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return null;
    }

    private Object filterParent(Object parent) {
        if (this.fFoldPackages && parent != null) {
            try {
                IPackageFragment fragment;
                if (parent instanceof IPackageFragment && this.isEmpty(fragment = (IPackageFragment)parent) && this.hasSingleChild(fragment)) {
                    return this.filterParent(this.getActualParent(fragment));
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
        }
        return parent;
    }

    private boolean hasSingleChild(IPackageFragment fragment) {
        return this.getChildren(fragment).length == 1;
    }

    private Object findNextLevelParentByElementName(IPackageFragment child) {
        String name = child.getElementName();
        int index = name.lastIndexOf(46);
        if (index != -1) {
            String realParentName = name.substring(0, index);
            IPackageFragment element = ((IPackageFragmentRoot)child.getParent()).getPackageFragment(realParentName);
            if (element.exists()) {
                return element;
            }
        }
        return child.getParent();
    }

    public boolean hasChildren(Object element) {
        IPackageFragment fragment;
        if (element instanceof IPackageFragment && (fragment = (IPackageFragment)element).isDefaultPackage()) {
            return false;
        }
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        JavaPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = (TreeViewer)viewer;
    }

    public void elementChanged(ElementChangedEvent event) {
        this.processDelta(event.getDelta());
    }

    public void processDelta(IJavaElementDelta delta) {
        int kind = delta.getKind();
        final IJavaElement element = delta.getElement();
        if (element instanceof IPackageFragment) {
            if (kind == 2) {
                this.postRunnable(new Runnable(){

                    public void run() {
                        Control ctrl = PackageFragmentProvider.this.fViewer.getControl();
                        if (ctrl != null && !ctrl.isDisposed()) {
                            if (!PackageFragmentProvider.this.fFoldPackages) {
                                PackageFragmentProvider.this.fViewer.remove((Object)element);
                            } else {
                                PackageFragmentProvider.this.refreshGrandParent(element);
                            }
                        }
                    }
                });
                return;
            }
            if (kind == 1) {
                final Object parent = this.getParent(element);
                if (parent != null) {
                    this.postRunnable(new Runnable(){

                        public void run() {
                            Control ctrl = PackageFragmentProvider.this.fViewer.getControl();
                            if (ctrl != null && !ctrl.isDisposed()) {
                                if (!PackageFragmentProvider.this.fFoldPackages) {
                                    PackageFragmentProvider.this.fViewer.add(parent, (Object)element);
                                } else {
                                    PackageFragmentProvider.this.refreshGrandParent(element);
                                }
                            }
                        }
                    });
                }
                return;
            }
        }
    }

    private void refreshGrandParent(IJavaElement element) {
        if (element instanceof IPackageFragment) {
            IFolder folder;
            Object gp = this.getGrandParent((IPackageFragment)element);
            if (gp instanceof IJavaElement) {
                IJavaElement el = (IJavaElement)gp;
                if (el.exists()) {
                    this.fViewer.refresh(gp);
                }
            } else if (gp instanceof IFolder && (folder = (IFolder)gp).exists()) {
                this.fViewer.refresh((Object)folder);
            }
        }
    }

    private Object getGrandParent(IPackageFragment element) {
        Object parent = this.findNextLevelParentByElementName(element);
        if (parent instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)parent;
            if (this.isRootProject(root)) {
                return root.getJavaProject();
            }
            return root;
        }
        Object grandParent = this.getParent(parent);
        if (grandParent == null) {
            return parent;
        }
        return grandParent;
    }

    private boolean isRootProject(IPackageFragmentRoot root) {
        return "".equals(root.getElementName());
    }

    private void postRunnable(Runnable r) {
        Control ctrl = this.fViewer.getControl();
        if (ctrl != null && !ctrl.isDisposed()) {
            Display currentDisplay = Display.getCurrent();
            if (currentDisplay != null && currentDisplay.equals(ctrl.getDisplay())) {
                ctrl.getDisplay().syncExec(r);
            } else {
                ctrl.getDisplay().asyncExec(r);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.arePackagesFoldedInHierarchicalLayout() != this.fFoldPackages) {
            this.fFoldPackages = this.arePackagesFoldedInHierarchicalLayout();
            if (this.fViewer != null && !this.fViewer.getControl().isDisposed()) {
                this.fViewer.getControl().setRedraw(false);
                Object[] expandedObjects = this.fViewer.getExpandedElements();
                this.fViewer.refresh();
                this.fViewer.setExpandedElements(expandedObjects);
                this.fViewer.getControl().setRedraw(true);
            }
        }
    }

    private boolean arePackagesFoldedInHierarchicalLayout() {
        return PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.flatPackagesInPackageExplorer");
    }
}

