/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ActionUtil {
    private ActionUtil() {
    }

    public static boolean mustDisableJavaModelAction(Shell shell, Object element) {
        if (!(element instanceof IPackageFragment) && !(element instanceof IPackageFragmentRoot)) {
            return false;
        }
        IResource resource = ResourceUtil.getResource(element);
        if (resource == null || !(resource instanceof IFolder) || !resource.isLinked()) {
            return false;
        }
        MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_not_possible, (String)ActionMessages.ActionUtil_no_linked);
        return true;
    }

    public static boolean isProcessable(Shell shell, JavaEditor editor) {
        if (editor == null) {
            return true;
        }
        IJavaElement input = SelectionConverter.getInput(editor);
        if (input == null) {
            MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_notOnBuildPath_title, (String)ActionMessages.ActionUtil_notOnBuildPath_message);
            return false;
        }
        return ActionUtil.isProcessable(shell, input);
    }

    public static boolean isProcessable(Shell shell, Object element) {
        if (!(element instanceof IJavaElement)) {
            return true;
        }
        if (ActionUtil.isOnBuildPath((IJavaElement)element)) {
            return true;
        }
        MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_notOnBuildPath_title, (String)ActionMessages.ActionUtil_notOnBuildPath_message);
        return false;
    }

    public static boolean isOnBuildPath(IJavaElement element) {
        IProject resourceProject;
        block8: {
            IJavaProject project;
            block7: {
                if (element.getElementType() == 2) {
                    return true;
                }
                project = element.getJavaProject();
                try {
                    if (project.isOnClasspath(element)) break block7;
                    return false;
                }
                catch (CoreException coreException) {}
            }
            resourceProject = project.getProject();
            if (resourceProject != null) break block8;
            return false;
        }
        IProjectNature nature = resourceProject.getNature("org.eclipse.jdt.core.javanature");
        if (nature != null) {
            return true;
        }
        return false;
    }

    public static boolean areProcessable(Shell shell, IJavaElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            if (!ActionUtil.isOnBuildPath(elements[i])) {
                MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_notOnBuildPath_title, (String)Messages.format(ActionMessages.ActionUtil_notOnBuildPath_resource_message, new Object[]{elements[i].getPath()}));
                return false;
            }
            ++i;
        }
        return true;
    }
}

