/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.eclipse.plugin.jaxwsgen.wizards;

import com.legstar.eclipse.plugin.cixscom.wizards.AbstractCixsActivator;
import com.legstar.eclipse.plugin.cixscom.wizards.AbstractCixsGeneratorWizardPage;
import com.legstar.eclipse.plugin.jaxwsgen.Activator;
import com.legstar.eclipse.plugin.jaxwsgen.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class Jaxws2CixsGeneratorWizardPage
extends AbstractCixsGeneratorWizardPage {
    private static final String PAGE_NAME = "Jaxws2CixsGeneratorWizardPage";
    private Text mTargetWDDDirText = null;
    private Text mTargetWarDirText = null;
    private Text mWsdlTargetNamespaceText = null;
    private Text mWsdlServiceNameText = null;
    private Text mWsdlPortNameText = null;

    protected Jaxws2CixsGeneratorWizardPage(IStructuredSelection selection, IFile mappingFile) {
        super(selection, PAGE_NAME, Messages.jaxws_to_cixs_wizard_page_title, Messages.jaxws_to_cixs_wizard_page_description, mappingFile);
    }

    public void addWidgetsToCixsGroup(Composite container) {
    }

    public void addWidgetsToTargetGroup(Composite container) {
        this.mTargetWDDDirText = this.createDirectoryFieldEditor(container, "targetWDDDir", Messages.wdd_target_location_label + ':');
    }

    public void addWidgetsToCoxbGroup(Composite container) {
    }

    public void addWidgetsToDeploymentGroup(Composite container) {
        this.mTargetWarDirText = Jaxws2CixsGeneratorWizardPage.createTextField((Composite)container, (IPreferenceStore)this.getStore(), (String)"com.legstar.eclipse.plugin.jaxwsgen.DefaultTargetWarDir", (String)(Messages.war_deployment_location_label + ':'));
        this.mWsdlTargetNamespaceText = Jaxws2CixsGeneratorWizardPage.createTextField((Composite)container, (IPreferenceStore)this.getStore(), null, (String)(Messages.adapter_wsdl_target_namespace_label + ':'));
        this.mWsdlServiceNameText = Jaxws2CixsGeneratorWizardPage.createTextField((Composite)container, (IPreferenceStore)this.getStore(), null, (String)(Messages.adapter_wsdl_service_name_label + ':'));
        this.mWsdlPortNameText = Jaxws2CixsGeneratorWizardPage.createTextField((Composite)container, (IPreferenceStore)this.getStore(), null, (String)(Messages.adapter_wsdl_port_name_label + ':'));
    }

    public void createExtendedListeners() {
        this.mTargetWDDDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Jaxws2CixsGeneratorWizardPage.this.dialogChanged();
            }
        });
        this.mTargetWarDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Jaxws2CixsGeneratorWizardPage.this.dialogChanged();
            }
        });
        this.mWsdlTargetNamespaceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Jaxws2CixsGeneratorWizardPage.this.dialogChanged();
            }
        });
        this.mWsdlServiceNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Jaxws2CixsGeneratorWizardPage.this.dialogChanged();
            }
        });
        this.mWsdlPortNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Jaxws2CixsGeneratorWizardPage.this.dialogChanged();
            }
        });
    }

    public void initExtendedWidgets(IProject project) {
        this.setTargetWDDDir(this.getDefaultTargetDir(this.getStore(), "com.legstar.eclipse.plugin.jaxwsgen.DefaultJ2eeWDDFolder"));
        this.setDefaultWsdlTargetNamespace(this.getServiceName());
        this.setDefaultWsdlServiceName(this.getServiceName());
        this.setDefaultWsdlPortName(this.getServiceName());
    }

    private void setDefaultWsdlTargetNamespace(String serviceName) {
        String prefix = this.getStore().getString("com.legstar.eclipse.plugin.jaxwsgen.adapter.wsdlTargetNamespacePrefix");
        String name = prefix == null || prefix.length() == 0 ? serviceName : prefix + '/' + serviceName;
        this.setWsdlTargetNamespace(this.getProjectPreferences().get("com.legstar.eclipse.plugin.jaxwsgen.adapter.LastWsdlTargetNamespace", name));
    }

    private void setDefaultWsdlServiceName(String serviceName) {
        String suffix = this.getStore().getString("com.legstar.eclipse.plugin.jaxwsgen.adapter.wsdlServiceNameSuffix");
        String name = suffix == null || suffix.length() == 0 ? serviceName : serviceName + suffix;
        this.setWsdlServiceName(this.getProjectPreferences().get("com.legstar.eclipse.plugin.jaxwsgen.adapter.LastWsdlServiceName", name));
    }

    private void setDefaultWsdlPortName(String serviceName) {
        String suffix = this.getStore().getString("com.legstar.eclipse.plugin.jaxwsgen.adapter.wsdlPortNameSuffix");
        String name = suffix == null || suffix.length() == 0 ? serviceName : serviceName + suffix;
        this.setWsdlPortName(this.getProjectPreferences().get("com.legstar.eclipse.plugin.jaxwsgen.adapter.LastWsdlPortName", name));
    }

    public boolean validateExtendedWidgets() {
        if (!this.checkDirectory(this.getTargetWDDDir(), Messages.invalid_wdd_target_location_msg)) {
            return false;
        }
        if (this.getWsdlTargetNamespace().length() == 0) {
            this.updateStatus(Messages.invalid_wsdl_target_namespace_msg);
            return false;
        }
        if (this.getWsdlServiceName().length() == 0) {
            this.updateStatus(Messages.invalid_wsdl_service_name_msg);
            return false;
        }
        if (this.getWsdlPortName().length() == 0) {
            this.updateStatus(Messages.invalid_wsdl_port_name_msg);
            return false;
        }
        return true;
    }

    public void storeExtendedProjectPreferences() {
        this.getProjectPreferences().put("com.legstar.eclipse.plugin.jaxwsgen.adapter.LastWsdlTargetNamespace", this.getWsdlTargetNamespace());
        this.getProjectPreferences().put("com.legstar.eclipse.plugin.jaxwsgen.adapter.LastWsdlServiceName", this.getWsdlServiceName());
        this.getProjectPreferences().put("com.legstar.eclipse.plugin.jaxwsgen.adapter.LastWsdlPortName", this.getWsdlPortName());
    }

    public void setTargetWarDir(String targetWarDir) {
        this.mTargetWarDirText.setText(targetWarDir);
    }

    public String getTargetWarDir() {
        return this.mTargetWarDirText.getText();
    }

    public void setTargetWDDDir(String targetWDDDir) {
        this.mTargetWDDDirText.setText(targetWDDDir);
    }

    public String getTargetWDDDir() {
        return this.mTargetWDDDirText.getText();
    }

    public void setWsdlTargetNamespace(String wsdlTargetNamespace) {
        this.mWsdlTargetNamespaceText.setText(wsdlTargetNamespace);
    }

    public String getWsdlTargetNamespace() {
        return this.mWsdlTargetNamespaceText.getText();
    }

    public void setWsdlServiceName(String wsdlServiceName) {
        this.mWsdlServiceNameText.setText(wsdlServiceName);
    }

    public String getWsdlServiceName() {
        return this.mWsdlServiceNameText.getText();
    }

    public void setWsdlPortName(String wsdlPortName) {
        this.mWsdlPortNameText.setText(wsdlPortName);
    }

    public String getWsdlPortName() {
        return this.mWsdlPortNameText.getText();
    }

    public AbstractCixsActivator getActivator() {
        return Activator.getDefault();
    }
}

