/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.eclipse.plugin.jaxwsgen.wizards;

import com.legstar.cixs.gen.model.options.ProxyTargetType;
import com.legstar.eclipse.plugin.cixscom.wizards.AbstractCixsActivator;
import com.legstar.eclipse.plugin.cixscom.wizards.AbstractCixsGeneratorWizardPage;
import com.legstar.eclipse.plugin.cixscom.wizards.CixsProxyPojoTargetGroup;
import com.legstar.eclipse.plugin.cixscom.wizards.CixsProxyWebServiceTargetGroup;
import com.legstar.eclipse.plugin.jaxwsgen.Activator;
import com.legstar.eclipse.plugin.jaxwsgen.Messages;
import com.legstar.eclipse.plugin.jaxwsgen.wizards.Cixs2JaxwsProxyDeployHttpGroup;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class Cixs2JaxwsGeneratorWizardPage
extends AbstractCixsGeneratorWizardPage {
    private static final String PAGE_NAME = "Cixs2JaxwsGeneratorWizardPage";
    private Group mTargetGroup = null;
    private Composite mDeploymentGroup = null;
    private CixsProxyPojoTargetGroup mPojoTargetGroup;
    private CixsProxyWebServiceTargetGroup mWebServiceTargetGroup;
    private Text mTargetCobolDirText = null;
    private Text mTargetWDDDirText = null;
    private Text mTargetWarDirText = null;
    private Cixs2JaxwsProxyDeployHttpGroup mCixsProxyDeployHttpGroup;

    protected Cixs2JaxwsGeneratorWizardPage(IStructuredSelection selection, IFile mappingFile) {
        super(selection, PAGE_NAME, Messages.cixs_to_jaxws_wizard_page_title, Messages.cixs_to_jaxws_wizard_page_description, mappingFile);
    }

    protected void addCixsGroup(Composite container) {
        this.mTargetGroup = Cixs2JaxwsGeneratorWizardPage.createGroup((Composite)container, (String)Messages.target_selection_group_label, (int)3);
        Cixs2JaxwsGeneratorWizardPage.createLabel((Composite)this.mTargetGroup, (String)(Messages.target_selection_label + ':'));
        Composite composite = new Composite((Composite)this.mTargetGroup, 0);
        composite.setLayout((Layout)new RowLayout());
        this.mWebServiceTargetGroup = new CixsProxyWebServiceTargetGroup((AbstractCixsGeneratorWizardPage)this);
        this.mPojoTargetGroup = new CixsProxyPojoTargetGroup((AbstractCixsGeneratorWizardPage)this);
        this.mWebServiceTargetGroup.createButton(composite);
        this.mPojoTargetGroup.createButton(composite);
        this.mWebServiceTargetGroup.createControls((Composite)this.mTargetGroup);
        this.mPojoTargetGroup.createControls((Composite)this.mTargetGroup);
        super.addCixsGroup(container);
    }

    public void addWidgetsToCixsGroup(Composite container) {
    }

    public void addWidgetsToTargetGroup(Composite container) {
        this.mTargetWDDDirText = this.createDirectoryFieldEditor(container, "targetWDDDir", Messages.wdd_target_location_label + ':');
        this.mTargetCobolDirText = this.createDirectoryFieldEditor(container, "targetCobolDir", Messages.cobol_target_location_label + ':');
    }

    public void addWidgetsToCoxbGroup(Composite container) {
    }

    public void addWidgetsToDeploymentGroup(Composite container) {
        this.mDeploymentGroup = container;
        this.mTargetWarDirText = Cixs2JaxwsGeneratorWizardPage.createTextField((Composite)container, (IPreferenceStore)this.getStore(), (String)"targetJarDir", (String)(Messages.war_deployment_location_label + ':'));
        Cixs2JaxwsGeneratorWizardPage.createLabel((Composite)container, (String)(Messages.sample_configuration_transport_label + ":"));
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new RowLayout());
        this.mCixsProxyDeployHttpGroup = new Cixs2JaxwsProxyDeployHttpGroup(this);
        this.mCixsProxyDeployHttpGroup.createButton(composite);
        this.mCixsProxyDeployHttpGroup.createControls(container);
    }

    public void initExtendedWidgets(IProject project) {
        this.setTargetWDDDir(this.getDefaultTargetDir(this.getStore(), "com.legstar.eclipse.plugin.jaxwsgen.DefaultJ2eeWDDFolder"));
        this.setTargetCobolDir(this.getDefaultTargetDir(this.getStore(), "com.legstar.eclipse.plugin.jaxwsgen.cobolSampleFolder"));
        this.setTargetWarDir(this.getStore().getDefaultString("com.legstar.eclipse.plugin.jaxwsgen.DefaultTargetWarDir"));
        this.getWebServiceTargetGroup().initControls();
        this.getPojoTargetGroup().initControls();
        this.getCixsProxyDeployHttpGroup().initControls();
        if (!this.getWebServiceTargetGroup().getButton().getSelection() && !this.getPojoTargetGroup().getButton().getSelection()) {
            this.getWebServiceTargetGroup().getButton().setSelection(true);
        }
        if (!this.getCixsProxyDeployHttpGroup().getButton().getSelection()) {
            this.getCixsProxyDeployHttpGroup().getButton().setSelection(true);
        }
    }

    public void createExtendedListeners() {
        this.mTargetWDDDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Cixs2JaxwsGeneratorWizardPage.this.dialogChanged();
            }
        });
        this.mTargetCobolDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Cixs2JaxwsGeneratorWizardPage.this.dialogChanged();
            }
        });
        this.mTargetWarDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Cixs2JaxwsGeneratorWizardPage.this.dialogChanged();
            }
        });
        this.getWebServiceTargetGroup().createListeners();
        this.getPojoTargetGroup().createListeners();
        this.getCixsProxyDeployHttpGroup().createListeners();
    }

    public boolean validateExtendedWidgets() {
        this.getWebServiceTargetGroup().setVisibility();
        this.getPojoTargetGroup().setVisibility();
        this.getCixsProxyDeployHttpGroup().setVisibility();
        this.getShell().layout(new Control[]{this.mTargetGroup, this.mDeploymentGroup});
        if (this.getProxyTargetType() == ProxyTargetType.POJO && !this.getPojoTargetGroup().validateControls()) {
            return false;
        }
        if (this.getProxyTargetType() == ProxyTargetType.WEBSERVICE && !this.getWebServiceTargetGroup().validateControls()) {
            return false;
        }
        if (this.getCixsProxyDeployHttpGroup().getSelection() && !this.getCixsProxyDeployHttpGroup().validateControls()) {
            return false;
        }
        if (!this.checkDirectory(this.getTargetWDDDir(), Messages.invalid_wdd_target_location_msg)) {
            return false;
        }
        return this.checkDirectory(this.getTargetCobolDir(), Messages.invalid_cobol_target_location_msg);
    }

    public void storeExtendedProjectPreferences() {
        this.getPojoTargetGroup().storeProjectPreferences();
        this.getWebServiceTargetGroup().storeProjectPreferences();
        this.getCixsProxyDeployHttpGroup().storeProjectPreferences();
    }

    public final ProxyTargetType getProxyTargetType() {
        if (this.getPojoTargetGroup().getSelection()) {
            return ProxyTargetType.POJO;
        }
        if (this.getWebServiceTargetGroup().getSelection()) {
            return ProxyTargetType.WEBSERVICE;
        }
        return ProxyTargetType.POJO;
    }

    public void setTargetWDDDir(String targetWDDDir) {
        this.mTargetWDDDirText.setText(targetWDDDir);
    }

    public String getTargetWDDDir() {
        return this.mTargetWDDDirText.getText();
    }

    public AbstractCixsActivator getActivator() {
        return Activator.getDefault();
    }

    public final String getTargetCobolDir() {
        return this.mTargetCobolDirText.getText();
    }

    public final void setTargetCobolDir(String targetCobolDir) {
        this.mTargetCobolDirText.setText(targetCobolDir);
    }

    public final String getTargetWarDir() {
        return this.mTargetWarDirText.getText();
    }

    public final void setTargetWarDir(String targetWarDir) {
        this.mTargetWarDirText.setText(targetWarDir);
    }

    public CixsProxyPojoTargetGroup getPojoTargetGroup() {
        return this.mPojoTargetGroup;
    }

    public void setPojoTargetGroup(CixsProxyPojoTargetGroup pojoTargetGroup) {
        this.mPojoTargetGroup = pojoTargetGroup;
    }

    public CixsProxyWebServiceTargetGroup getWebServiceTargetGroup() {
        return this.mWebServiceTargetGroup;
    }

    public void setWebServiceTargetGroup(CixsProxyWebServiceTargetGroup webServiceTargetGroup) {
        this.mWebServiceTargetGroup = webServiceTargetGroup;
    }

    public Cixs2JaxwsProxyDeployHttpGroup getCixsProxyDeployHttpGroup() {
        return this.mCixsProxyDeployHttpGroup;
    }

    public void setCixsProxyDeployHttpGroup(Cixs2JaxwsProxyDeployHttpGroup cixsProxyDeployHttpGroup) {
        this.mCixsProxyDeployHttpGroup = cixsProxyDeployHttpGroup;
    }
}

