/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.eclipse.plugin.common.wizards;

import com.legstar.codegen.CodeGenMakeException;
import com.legstar.codegen.models.IAntBuildModel;
import com.legstar.eclipse.ant.AntLaunchException;
import com.legstar.eclipse.ant.AntLaunchHelper;
import com.legstar.eclipse.plugin.common.Activator;
import com.legstar.eclipse.plugin.common.Messages;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractWizardRunnable
implements IRunnableWithProgress {
    private IAntBuildModel mAntBuildModel;
    private IProject mTargetProject;
    private String mTargetAntFileName;
    private static final String PROBE_FILE_PREFIX = "probe";
    private static final String PROBE_FILE_SUFFIX = "tmp";

    public AbstractWizardRunnable(IAntBuildModel antBuildModel, String targetContainerRelativePathName, String targetAntFileName) throws InvocationTargetException {
        this.mAntBuildModel = antBuildModel;
        this.mTargetProject = AbstractWizardRunnable.getProject(targetContainerRelativePathName);
        this.mTargetAntFileName = targetAntFileName;
    }

    protected void createBuild(IProgressMonitor monitor, int scale) throws InvocationTargetException {
        monitor.setTaskName(Messages.ant_generating_task_label);
        try {
            File antFile = this.getAntFile();
            this.mAntBuildModel.setProbeFile(this.getProbeFile());
            this.mAntBuildModel.generateBuild(antFile);
            monitor.worked(1 * scale);
        }
        catch (CodeGenMakeException e) {
            throw new InvocationTargetException(e);
        }
    }

    protected void runBuild(IProgressMonitor monitor, int scale) throws InvocationTargetException {
        monitor.setTaskName(Messages.ant_running_task_label);
        try {
            this.getTargetProject().refreshLocal(2, null);
            IFile antFile = this.getGeneratedAntFile();
            AntLaunchHelper antHelper = new AntLaunchHelper(this.getGeneratedAntFile());
            ILaunch launch = antHelper.execute((IProgressMonitor)new SubProgressMonitor(monitor, 1 * scale));
            for (IProcess process : launch.getProcesses()) {
                String errorMessage;
                if (!process.getLaunch().equals(launch)) continue;
                while (!process.isTerminated()) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e1) {
                        monitor.worked(1 * scale);
                        return;
                    }
                }
                IStreamsProxy streamsProxy = process.getStreamsProxy();
                if (streamsProxy != null && (errorMessage = streamsProxy.getErrorStreamMonitor().getContents()) != null && errorMessage.length() > 0) {
                    AntLaunchException th = new AntLaunchException(NLS.bind((String)Messages.ant_failure_stream_msg, (Object)antFile.getName(), (Object)errorMessage));
                    throw new InvocationTargetException(th);
                }
                if (process.getExitValue() == 0) continue;
                AntLaunchException th = new AntLaunchException(NLS.bind((String)Messages.ant_failure_retcode_msg, (Object)antFile.getName(), (Object)process.getExitValue()));
                throw new InvocationTargetException(th);
            }
            this.getTargetProject().refreshLocal(2, null);
            if (!this.checkProbeFile()) {
                AntLaunchException th = new AntLaunchException(NLS.bind((String)Messages.ant_failure_console_msg, (Object)antFile.getName()));
                throw new InvocationTargetException(th);
            }
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        finally {
            monitor.worked(1 * scale);
        }
    }

    protected File getAntFile() {
        File antFile = new File(this.getTargetAntScriptLocation().toOSString() + File.separatorChar + this.getTargetAntFileName());
        return antFile;
    }

    protected File getProbeFile() throws CodeGenMakeException {
        try {
            return File.createTempFile(PROBE_FILE_PREFIX, PROBE_FILE_SUFFIX);
        }
        catch (IOException e) {
            throw new CodeGenMakeException((Exception)e);
        }
    }

    protected boolean checkProbeFile() {
        File probeFile = this.mAntBuildModel.getProbeFile();
        return probeFile == null || !probeFile.exists();
    }

    protected IPath getTargetAntScriptLocation() {
        IPath antFolder = this.getAntFolderAbsolutePath();
        this.mkDir(antFolder);
        return antFolder;
    }

    protected IPath getAntFolderRelativePath() {
        IPath projectPath = this.mTargetProject.getFullPath();
        IPath containerPath = projectPath.append(this.getPreferenceAntFolder());
        return containerPath;
    }

    protected IPath getAntFolderAbsolutePath() {
        IPath projectPath = this.mTargetProject.getLocation();
        IPath containerPath = projectPath.append(this.getPreferenceAntFolder());
        return containerPath;
    }

    protected IPath getAntFileRelativePath() {
        IPath containerPath = this.getAntFolderRelativePath();
        return containerPath.append(this.getTargetAntFileName());
    }

    protected IFile getGeneratedAntFile() {
        IPath filePath = this.getAntFileRelativePath();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember(filePath);
        return (IFile)resource;
    }

    protected void mkDir(IPath path) {
        File folder = new File(path.toOSString());
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    public String getPreferenceAntFolder() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String antScriptsFolder = store.getString("com.legstar.eclipse.plugin.common.antScriptsFolder");
        if (antScriptsFolder == null) {
            return "";
        }
        return antScriptsFolder;
    }

    protected static IProject getProject(String relativePathName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember(relativePathName);
        return resource.getProject();
    }

    public static String getPluginInstallLocation(String pluginId) throws InvocationTargetException {
        return Activator.getPluginInstallLocation(pluginId);
    }

    protected IProject getTargetProject() {
        return this.mTargetProject;
    }

    protected String getTargetAntFileName() {
        return this.mTargetAntFileName;
    }

    public IAntBuildModel getAntBuildModel() {
        return this.mAntBuildModel;
    }

    public void setAntBuildModel(IAntBuildModel antBuildModel) {
        this.mAntBuildModel = antBuildModel;
    }
}

