/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.eclipse.plugin.common.wizards;

import com.legstar.eclipse.plugin.common.Activator;
import com.legstar.eclipse.plugin.common.Messages;
import com.legstar.eclipse.plugin.common.preferences.PreferenceUrlHistory;
import com.legstar.eclipse.plugin.common.wizards.AbstractWizard;
import com.legstar.eclipse.plugin.common.wizards.IURLSelectionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class AbstractWizardPage
extends WizardPage {
    private IStructuredSelection mInitialSelection = null;
    public static final int LAYOUT_COLUMNS = 3;
    private PreferenceUrlHistory mUrlHistory;

    public AbstractWizardPage(IStructuredSelection initialSelection, String pageName, String title, String description) {
        super(pageName);
        this.setTitle(title);
        this.setDescription(description);
        this.mInitialSelection = initialSelection;
        this.mUrlHistory = new PreferenceUrlHistory(Activator.getDefault().getPreferenceStore(), "com.legstar.eclipse.plugin.common.historyUrl");
        ImageDescriptor image = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.legstar.eclipse.plugin.common", (String)Activator.LOGO_IMG);
        this.setImageDescriptor(image);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 9;
        container.setLayout((Layout)gridLayout);
        this.setControl((Control)container);
        this.createExtendedControls(container);
        this.initContents();
        this.dialogChanged();
    }

    public abstract void initContents();

    public abstract void createExtendedControls(Composite var1);

    public abstract void dialogChanged();

    public static Label createLabel(Composite container, String text) {
        return AbstractWizardPage.createLabel(container, text, 1);
    }

    public static Label createLabel(Composite container, String text, int span) {
        Label label = new Label(container, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = span;
        label.setLayoutData((Object)gridData);
        label.setText(text);
        return label;
    }

    public static Text createText(Composite container) {
        return AbstractWizardPage.createText(container, 1);
    }

    public static Text createText(Composite container, int span) {
        Text text = new Text(container, 2052);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = span;
        text.setLayoutData((Object)gridData);
        return text;
    }

    public static Button createButton(Composite parent, String text) {
        Button button = new Button(parent, 8);
        button.setText(text);
        return button;
    }

    public static Group createGroup(Composite container, String text) {
        return AbstractWizardPage.createGroup(container, text, 3);
    }

    public static Combo createCombo(Composite container) {
        Combo combo = new Combo(container, 2564);
        combo.setLayoutData((Object)new GridData(768));
        return combo;
    }

    public static Canvas createCanvas(Composite container, int columns) {
        Canvas canvas = new Canvas(container, 0);
        GridData groupGridData = new GridData(768);
        groupGridData.horizontalSpan = 3;
        canvas.setLayoutData((Object)groupGridData);
        canvas.setLayout((Layout)new GridLayout(columns, false));
        return canvas;
    }

    public static Group createGroup(Composite container, String text, int columns) {
        Group group = new Group(container, 16);
        GridData groupGridData = new GridData(768);
        groupGridData.horizontalSpan = 3;
        group.setLayoutData((Object)groupGridData);
        group.setLayout((Layout)new GridLayout(columns, false));
        group.setText(text);
        return group;
    }

    public Text createDirectoryFieldEditor(Composite container, String preferenceName, String labelText) {
        DirectoryFieldEditor editor = new DirectoryFieldEditor(preferenceName, labelText, container);
        return editor.getTextControl(container);
    }

    public static Text createTextField(Composite container, IPreferenceStore store, String preferenceName, String labelText) {
        AbstractWizardPage.createLabel(container, labelText);
        Text text = AbstractWizardPage.createText(container);
        if (preferenceName != null) {
            text.setText(store.getString(preferenceName));
        }
        return text;
    }

    public Button createBrowseForContainerButton(Composite container, final String dialogTitle, final Text result) {
        Button button = new Button(container, 8);
        button.setText(Messages.browse_button_label);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Path destPath = AbstractWizardPage.this.handleBrowseForContainer(dialogTitle);
                if (destPath == null) {
                    result.setText("");
                } else {
                    result.setText(destPath.toOSString());
                }
            }
        });
        return button;
    }

    public Button createBrowseForFolderButton(Composite container, final String dialogTitle, final Text result) {
        Button button = new Button(container, 8);
        button.setText(Messages.browse_button_label);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String folderName = AbstractWizardPage.this.handleBrowseForDirectory(dialogTitle);
                result.setText(folderName);
            }
        });
        return button;
    }

    public Button createBrowseForFileContentButton(Composite container, final String dialogTitle, final Text result) {
        Button button = new Button(container, 8);
        button.setText(Messages.browse_button_label);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                result.setText(AbstractWizardPage.this.selectSingleFileContent(dialogTitle));
            }
        });
        return button;
    }

    public String selectSingleFileContent(String dialogTitle) {
        String fileName = this.handleBrowseForFiles(dialogTitle);
        StringBuilder sb = new StringBuilder();
        if (fileName != null) {
            try {
                sb.append(AbstractWizardPage.getContent(fileName));
            }
            catch (IOException e1) {
                sb.append(NLS.bind((String)Messages.file_open_error_msg, (Object)fileName, (Object)e1.getMessage()));
            }
        }
        return sb.toString();
    }

    public String handleBrowseForFiles(String dialogTitle) {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText(dialogTitle);
        return dialog.open();
    }

    public String handleBrowseForDirectory(String dialogTitle) {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4096);
        dialog.setText(dialogTitle);
        return dialog.open();
    }

    public static String getContent(String fileName) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        StringBuilder resStr = new StringBuilder();
        String str = in.readLine();
        while (str != null) {
            resStr.append(str + '\n');
            str = in.readLine();
        }
        in.close();
        return resStr.toString();
    }

    public ImageHyperlink createHyperlink(Composite container, String text, Image image, IHyperlinkListener listener) {
        return this.createHyperlink(container, text, image, 3, listener);
    }

    public ImageHyperlink createHyperlink(Composite container, String text, Image image, int span, IHyperlinkListener listener) {
        ImageHyperlink link = new ImageHyperlink(container, 0);
        link.setText(text);
        link.setImage(image);
        link.setUnderlined(true);
        link.addHyperlinkListener(listener);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = span;
        link.setLayoutData((Object)gridData);
        return link;
    }

    public Combo createUrlComboGroup(Composite container, final String urlType, ModifyListener modifyListener, final IURLSelectionListener selectionListener) {
        AbstractWizardPage.createLabel(container, urlType + " URL");
        final Combo urlCombo = AbstractWizardPage.createCombo(container);
        ImageHyperlink link = this.createHyperlink(container, NLS.bind((String)Messages.url_select_from_file_system_text, (Object)urlType), PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"), 2, (IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String fileName = AbstractWizardPage.this.handleBrowseForFiles(NLS.bind((String)Messages.url_select_a_file_label, (Object)urlType));
                if (fileName != null && fileName.length() > 0) {
                    urlCombo.setText(fileName);
                    selectionListener.urlSelected(urlCombo.getText());
                    AbstractWizardPage.this.getUrlHistory().add(urlCombo.getText());
                }
            }
        });
        urlCombo.moveBelow((Control)link);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        urlCombo.setLayoutData((Object)gridData);
        urlCombo.addModifyListener(modifyListener);
        Button getButton = AbstractWizardPage.createButton(container, Messages.go_button_label);
        getButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                selectionListener.urlSelected(urlCombo.getText());
                AbstractWizardPage.this.getUrlHistory().add(urlCombo.getText());
            }
        });
        return urlCombo;
    }

    private Path handleBrowseForContainer(String dialogTitle) {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), null, true, dialogTitle);
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            return (Path)result[0];
        }
        return null;
    }

    public void updateStatus(String errorMessage) {
        if (this.getNextPage() == null) {
            ((AbstractWizard)this.getWizard()).setCanFinish(errorMessage == null);
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    public boolean lookupContainerLibrary(IJavaProject jproject, String libraryName) {
        try {
            IClasspathEntry[] cpe = jproject.getRawClasspath();
            for (int i = 0; i < cpe.length; ++i) {
                if (cpe[i].getEntryKind() != 5 || !cpe[i].getPath().equals(new Path(libraryName))) continue;
                return true;
            }
            return false;
        }
        catch (JavaModelException e) {
            return false;
        }
    }

    public void setupContainerLibrary(IJavaProject jproject, String libraryName) throws JavaModelException {
        IClasspathEntry varEntry = JavaCore.newContainerEntry((IPath)new Path(libraryName), (boolean)false);
        ArrayList<IClasspathEntry> sourceEntries = new ArrayList<IClasspathEntry>();
        for (IClasspathEntry entry : jproject.getRawClasspath()) {
            sourceEntries.add(entry);
        }
        sourceEntries.add(varEntry);
        IClasspathEntry[] entries = sourceEntries.toArray(new IClasspathEntry[sourceEntries.size()]);
        jproject.setRawClasspath(entries, null);
    }

    public IStructuredSelection getInitialSelection() {
        return this.mInitialSelection;
    }

    public void setInitialSelection(IStructuredSelection initialSelection) {
        this.mInitialSelection = initialSelection;
    }

    public static void errorDialog(Shell shell, String dialogTitle, String pluginID, String shortMessage, String reason) {
        AbstractWizard.errorDialog(shell, dialogTitle, pluginID, shortMessage, reason);
    }

    public static void logCoreException(Throwable innerException, String pluginID) {
        AbstractWizard.logCoreException(innerException, pluginID);
    }

    public static void throwCoreException(Exception e) throws CoreException {
        AbstractWizard.throwCoreException(e);
    }

    public static void throwCoreException(String message) throws CoreException {
        AbstractWizard.throwCoreException(message);
    }

    public PreferenceUrlHistory getUrlHistory() {
        return this.mUrlHistory;
    }

    public void setUrlHistory(PreferenceUrlHistory urlHistory) {
        this.mUrlHistory = urlHistory;
    }
}

