/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.eclipse.plugin.common.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceUrlHistory {
    public static final int HISTORY_SIZE = 10;
    private IPreferenceStore mStore;
    private String mKeyPrefix;

    public PreferenceUrlHistory(IPreferenceStore store, String keyPrefix) {
        this.mStore = store;
        this.mKeyPrefix = keyPrefix;
    }

    public void add(String value) {
        List<String> history = this.get();
        if (history.contains(value)) {
            return;
        }
        if (history.size() >= 10) {
            history.remove(0);
        }
        history.add(value);
        this.set(history);
    }

    public List<String> get() {
        String value;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < 10 && (value = this.mStore.getString(this.mKeyPrefix + i)).length() != 0; ++i) {
            list.add(value);
        }
        return list;
    }

    public void set(List<String> history) {
        int i = 0;
        for (String value : history) {
            this.mStore.setValue(this.mKeyPrefix + i, value);
            ++i;
        }
    }
}

