/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.eclipse.plugin.common.dialogs;

import com.legstar.eclipse.plugin.common.Activator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractDialog
extends Dialog {
    private String mPluginID;

    public AbstractDialog(Shell parentShell, String pluginID) {
        super(parentShell);
        this.mPluginID = pluginID;
    }

    public static Label createLabel(Composite area, String text) {
        return AbstractDialog.createLabel(area, text, 1);
    }

    public static Label createLabel(Composite area, String text, int span) {
        Label label = new Label(area, 0);
        label.setText(text);
        GridData gridData = new GridData(4);
        gridData.horizontalSpan = span;
        label.setLayoutData((Object)gridData);
        return label;
    }

    public static Text createText(Composite container, String initText, int width) {
        return AbstractDialog.createText(container, initText, width, 1);
    }

    public static Text createText(Composite container, String initText, int width, int span) {
        GridData gridData;
        Text text = new Text(container, 2052);
        if (width > -1) {
            gridData = new GridData();
            gridData.widthHint = width;
        } else {
            gridData = new GridData(768);
        }
        gridData.horizontalSpan = span;
        text.setLayoutData((Object)gridData);
        if (initText != null) {
            text.setText(initText);
        }
        return text;
    }

    public static Button createButton(Composite parent, String text) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setLayoutData((Object)new GridData(768));
        button.setEnabled(false);
        return button;
    }

    public static TableColumn createTableColumn(Table table, int style, String title, int width) {
        TableColumn tc = new TableColumn(table, style);
        tc.setText(title);
        tc.setResizable(true);
        if (width > -1) {
            tc.setWidth(width);
        } else {
            tc.pack();
        }
        return tc;
    }

    public static TableColumn createTableColumn(Table table, int style, String title) {
        return AbstractDialog.createTableColumn(table, style, title, -1);
    }

    public static Combo createCombo(Composite area) {
        Combo combo = new Combo(area, 2572);
        combo.setLayoutData((Object)new GridData(768));
        return combo;
    }

    public static List createList(Composite area) {
        return AbstractDialog.createList(area, 1);
    }

    public static List createList(Composite area, int span) {
        List list = new List(area, 2572);
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        gd.heightHint = 100;
        list.setLayoutData((Object)gd);
        return list;
    }

    public String getPluginID() {
        return this.mPluginID;
    }

    public void errorDialog(String dialogTitle, String message) {
        Status status = new Status(4, "com.legstar.eclipse.plugin.common", 4, message, null);
        ErrorDialog.openError((Shell)this.getShell(), (String)dialogTitle, null, (IStatus)status);
    }

    public void throwCoreException(Exception e) throws CoreException {
        Activator.throwCoreException(e);
    }

    public void throwCoreException(String message) throws CoreException {
        Activator.throwCoreException(message);
    }
}

