/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.eclipse.plugin.common;

import com.legstar.eclipse.plugin.common.Activator;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public abstract class AbstractClasspathInitializer
extends ClasspathContainerInitializer {
    private String mLibraryName;
    private String mLibraryDescription;
    private String mPluginId;

    public AbstractClasspathInitializer(String pluginId, String libraryName, String libraryDescription) {
        this.mPluginId = pluginId;
        this.mLibraryName = libraryName;
        this.mLibraryDescription = libraryDescription;
    }

    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        JavaCore.setClasspathContainer((IPath)new Path(this.mLibraryName), (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{new IClasspathContainer(){

            public IClasspathEntry[] getClasspathEntries() {
                return AbstractClasspathInitializer.this.getLegStarClassPath();
            }

            public String getDescription() {
                return AbstractClasspathInitializer.this.mLibraryDescription;
            }

            public int getKind() {
                return 2;
            }

            public IPath getPath() {
                return new Path(AbstractClasspathInitializer.this.mLibraryName);
            }
        }}, null);
    }

    private IClasspathEntry[] getLegStarClassPath() {
        try {
            String path;
            ArrayList<IClasspathEntry> pathEntries = new ArrayList<IClasspathEntry>();
            File libraryFolder = new File(Activator.getPluginInstallLocation(this.mPluginId) + "/lib");
            File[] files = libraryFolder.listFiles(new JarFilter());
            Path sourcesPath = null;
            for (File file : files) {
                path = file.getAbsolutePath();
                if (!path.contains("Legstar") || !path.endsWith("-sources.jar")) continue;
                sourcesPath = new Path(path);
            }
            for (File file : files) {
                path = file.getAbsolutePath();
                Path sourceAttachmentPath = path.contains("legstar") ? sourcesPath : null;
                pathEntries.add(JavaCore.newLibraryEntry((IPath)new Path(path), (IPath)sourceAttachmentPath, null, (boolean)false));
            }
            return pathEntries.toArray(new IClasspathEntry[pathEntries.size()]);
        }
        catch (InvocationTargetException e) {
            Activator.logCoreException(e.getTargetException(), this.mPluginId);
            return null;
        }
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return true;
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer containerSuggestion) throws CoreException {
        JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{containerSuggestion}, null);
    }

    private class JarFilter
    implements FilenameFilter {
        private JarFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".jar");
        }
    }
}

