/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.eclipse.plugin.cixscom.wizards;

import com.legstar.cixs.gen.model.options.WebServiceParameters;
import com.legstar.eclipse.plugin.cixscom.Messages;
import com.legstar.eclipse.plugin.cixscom.dialogs.WsdlPortSelectionDialog;
import com.legstar.eclipse.plugin.cixscom.wizards.AbstractCixsControlsGroup;
import com.legstar.eclipse.plugin.cixscom.wizards.AbstractCixsGeneratorWizardPage;
import com.legstar.eclipse.plugin.common.wizards.AbstractWizardPage;
import com.legstar.eclipse.plugin.common.wizards.IURLSelectionListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class CixsProxyWebServiceTargetGroup
extends AbstractCixsControlsGroup {
    private Combo mWsdlUrlCombo = null;
    private Text mWsdlServiceNameText = null;
    private Text mWsdlPortNameText = null;
    private Text mWsdlTargetNamespaceText = null;

    public CixsProxyWebServiceTargetGroup(AbstractCixsGeneratorWizardPage wizardPage) {
        super(wizardPage);
    }

    public void createButton(Composite composite) {
        super.createButton(composite, "Web Service");
    }

    public void createControls(Composite composite) {
        super.createControls(composite, Messages.target_web_service_group_label, 3);
        this.mWsdlUrlCombo = this.getWizardPage().createUrlComboGroup((Composite)this.getGroup(), Messages.target_web_service_wsdl_url_label, new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        }, new URLSelectionAdapter());
        this.mWsdlServiceNameText = AbstractWizardPage.createTextField((Composite)this.getGroup(), null, null, (String)(Messages.target_web_service_wsdl_service_name_label + ':'));
        AbstractWizardPage.createLabel((Composite)this.getGroup(), (String)"");
        this.mWsdlPortNameText = AbstractWizardPage.createTextField((Composite)this.getGroup(), null, null, (String)(Messages.target_web_service_wsdl_port_name_label + ':'));
        AbstractWizardPage.createLabel((Composite)this.getGroup(), (String)"");
        this.mWsdlTargetNamespaceText = AbstractWizardPage.createTextField((Composite)this.getGroup(), null, null, (String)(Messages.target_web_service_wsdl_target_namespace_label + ':'));
    }

    public void createExtendedListeners() {
        this.mWsdlUrlCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CixsProxyWebServiceTargetGroup.this.getWizardPage().dialogChanged();
            }
        });
        this.mWsdlServiceNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CixsProxyWebServiceTargetGroup.this.getWizardPage().dialogChanged();
            }
        });
        this.mWsdlPortNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CixsProxyWebServiceTargetGroup.this.getWizardPage().dialogChanged();
            }
        });
        this.mWsdlTargetNamespaceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CixsProxyWebServiceTargetGroup.this.getWizardPage().dialogChanged();
            }
        });
    }

    public void initExtendedControls() {
        this.initWsdlUrl();
        this.setWsdlUrl(this.getProjectPreferences().get("com.legstar.eclipse.plugin.cixscom.proxy.LastWebServiceWsdlUrl", ""));
        this.setWsdlServiceName(this.getProjectPreferences().get("com.legstar.eclipse.plugin.cixscom.proxy.LastWebServiceWsdlServiceName", ""));
        this.setWsdlPortName(this.getProjectPreferences().get("com.legstar.eclipse.plugin.cixscom.proxy.LastWebServiceWsdlPortName", ""));
        this.setWsdlTargetNamespace(this.getProjectPreferences().get("com.legstar.eclipse.plugin.cixscom.proxy.LastWebServiceWsdlTargetNamespace", ""));
    }

    public void storeExtendedProjectPreferences() {
        this.getProjectPreferences().put("com.legstar.eclipse.plugin.cixscom.proxy.LastWebServiceWsdlUrl", this.getWsdlUrl());
        this.getProjectPreferences().put("com.legstar.eclipse.plugin.cixscom.proxy.LastWebServiceWsdlServiceName", this.getWsdlServiceName());
        this.getProjectPreferences().put("com.legstar.eclipse.plugin.cixscom.proxy.LastWebServiceWsdlPortName", this.getWsdlPortName());
        this.getProjectPreferences().put("com.legstar.eclipse.plugin.cixscom.proxy.LastWebServiceWsdlTargetNamespace", this.getWsdlTargetNamespace());
    }

    public boolean validateControls() {
        if (this.getWsdlUrl().length() == 0) {
            this.getWizardPage().updateStatus(Messages.invalid_wsdl_url_msg);
            return false;
        }
        if (this.getWsdlServiceName().length() == 0) {
            this.getWizardPage().updateStatus(Messages.invalid_wsdl_service_name_msg);
            return false;
        }
        if (this.getWsdlPortName().length() == 0) {
            this.getWizardPage().updateStatus(Messages.invalid_wsdl_port_name_msg);
            return false;
        }
        if (this.getWsdlTargetNamespace().length() == 0) {
            this.getWizardPage().updateStatus(Messages.invalid_target_namespace_msg);
            return false;
        }
        return true;
    }

    private void initWsdlUrl() {
        for (String value : this.getWizardPage().getUrlHistory().get()) {
            this.mWsdlUrlCombo.add(value);
        }
    }

    public String getWsdlUrl() {
        return this.mWsdlUrlCombo.getText();
    }

    public void setWsdlUrl(String wsdlUrl) {
        this.mWsdlUrlCombo.setText(wsdlUrl);
    }

    public String getWsdlServiceName() {
        return this.mWsdlServiceNameText.getText();
    }

    public void setWsdlServiceName(String wsdlServiceName) {
        this.mWsdlServiceNameText.setText(wsdlServiceName);
    }

    public String getWsdlPortName() {
        return this.mWsdlPortNameText.getText();
    }

    public void setWsdlPortName(String wsdlPortName) {
        this.mWsdlPortNameText.setText(wsdlPortName);
    }

    public void setWsdlTargetNamespace(String wsdlTargetNamespace) {
        this.mWsdlTargetNamespaceText.setText(wsdlTargetNamespace);
    }

    public String getWsdlTargetNamespace() {
        return this.mWsdlTargetNamespaceText.getText();
    }

    public WebServiceParameters getWebServiceTargetParameters() {
        WebServiceParameters webServiceParameters = new WebServiceParameters();
        webServiceParameters.setWsdlUrl(this.getWsdlUrl());
        webServiceParameters.setWsdlServiceName(this.getWsdlServiceName());
        webServiceParameters.setWsdlPortName(this.getWsdlPortName());
        webServiceParameters.setWsdlTargetNamespace(this.getWsdlTargetNamespace());
        return webServiceParameters;
    }

    private class URLSelectionAdapter
    implements IURLSelectionListener {
        private URLSelectionAdapter() {
        }

        public void urlSelected(String urlString) {
            WsdlPortSelectionDialog dlg = new WsdlPortSelectionDialog(CixsProxyWebServiceTargetGroup.this.getWsdlUrl(), CixsProxyWebServiceTargetGroup.this.getShell(), "com.legstar.eclipse.plugin.cixscom");
            if (0 == dlg.open()) {
                CixsProxyWebServiceTargetGroup.this.setWsdlTargetNamespace(dlg.getTargetNamespace());
                CixsProxyWebServiceTargetGroup.this.setWsdlServiceName(dlg.getServiceName());
                CixsProxyWebServiceTargetGroup.this.setWsdlPortName(dlg.getPortName());
            }
        }
    }
}

