/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.eclipse.plugin.cixscom.wizards;

import com.legstar.cixs.gen.model.options.CobolHttpClientType;
import com.legstar.cixs.gen.model.options.HttpTransportParameters;
import com.legstar.eclipse.plugin.cixscom.Messages;
import com.legstar.eclipse.plugin.cixscom.wizards.AbstractCixsControlsGroup;
import com.legstar.eclipse.plugin.cixscom.wizards.AbstractCixsGeneratorWizardPage;
import com.legstar.eclipse.plugin.common.wizards.AbstractWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractCixsProxyDeployHttpGroup
extends AbstractCixsControlsGroup {
    private Text mHttpHostText = null;
    private Text mHttpPortText = null;
    private Text mHttpPathText = null;
    private Text mHttpUserIdText = null;
    private Text mHttpPasswordText = null;
    private Button mDfhwbcliButton = null;
    private Button mWebapiButton = null;
    private Button mLegstarButton = null;

    public AbstractCixsProxyDeployHttpGroup(AbstractCixsGeneratorWizardPage wizardPage) {
        super(wizardPage);
    }

    public void createButton(Composite composite) {
        super.createButton(composite, "HTTP");
    }

    public void createControls(Composite composite) {
        super.createControls(composite, Messages.http_transport_group_label, 2);
        AbstractWizardPage.createLabel((Composite)this.getGroup(), (String)(Messages.http_host_label + ':'));
        this.mHttpHostText = AbstractWizardPage.createText((Composite)this.getGroup());
        AbstractWizardPage.createLabel((Composite)this.getGroup(), (String)(Messages.http_port_label + ':'));
        this.mHttpPortText = AbstractWizardPage.createText((Composite)this.getGroup());
        AbstractWizardPage.createLabel((Composite)this.getGroup(), (String)(Messages.http_path_label + ':'));
        this.mHttpPathText = AbstractWizardPage.createText((Composite)this.getGroup());
        AbstractWizardPage.createLabel((Composite)this.getGroup(), (String)(Messages.http_userid_label + ':'));
        this.mHttpUserIdText = AbstractWizardPage.createText((Composite)this.getGroup());
        AbstractWizardPage.createLabel((Composite)this.getGroup(), (String)(Messages.http_password_label + ':'));
        this.mHttpPasswordText = AbstractWizardPage.createText((Composite)this.getGroup());
        AbstractWizardPage.createLabel((Composite)this.getGroup(), (String)(Messages.sample_cobol_http_client_type_label + ':'));
        Composite buttonsComposite = new Composite((Composite)this.getGroup(), 0);
        buttonsComposite.setLayout((Layout)new RowLayout());
        this.mDfhwbcliButton = new Button(buttonsComposite, 16);
        this.mDfhwbcliButton.setText("CICS DFHWBCLI");
        this.mWebapiButton = new Button(buttonsComposite, 16);
        this.mWebapiButton.setText("CICS WEB API");
        this.mLegstarButton = new Button(buttonsComposite, 16);
        this.mLegstarButton.setText("LEGSTAR API");
    }

    public boolean validateControls() {
        if (this.getHttpHost() == null || this.getHttpHost().length() == 0) {
            this.getWizardPage().updateStatus(Messages.invalid_http_host_msg);
            return false;
        }
        try {
            if (Integer.parseInt(this.getHttpPort()) < 0 || Integer.parseInt(this.getHttpPort()) > 65536) {
                this.getWizardPage().updateStatus(Messages.invalid_http_port_number_msg);
                return false;
            }
        }
        catch (NumberFormatException e) {
            this.getWizardPage().updateStatus(Messages.invalid_http_port_number_msg);
            return false;
        }
        if (this.getHttpPath() != null && this.getHttpPath().length() > 0 && this.getHttpPath().charAt(0) != '/') {
            this.getWizardPage().updateStatus(Messages.invalid_http_path_msg);
            return false;
        }
        return true;
    }

    public void createExtendedListeners() {
        this.mHttpHostText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractCixsProxyDeployHttpGroup.this.getWizardPage().dialogChanged();
            }
        });
        this.mHttpPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractCixsProxyDeployHttpGroup.this.getWizardPage().dialogChanged();
            }
        });
        this.mHttpPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractCixsProxyDeployHttpGroup.this.getWizardPage().dialogChanged();
            }
        });
        this.mHttpUserIdText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractCixsProxyDeployHttpGroup.this.getWizardPage().dialogChanged();
            }
        });
        this.mHttpPasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractCixsProxyDeployHttpGroup.this.getWizardPage().dialogChanged();
            }
        });
        this.mDfhwbcliButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractCixsProxyDeployHttpGroup.this.getWizardPage().dialogChanged();
            }
        });
        this.mWebapiButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractCixsProxyDeployHttpGroup.this.getWizardPage().dialogChanged();
            }
        });
        this.mLegstarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractCixsProxyDeployHttpGroup.this.getWizardPage().dialogChanged();
            }
        });
    }

    public HttpTransportParameters getHttpTransportParameters() {
        HttpTransportParameters httpTransportParameters = new HttpTransportParameters();
        httpTransportParameters.setHost(this.getHttpHost());
        httpTransportParameters.setPort(Integer.parseInt(this.getHttpPort()));
        httpTransportParameters.setPath(this.getHttpPath());
        httpTransportParameters.setUserId(this.getHttpUserId());
        httpTransportParameters.setPassword(this.getHttpPassword());
        return httpTransportParameters;
    }

    public String getHttpHost() {
        return this.mHttpHostText.getText();
    }

    public void setHttpHost(String httpHost) {
        this.mHttpHostText.setText(httpHost);
    }

    public String getHttpPort() {
        return this.mHttpPortText.getText();
    }

    public void setHttpPort(String httpPort) {
        this.mHttpPortText.setText(httpPort);
    }

    public String getHttpPath() {
        return this.mHttpPathText.getText();
    }

    public void setHttpPath(String httpPath) {
        this.mHttpPathText.setText(httpPath);
    }

    public String getHttpUserId() {
        return this.mHttpUserIdText.getText();
    }

    public void setHttpUserId(String httpUserId) {
        this.mHttpUserIdText.setText(httpUserId);
    }

    public String getHttpPassword() {
        return this.mHttpPasswordText.getText();
    }

    public void setHttpPassword(String httpPassword) {
        this.mHttpPasswordText.setText(httpPassword);
    }

    public CobolHttpClientType getSampleCobolHttpClientType() {
        if (this.mDfhwbcliButton.getSelection()) {
            return CobolHttpClientType.DFHWBCLI;
        }
        if (this.mWebapiButton.getSelection()) {
            return CobolHttpClientType.WEBAPI;
        }
        if (this.mLegstarButton.getSelection()) {
            return CobolHttpClientType.LSHTTAPI;
        }
        return CobolHttpClientType.DFHWBCLI;
    }

    public Button getDfhwbcliButton() {
        return this.mDfhwbcliButton;
    }

    public void setDfhwbcliButton(Button dfhwbcliButton) {
        this.mDfhwbcliButton = dfhwbcliButton;
    }

    public Button getWebapiButton() {
        return this.mWebapiButton;
    }

    public void setWebapiButton(Button webapiButton) {
        this.mWebapiButton = webapiButton;
    }

    public Button getLegstarButton() {
        return this.mLegstarButton;
    }

    public void setLegstarButton(Button legstarButton) {
        this.mLegstarButton = legstarButton;
    }
}

