/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.eclipse.plugin.cixscom.wizards;

import com.legstar.cixs.gen.model.CixsMappingModel;
import com.legstar.cixs.gen.model.CixsModelException;
import com.legstar.codegen.CodeGenMakeException;
import com.legstar.codegen.CodeGenUtil;
import com.legstar.eclipse.plugin.cixscom.Messages;
import com.legstar.eclipse.plugin.cixscom.wizards.AbstractCixsActivator;
import com.legstar.eclipse.plugin.cixscom.wizards.AbstractCixsGeneratorWizard;
import com.legstar.eclipse.plugin.common.Activator;
import com.legstar.eclipse.plugin.common.wizards.AbstractWizard;
import com.legstar.eclipse.plugin.common.wizards.AbstractWizardPage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;

public abstract class AbstractCixsGeneratorWizardPage
extends AbstractWizardPage {
    private IFile mMappingFile = null;
    private CixsMappingModel mMappingModel = null;
    private Text mServiceNameText = null;
    private Text mJavaClassesPackageNameText = null;
    private Text mJaxbBinDirText = null;
    private Text mCoxbBinDirText = null;
    private Text mCustBinDirText = null;
    private Text mTargetSrcDirText = null;
    private Text mTargetBinDirText = null;
    private Text mTargetAntDirText = null;
    private Text mTargetDistDirText = null;
    private Text mHostCharsetText = null;

    protected AbstractCixsGeneratorWizardPage(IStructuredSelection selection, String pageName, String pageTitle, String pageDesc, IFile mappingFile) {
        super(selection, pageName, pageTitle, pageDesc);
        this.mMappingFile = mappingFile;
        this.mMappingModel = this.loadMappingModel(this.mMappingFile);
    }

    public void createExtendedControls(Composite parent) {
        this.addCixsGroup(parent);
        TabFolder tabFolder = new TabFolder(parent, 0);
        GridData groupGridData = new GridData(768);
        groupGridData.horizontalSpan = 3;
        tabFolder.setLayoutData((Object)groupGridData);
        this.addDeploymentGroup(tabFolder);
        this.addTargetGroup(tabFolder);
        this.addCoxbGroup(tabFolder);
    }

    protected void addCixsGroup(Composite container) {
        Group group = AbstractCixsGeneratorWizardPage.createGroup((Composite)container, (String)Messages.generation_project_label, (int)2);
        AbstractCixsGeneratorWizardPage.createLabel((Composite)group, (String)(Messages.generation_project_name_label + ':'));
        this.mServiceNameText = AbstractCixsGeneratorWizardPage.createText((Composite)group);
        AbstractCixsGeneratorWizardPage.createLabel((Composite)group, (String)(Messages.generation_java_package_label + ':'));
        this.mJavaClassesPackageNameText = AbstractCixsGeneratorWizardPage.createText((Composite)group);
        this.addWidgetsToCixsGroup((Composite)group);
    }

    private void addCoxbGroup(TabFolder tabFolder) {
        Canvas canvas = AbstractCixsGeneratorWizardPage.createCanvasInFolder(tabFolder, Messages.structures_binding_classes_label, 3);
        Canvas canvas2 = AbstractCixsGeneratorWizardPage.createCanvas((Composite)canvas, (int)3);
        this.mJaxbBinDirText = this.createDirectoryFieldEditor((Composite)canvas2, "com.legstar.eclipse.plugin.cixscom.jaxbBinDir", Messages.jaxb_classes_location_label + ':');
        this.mCoxbBinDirText = this.createDirectoryFieldEditor((Composite)canvas2, "com.legstar.eclipse.plugin.cixscom.coxbBinDir", Messages.coxb_classes_location_label + ':');
        this.mCustBinDirText = this.createDirectoryFieldEditor((Composite)canvas2, "com.legstar.eclipse.plugin.cixscom.custBinDir", Messages.cust_classes_location_label + ':');
        this.addWidgetsToCoxbGroup((Composite)canvas2);
    }

    private void addTargetGroup(TabFolder tabFolder) {
        Canvas canvas = AbstractCixsGeneratorWizardPage.createCanvasInFolder(tabFolder, Messages.generation_target_locations, 3);
        Canvas canvas2 = AbstractCixsGeneratorWizardPage.createCanvas((Composite)canvas, (int)3);
        this.mTargetSrcDirText = this.createDirectoryFieldEditor((Composite)canvas2, "com.legstar.eclipse.plugin.cixscom.targetSrcDir", Messages.java_sources_target_location + ':');
        this.mTargetBinDirText = this.createDirectoryFieldEditor((Composite)canvas2, "com.legstar.eclipse.plugin.cixscom.targetBinDir", Messages.java_classes_target_location + ':');
        this.mTargetAntDirText = this.createDirectoryFieldEditor((Composite)canvas2, "com.legstar.eclipse.plugin.cixscom.targetAntDir", Messages.ant_scripts_target_location + ':');
        this.mTargetDistDirText = this.createDirectoryFieldEditor((Composite)canvas2, "com.legstar.eclipse.plugin.cixscom.targetDistDir", Messages.distribution_files_target_location + ':');
        this.addWidgetsToTargetGroup((Composite)canvas2);
    }

    private void addDeploymentGroup(TabFolder tabFolder) {
        Canvas canvas = AbstractCixsGeneratorWizardPage.createCanvasInFolder(tabFolder, Messages.deployment_group_label, 2);
        this.mHostCharsetText = AbstractCixsGeneratorWizardPage.createTextField((Composite)canvas, (IPreferenceStore)this.getCommonStore(), (String)"com.legstar.eclipse.plugin.common.hostCharset", (String)(Messages.mainframe_charset_label + ':'));
        this.addWidgetsToDeploymentGroup((Composite)canvas);
    }

    public void initContents() {
        this.setServiceName(this.getDefaultServiceName());
        this.setJavaClassesPackageName(this.getDefaultJavaClassesPackageName());
        this.initJavaSrcAndBinDirs(this.getMappingFile().getProject());
        this.initCoxbDir();
        this.initOtherArtifactsDirs(this.getMappingFile().getProject());
        this.initExtendedWidgets(this.getMappingFile().getProject());
        this.createListeners();
    }

    public void createListeners() {
        this.mServiceNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractCixsGeneratorWizardPage.this.dialogChanged();
            }
        });
        this.mJavaClassesPackageNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractCixsGeneratorWizardPage.this.dialogChanged();
            }
        });
        this.mJaxbBinDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractCixsGeneratorWizardPage.this.dialogChanged();
            }
        });
        this.mCoxbBinDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractCixsGeneratorWizardPage.this.dialogChanged();
            }
        });
        this.mCustBinDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractCixsGeneratorWizardPage.this.dialogChanged();
            }
        });
        this.mTargetSrcDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractCixsGeneratorWizardPage.this.dialogChanged();
            }
        });
        this.mTargetBinDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractCixsGeneratorWizardPage.this.dialogChanged();
            }
        });
        this.mTargetAntDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractCixsGeneratorWizardPage.this.dialogChanged();
            }
        });
        this.mTargetDistDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractCixsGeneratorWizardPage.this.dialogChanged();
            }
        });
        this.mHostCharsetText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractCixsGeneratorWizardPage.this.dialogChanged();
            }
        });
        this.createExtendedListeners();
    }

    public abstract void createExtendedListeners();

    protected String getDefaultServiceName() {
        return this.getProjectPreferences().get("com.legstar.eclipse.plugin.cixscom.LastProjectName", AbstractCixsGeneratorWizardPage.javaNormalize(this.getMappingModel().getName()));
    }

    protected String getDefaultJavaClassesPackageName() {
        String prefix = this.getStore().getString("com.legstar.eclipse.plugin.cixscom.DefaultPackageNamePrefix");
        String defaultPackageName = prefix == null || prefix.length() == 0 ? this.getServiceName().toLowerCase() : prefix + '.' + this.getServiceName().toLowerCase();
        return this.getProjectPreferences().get("com.legstar.eclipse.plugin.cixscom.LastJavaClassesPackageName", defaultPackageName);
    }

    public static String javaNormalize(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            Character c = Character.valueOf(str.charAt(i));
            if (i == 0) {
                if (Character.isJavaIdentifierStart(c.charValue())) {
                    sb.append(c);
                    continue;
                }
                sb.append("C");
                continue;
            }
            if (!Character.isJavaIdentifierPart(c.charValue())) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public void dialogChanged() {
        if (this.getServiceName().length() == 0) {
            this.updateStatus(Messages.invalid_project_name_msg);
            return;
        }
        for (int i = 0; i < this.getServiceName().length(); ++i) {
            Character c = Character.valueOf(this.getServiceName().charAt(i));
            if (i == 0) {
                if (Character.isJavaIdentifierStart(c.charValue())) continue;
                this.updateStatus(Messages.invalid_project_name_msg);
                return;
            }
            if (Character.isJavaIdentifierPart(c.charValue())) continue;
            this.updateStatus(Messages.invalid_project_name_msg);
            return;
        }
        if (!this.checkDirectory(this.getJaxbBinDir(), NLS.bind((String)Messages.invalid_location_msg, (Object)Messages.jaxb_classes_location_label))) {
            return;
        }
        if (!this.checkDirectory(this.getCoxbBinDir(), NLS.bind((String)Messages.invalid_location_msg, (Object)Messages.coxb_classes_location_label))) {
            return;
        }
        if (!this.checkDirectory(this.getCustBinDir(), NLS.bind((String)Messages.invalid_location_msg, (Object)Messages.cust_classes_location_label))) {
            return;
        }
        if (!this.checkDirectory(this.getTargetSrcDir(), NLS.bind((String)Messages.invalid_location_msg, (Object)Messages.java_sources_target_location))) {
            return;
        }
        if (!this.checkDirectory(this.getTargetBinDir(), NLS.bind((String)Messages.invalid_location_msg, (Object)Messages.java_classes_target_location))) {
            return;
        }
        if (!this.checkDirectory(this.getTargetDistDir(), NLS.bind((String)Messages.invalid_location_msg, (Object)Messages.distribution_files_target_location))) {
            return;
        }
        if (!this.checkDirectory(this.getTargetAntDir(), NLS.bind((String)Messages.invalid_location_msg, (Object)Messages.ant_scripts_target_location))) {
            return;
        }
        try {
            CodeGenUtil.checkCharset((String)this.getHostCharset());
        }
        catch (CodeGenMakeException e) {
            this.updateStatus(Messages.invalid_mainframe_charset_msg);
            return;
        }
        if (!this.validateExtendedWidgets()) {
            return;
        }
        this.updateStatus(null);
        this.storeProjectPreferences();
    }

    private void storeProjectPreferences() {
        this.getProjectPreferences().put("com.legstar.eclipse.plugin.cixscom.LastProjectName", this.getServiceName());
        this.getProjectPreferences().put("com.legstar.eclipse.plugin.cixscom.LastJavaClassesPackageName", this.getJavaClassesPackageName());
        this.storeExtendedProjectPreferences();
        try {
            this.getProjectPreferences().flush();
        }
        catch (BackingStoreException e) {
            AbstractWizard.logCoreException((Throwable)e, (String)this.getActivator().getPluginId());
        }
    }

    public abstract void storeExtendedProjectPreferences();

    public abstract void addWidgetsToCixsGroup(Composite var1);

    public abstract void addWidgetsToCoxbGroup(Composite var1);

    public abstract void addWidgetsToTargetGroup(Composite var1);

    public abstract void addWidgetsToDeploymentGroup(Composite var1);

    public abstract void initExtendedWidgets(IProject var1);

    public abstract boolean validateExtendedWidgets();

    public abstract AbstractCixsActivator getActivator();

    protected static Canvas createCanvasInFolder(TabFolder tabFolder, String text, int columns) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(text);
        Canvas canvas = AbstractCixsGeneratorWizardPage.createCanvas((Composite)tabFolder, (int)columns);
        tabItem.setControl((Control)canvas);
        return canvas;
    }

    private void initJavaSrcAndBinDirs(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            IPath rootPath = javaProject.getProject().getLocation().removeLastSegments(1);
            try {
                IClasspathEntry[] cpe = javaProject.getRawClasspath();
                for (int i = 0; i < cpe.length; ++i) {
                    if (cpe[i].getEntryKind() != 3) continue;
                    this.setTargetSrcDir(rootPath.append(cpe[i].getPath()).toOSString());
                    if (cpe[i].getOutputLocation() == null) {
                        this.setTargetBinDir(rootPath.append(javaProject.getOutputLocation()).toOSString());
                    } else {
                        this.setTargetBinDir(rootPath.append(cpe[i].getOutputLocation()).toOSString());
                    }
                    return;
                }
            }
            catch (JavaModelException e) {
                AbstractWizard.errorDialog((Shell)this.getShell(), (String)Messages.generate_error_dialog_title, (String)this.getPluginId(), (String)Messages.java_location_lookup_failure_msg, (String)NLS.bind((String)Messages.invalid_java_project_msg, (Object)project.getName(), (Object)e.getMessage()));
                AbstractWizard.logCoreException((Throwable)e, (String)this.getPluginId());
            }
        }
        this.setTargetSrcDir(project.getLocation().toOSString());
        this.setTargetBinDir(project.getLocation().toOSString());
    }

    private void initCoxbDir() {
        this.setJaxbBinDir(this.getTargetBinDir());
        this.setCoxbBinDir(this.getTargetBinDir());
        this.setCustBinDir(this.getTargetBinDir());
    }

    private void initOtherArtifactsDirs(IProject project) {
        this.setTargetAntDir(this.getDefaultTargetDir(this.getCommonStore(), "com.legstar.eclipse.plugin.common.antScriptsFolder"));
        this.setTargetDistDir(this.getDefaultTargetDir(this.getStore(), "com.legstar.eclipse.plugin.cixscom.DistFolder"));
    }

    protected String getDefaultTargetDir(IPreferenceStore store, String storeKey) {
        IPath projectPath = this.getMappingFile().getProject().getLocation();
        String folder = store.getString(storeKey);
        String defaultValue = projectPath.append((IPath)new Path(folder)).toOSString();
        try {
            CodeGenUtil.checkDirectory((String)defaultValue, (boolean)true);
            this.getMappingFile().getProject().refreshLocal(2, null);
        }
        catch (IllegalArgumentException e) {
            this.updateStatus(NLS.bind((String)Messages.invalid_default_location_msg, (Object)defaultValue, (Object)storeKey));
        }
        catch (CoreException e) {
            this.updateStatus(NLS.bind((String)Messages.location_refresh_failure_msg, (Object)defaultValue, (Object)storeKey));
        }
        return defaultValue;
    }

    public IJavaProject getTargetJavaProject() {
        IContainer resource = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(this.getTargetSrcDir()));
        return JavaCore.create((IProject)resource.getProject());
    }

    protected boolean checkDirectory(String dir, String erorMessage) {
        try {
            CodeGenUtil.checkDirectory((String)dir, (boolean)false);
        }
        catch (IllegalArgumentException e1) {
            this.updateStatus(erorMessage);
            return false;
        }
        return true;
    }

    public void setServiceName(String serviceName) {
        this.mServiceNameText.setText(serviceName);
    }

    public String getServiceName() {
        return this.mServiceNameText.getText();
    }

    public void setJavaClassesPackageName(String javaClassesPackageName) {
        this.mJavaClassesPackageNameText.setText(javaClassesPackageName);
    }

    public String getJavaClassesPackageName() {
        return this.mJavaClassesPackageNameText.getText();
    }

    public void setJaxbBinDir(String jaxbBinDirLocation) {
        this.mJaxbBinDirText.setText(jaxbBinDirLocation);
    }

    public String getJaxbBinDir() {
        return this.mJaxbBinDirText.getText();
    }

    public void setCoxbBinDir(String coxbBinDirLocation) {
        this.mCoxbBinDirText.setText(coxbBinDirLocation);
    }

    public String getCoxbBinDir() {
        return this.mCoxbBinDirText.getText();
    }

    public void setCustBinDir(String custBinDirLocation) {
        this.mCustBinDirText.setText(custBinDirLocation);
    }

    public String getCustBinDir() {
        return this.mCustBinDirText.getText();
    }

    public void setTargetSrcDir(String targetSrcDirLocation) {
        this.mTargetSrcDirText.setText(targetSrcDirLocation);
    }

    public String getTargetSrcDir() {
        return this.mTargetSrcDirText.getText();
    }

    public void setTargetBinDir(String targetBinDirLocation) {
        this.mTargetBinDirText.setText(targetBinDirLocation);
    }

    public String getTargetBinDir() {
        return this.mTargetBinDirText.getText();
    }

    public CixsMappingModel getMappingModel() {
        return this.mMappingModel;
    }

    public void setTargetAntDir(String targetAntDirLocation) {
        this.mTargetAntDirText.setText(targetAntDirLocation);
    }

    public String getTargetAntDir() {
        return this.mTargetAntDirText.getText();
    }

    public void setTargetDistDir(String targetDistDirLocation) {
        this.mTargetDistDirText.setText(targetDistDirLocation);
    }

    public String getTargetDistDir() {
        return this.mTargetDistDirText.getText();
    }

    public void setHostCharset(String hostCharset) {
        this.mHostCharsetText.setText(hostCharset);
    }

    public String getHostCharset() {
        return this.mHostCharsetText.getText();
    }

    public IFile getMappingFile() {
        return this.mMappingFile;
    }

    private CixsMappingModel loadMappingModel(IFile mappingFile) {
        CixsMappingModel mappingModel = new CixsMappingModel();
        try {
            mappingModel.load(mappingFile.getLocation().toFile());
        }
        catch (CixsModelException e) {
            AbstractWizard.errorDialog((Shell)this.getShell(), (String)Messages.generate_error_dialog_title, (String)this.getPluginId(), (String)Messages.mapping_file_load_failure_short_msg, (String)NLS.bind((String)Messages.mapping_file_load_failure_long_msg, (Object)mappingFile.getName(), (Object)e.getMessage()));
            AbstractWizard.logCoreException((Throwable)e, (String)this.getPluginId());
        }
        return mappingModel;
    }

    public IPreferenceStore getCommonStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public IPreferenceStore getStore() {
        return this.getActivator().getPreferenceStore();
    }

    public String getPluginId() {
        return this.getActivator().getPluginId();
    }

    public IEclipsePreferences getProjectPreferences() {
        return ((AbstractCixsGeneratorWizard)this.getWizard()).getProjectPreferences();
    }
}

