/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.eclipse.plugin.cixscom.wizards;

import com.legstar.eclipse.plugin.cixscom.Messages;
import com.legstar.eclipse.plugin.cixscom.wizards.AbstractCixsGeneratorWizardRunnable;
import com.legstar.eclipse.plugin.common.wizards.AbstractWizard;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;

public abstract class AbstractCixsGeneratorWizard
extends AbstractWizard {
    private IStructuredSelection mInitialSelection;
    private IFile mMappingFile = null;
    private IEclipsePreferences mProjectPreferences;

    public AbstractCixsGeneratorWizard(IFile mappingFile) throws CoreException {
        this.setNeedsProgressMonitor(true);
        this.mMappingFile = mappingFile;
        ProjectScope context = new ProjectScope(this.getMappingFile().getProject());
        this.mProjectPreferences = context.getNode(this.getPluginId());
    }

    public abstract String getPluginId();

    public boolean performFinish() {
        try {
            AbstractCixsGeneratorWizardRunnable op = this.getRunnable();
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            AbstractCixsGeneratorWizard.errorDialog((Shell)this.getShell(), (String)Messages.generate_error_dialog_title, (String)this.getPluginId(), (String)Messages.generation_failure_short_msg, (String)NLS.bind((String)Messages.generation_failure_long_msg, (Object)this.mMappingFile.getName(), (Object)e.getTargetException()));
            AbstractCixsGeneratorWizard.logCoreException((Throwable)e.getTargetException(), (String)this.getPluginId());
            return false;
        }
        return true;
    }

    protected abstract AbstractCixsGeneratorWizardRunnable getRunnable() throws InvocationTargetException;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.mInitialSelection = selection;
    }

    public IStructuredSelection getInitialSelection() {
        return this.mInitialSelection;
    }

    public IFile getMappingFile() {
        return this.mMappingFile;
    }

    public IEclipsePreferences getProjectPreferences() {
        return this.mProjectPreferences;
    }
}

