/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.eclipse.plugin.cixscom.dialogs;

import com.legstar.eclipse.plugin.cixscom.Messages;
import com.legstar.eclipse.plugin.common.dialogs.AbstractDialog;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WsdlPortSelectionDialog
extends AbstractDialog {
    private String mWsdlUrl;
    private List mServicesList;
    private List mPortsList;
    private Text mTargetNamespaceText;
    private String mTargetNamespace;
    private String mServiceName;
    private String mPortName;

    public WsdlPortSelectionDialog(String wsdlUrl, Shell parentShell, String pluginID) {
        super(parentShell, pluginID);
        this.mWsdlUrl = wsdlUrl;
    }

    protected final Control createDialogArea(Composite parent) {
        parent.getShell().setText(Messages.wsdl_port_selection_dialog_title);
        Composite composite = (Composite)super.createDialogArea(parent);
        try {
            this.initialize(composite);
        }
        catch (CoreException e) {
            this.errorDialog(Messages.wsdl_port_selection_error_dialog_title, NLS.bind((String)Messages.wsdl_access_error_msg, (Object)this.mWsdlUrl, (Object)e.getMessage()));
            this.close();
        }
        return composite;
    }

    private void initialize(Composite parent) throws CoreException {
        Composite area = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        area.setLayout((Layout)gridLayout);
        WsdlPortSelectionDialog.createLabel((Composite)area, (String)(Messages.target_namespace_label + ':'));
        this.mTargetNamespaceText = WsdlPortSelectionDialog.createText((Composite)area, (String)"", (int)-1);
        this.mTargetNamespaceText.setEditable(false);
        WsdlPortSelectionDialog.createLabel((Composite)area, (String)(Messages.services_list_label + ':'));
        this.mServicesList = WsdlPortSelectionDialog.createList((Composite)area);
        this.mServicesList.setLayoutData((Object)new GridData(768));
        this.mServicesList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
                WsdlPortSelectionDialog.this.loadPorts();
            }

            public void widgetSelected(SelectionEvent arg0) {
                WsdlPortSelectionDialog.this.loadPorts();
            }
        });
        WsdlPortSelectionDialog.createLabel((Composite)area, (String)(Messages.ports_list_label + ':'));
        this.mPortsList = WsdlPortSelectionDialog.createList((Composite)area);
        this.mPortsList.setLayoutData((Object)new GridData(768));
        this.mPortsList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
                WsdlPortSelectionDialog.this.setSelection();
            }

            public void widgetSelected(SelectionEvent arg0) {
                WsdlPortSelectionDialog.this.setSelection();
            }
        });
        this.loadWsdl(this.getWsdlUrl());
    }

    private void loadWsdl(String wsdlUrl) throws CoreException {
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            Definition definition = reader.readWSDL(wsdlUrl);
            this.mTargetNamespaceText.setText(definition.getTargetNamespace());
            Map services = definition.getAllServices();
            for (QName serviceKey : services.keySet()) {
                this.mServicesList.add(serviceKey.getLocalPart());
                this.mServicesList.setData(serviceKey.getLocalPart(), services.get(serviceKey));
            }
            if (this.mServicesList.getItemCount() > 0) {
                this.mServicesList.select(0);
                this.loadPorts();
            }
        }
        catch (WSDLException e) {
            this.throwCoreException((Exception)((Object)e));
        }
    }

    private void loadPorts() {
        Service service = (Service)this.mServicesList.getData(this.mServicesList.getSelection()[0]);
        Map ports = service.getPorts();
        this.mPortsList.removeAll();
        for (String portKey : ports.keySet()) {
            this.mPortsList.add(portKey);
        }
        if (this.mPortsList.getItemCount() > 0) {
            this.mPortsList.select(0);
            this.setSelection();
        }
    }

    private void setSelection() {
        this.mTargetNamespace = this.mTargetNamespaceText.getText();
        this.mServiceName = this.mServicesList.getSelection()[0];
        this.mPortName = this.mPortsList.getSelection()[0];
    }

    public String getWsdlUrl() {
        return this.mWsdlUrl;
    }

    public String getTargetNamespace() {
        return this.mTargetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.mTargetNamespace = targetNamespace;
    }

    public String getServiceName() {
        return this.mServiceName;
    }

    public void setServiceName(String serviceName) {
        this.mServiceName = serviceName;
    }

    public String getPortName() {
        return this.mPortName;
    }

    public void setPortName(String portName) {
        this.mPortName = portName;
    }
}

